/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

@ParametersAreNonnullByDefault
public class PacketUtil {
    public static void playSound(ServerLevel level, Predicate<ServerPlayer> send, double x, double y, double z, SoundEvent sound, SoundSource soundSource, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)sound, (SoundSource)soundSource, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        sound = event.getSound();
        soundSource = event.getCategory();
        volume = event.getVolume();
        PacketUtil.broadcast(level, send.and(PacketUtil.distance(x, y, z, volume > 1.0f ? (double)(volume * 16.0f) : 16.0)), (ResourceKey<Level>)level.m_46472_(), new ClientboundSoundPacket(sound, soundSource, x, y, z, volume, pitch));
    }

    public static void playSound(ServerLevel level, Predicate<ServerPlayer> send, Vec3 position, SoundEvent sound, SoundSource soundSource, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)sound, (SoundSource)soundSource, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        sound = event.getSound();
        soundSource = event.getCategory();
        volume = event.getVolume();
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        PacketUtil.broadcast(level, send.and(PacketUtil.distance(x, y, z, volume > 1.0f ? (double)(volume * 16.0f) : 16.0)), (ResourceKey<Level>)level.m_46472_(), new ClientboundSoundPacket(sound, soundSource, x, y, z, volume, pitch));
    }

    public static Predicate<ServerPlayer> distance(double x, double y, double z, double distance) {
        return player -> {
            double dZ;
            double dY;
            double dX = x - player.m_20185_();
            return dX * dX + (dY = y - player.m_20186_()) * dY + (dZ = z - player.m_20189_()) * dZ < distance * distance;
        };
    }

    public static void broadcast(ServerLevel level, Predicate<ServerPlayer> send, ResourceKey<Level> pDimension, Packet<?> packet) {
        List players = level.m_142572_().m_6846_().m_11314_();
        for (ServerPlayer serverplayer : players) {
            if (serverplayer.f_19853_.m_46472_() != pDimension || !send.test(serverplayer)) continue;
            serverplayer.f_8906_.m_141995_(packet);
        }
    }
}

