/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.foxyas.changedaddon.network.ChangedAddonModVariables;
import net.foxyas.changedaddon.util.DelayedTask;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Triple;

public record TransfurSoundsGuiButtonMessage(int buttonId) {
    private static final List<Triple<ResourceLocation, Predicate<Player>, Integer>> sounds = List.of(Triple.of((Object)new ResourceLocation("entity.cat.purr"), PlayerUtil::isCatTransfur, (Object)60), Triple.of((Object)new ResourceLocation("entity.cat.ambient"), PlayerUtil::isCatTransfur, (Object)10), Triple.of((Object)new ResourceLocation("entity.wolf.growl"), PlayerUtil::isWolfTransfur, (Object)60), Triple.of((Object)new ResourceLocation("entity.wolf.ambient"), PlayerUtil::isWolfTransfur, (Object)10), Triple.of((Object)new ResourceLocation("entity.wolf.howl"), PlayerUtil::isWolfTransfur, (Object)80), Triple.of((Object)new ResourceLocation("entity.cat.hiss"), PlayerUtil::isCatTransfur, (Object)40), Triple.of((Object)new ResourceLocation("entity.cat.purreow"), PlayerUtil::isCatTransfur, (Object)20));

    public TransfurSoundsGuiButtonMessage(FriendlyByteBuf buf) {
        this(buf.m_130242_());
    }

    public static void buffer(TransfurSoundsGuiButtonMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.buttonId);
    }

    public static void handler(TransfurSoundsGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransfurSoundsGuiButtonMessage.handleButtonAction((Player)context.getSender(), message.buttonId));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player player, int buttonID) {
        if (player == null) {
            return;
        }
        if (!ProcessTransfur.isPlayerTransfurred((Player)player)) {
            return;
        }
        ChangedAddonModVariables.PlayerVariables vars = player.getCapability(ChangedAddonModVariables.PLAYER_VARIABLES_CAPABILITY).resolve().orElse(null);
        if (vars == null) {
            return;
        }
        switch (buttonID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Triple<ResourceLocation, Predicate<Player>, Integer> triple;
                if (vars.actCooldown || !((Predicate)(triple = sounds.get(buttonID)).getMiddle()).test(player)) break;
                TransfurSoundsGuiButtonMessage.playSound(player.f_19853_, (Entity)player, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)triple.getLeft()), vars, (Integer)triple.getRight());
                break;
            }
            case 7: {
                if (!vars.actCooldown) break;
                vars.actCooldown = false;
                vars.syncPlayerVariables((Entity)player);
                break;
            }
            case 8: {
                if (vars.actCooldown) {
                    return;
                }
                TransfurVariantInstance tf = ProcessTransfur.getPlayerTransfurVariant((Player)player);
                if (tf == null) break;
                if (tf.getFormId().toString().contains("changed_addon:form_experiment009")) {
                    player.m_183503_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, ChangedSounds.MONSTER2, SoundSource.HOSTILE, 35.0f, 0.0f);
                } else {
                    player.m_183503_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, ChangedSounds.MONSTER2, SoundSource.HOSTILE, 5.0f, 1.0f);
                }
                vars.actCooldown = true;
                vars.syncPlayerVariables((Entity)player);
                new DelayedTask(60, () -> {
                    vars.actCooldown = false;
                    vars.syncPlayerVariables((Entity)player);
                });
            }
        }
    }

    private static void playSound(Level level, Entity entity, SoundEvent sound, ChangedAddonModVariables.PlayerVariables vars, int cooldown) {
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound, SoundSource.PLAYERS, 2.0f, 1.0f);
        vars.actCooldown = true;
        vars.syncPlayerVariables(entity);
        new DelayedTask(cooldown, () -> {
            vars.actCooldown = false;
            vars.syncPlayerVariables(entity);
        });
    }
}

