/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import java.util.ArrayList;
import java.util.List;
import net.foxyas.changedaddon.configuration.ChangedAddonServerConfiguration;
import net.foxyas.changedaddon.init.ChangedAddonGameRules;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.process.variantsExtraStats.FormDietEvent;
import net.foxyas.changedaddon.variants.VariantExtraStats;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.beast.AbstractLatexWolf;
import net.ltxprogrammer.changed.entity.beast.AquaticEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.NotImplementedException;

@Mod.EventBusSubscriber
public class CreatureDietsHandleProcedure {
    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        TransfurVariant variant;
        if (event == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        ItemStack item = event.getItem();
        if (!item.m_41614_()) {
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        TransfurVariantInstance latexInstance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (latexInstance == null) {
            return;
        }
        Level world = player.m_183503_();
        if (world.f_46443_) {
            return;
        }
        if (!world.m_46469_().m_46207_(ChangedAddonGameRules.CHANGED_ADDON_CREATURE_DIETS)) {
            return;
        }
        ChangedEntity ChangedEntity2 = latexInstance.getChangedEntity();
        List<DietType> dietType = CreatureDietsHandleProcedure.determineDietTypes(ChangedEntity2, variant = ChangedEntity2.getSelfVariant());
        if (dietType.isEmpty()) {
            return;
        }
        if (dietType.stream().anyMatch(diet -> diet.isDietItem(item))) {
            CreatureDietsHandleProcedure.applyFoodEffects(variant, player, item, true);
            world.m_6269_(null, (Entity)player, SoundEvents.f_11912_, SoundSource.MASTER, 1.0f, 1.5f);
            return;
        }
        if (!((Boolean)ChangedAddonServerConfiguration.DEBUFFS.get()).booleanValue() || item.m_204117_(ChangedAddonTags.Items.NOT_FOOD) || (double)latexInstance.ageAsVariant >= (Double)ChangedAddonServerConfiguration.AGE_NEED.get()) {
            return;
        }
        CreatureDietsHandleProcedure.applyFoodEffects(variant, player, item, false);
        CreatureDietsHandleProcedure.applyDebuffs(player);
        world.m_6269_(null, (Entity)player, SoundEvents.f_11912_, SoundSource.MASTER, 1.0f, 0.0f);
    }

    private static void applyDebuffs(Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 3, false, true, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 160, 0, false, true, true, new MobEffectInstance(MobEffects.f_19613_, 100, 2)));
    }

    private static void applyFoodEffects(TransfurVariant<?> variant, Player player, ItemStack item, boolean isGoodFood) {
        float additionalSaturation;
        int additionalFood;
        FoodProperties properties = item.getFoodProperties((LivingEntity)player);
        assert (properties != null);
        if (isGoodFood) {
            additionalFood = properties.m_38744_() / 2;
            additionalSaturation = properties.m_38745_() / 2.0f;
        } else {
            additionalFood = -properties.m_38744_() / 4;
            additionalSaturation = -properties.m_38745_() / 4.0f;
        }
        FormDietEvent formDietEvent = new FormDietEvent(variant, (LivingEntity)player, isGoodFood, item, additionalFood, additionalSaturation);
        if (!MinecraftForge.EVENT_BUS.post((Event)formDietEvent)) {
            additionalFood = formDietEvent.additionalFood;
            additionalSaturation = formDietEvent.additionalSaturation;
            player.m_36324_().m_38707_(additionalFood, additionalSaturation);
        }
    }

    private static List<DietType> determineDietTypes(ChangedEntity changedEntity, TransfurVariant<?> variant) {
        if (variant.is(ChangedAddonTags.TransfurTypes.NO_DIET)) {
            return List.of();
        }
        ArrayList<DietType> dietTypes = new ArrayList<DietType>();
        for (DietType diet : DietType.values()) {
            if (!diet.hasDiet(changedEntity, variant)) continue;
            dietTypes.add(diet);
        }
        if (changedEntity instanceof VariantExtraStats) {
            VariantExtraStats stats = (VariantExtraStats)changedEntity;
            dietTypes.addAll(stats.getExtraDietTypes());
        }
        return dietTypes;
    }

    public static enum DietType implements IExtensibleEnum
    {
        AQUATIC(ChangedAddonTags.TransfurTypes.AQUATIC_DIET, ChangedAddonTags.Items.AQUATIC_DIET),
        SHARK(ChangedAddonTags.TransfurTypes.SHARK_DIET, ChangedAddonTags.Items.SHARK_DIET),
        CAT(ChangedAddonTags.TransfurTypes.CAT_DIET, ChangedAddonTags.Items.CAT_DIET),
        DRAGON(ChangedAddonTags.TransfurTypes.DRAGON_DIET, ChangedAddonTags.Items.DRAGON_DIET),
        FOX(ChangedAddonTags.TransfurTypes.FOX_DIET, ChangedAddonTags.Items.FOX_DIET),
        SWEET_TOOTH(ChangedAddonTags.TransfurTypes.SWEET_DIET, ChangedAddonTags.Items.SWEET_DIET),
        WOLF(ChangedAddonTags.TransfurTypes.WOLF_DIET, ChangedAddonTags.Items.WOLF_DIET),
        SPECIAL(ChangedAddonTags.TransfurTypes.SPECIAL_DIET, ChangedAddonTags.Items.SPECIAL_DIET);

        private final TagKey<TransfurVariant<?>> tfTag;
        private final TagKey<Item> dietTag;
        private final List<Item> dietItems;

        private DietType(TagKey<TransfurVariant<?>> tfTag, TagKey<Item> dietTag, List<Item> items) {
            this.tfTag = tfTag;
            this.dietTag = dietTag;
            this.dietItems = items;
        }

        private DietType(TagKey<TransfurVariant<?>> tfTag, TagKey<Item> dietTag) {
            this.tfTag = tfTag;
            this.dietTag = dietTag;
            this.dietItems = List.of();
        }

        public boolean hasDiet(ChangedEntity entity, TransfurVariant<?> tf) {
            if (this == AQUATIC && entity instanceof AquaticEntity && !SHARK.hasDiet(entity, tf)) {
                return true;
            }
            if (this == WOLF && entity instanceof AbstractLatexWolf) {
                return true;
            }
            return tf.is(this.tfTag);
        }

        public boolean isDietItem(ItemStack item) {
            return item.m_204117_(this.dietTag) || this.dietItems.contains(item.m_41720_());
        }

        public static DietType create(String name, TagKey<TransfurVariant<?>> tfTag, TagKey<Item> dietTag, List<Item> items) {
            throw new NotImplementedException("Not extended");
        }

        public static DietType create(String name, TagKey<TransfurVariant<?>> tfTag, TagKey<Item> dietTag) {
            throw new NotImplementedException("Not extended");
        }
    }
}

