/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import java.util.Objects;
import net.foxyas.changedaddon.configuration.ChangedAddonServerConfiguration;
import net.foxyas.changedaddon.init.ChangedAddonGameRules;
import net.foxyas.changedaddon.init.ChangedAddonMobEffects;
import net.foxyas.changedaddon.network.ChangedAddonModVariables;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedRegistry;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DoLatexInfectionTickHandle {
    private static final int HARD_TICK_DELAY = 40;
    private static final int NORMAL_TICK_DELAY = 60;
    private static final int EASY_TICK_DELAY = 100;
    private static final String NBT_INFECTED = "transfur_infected";
    private static final String NBT_LAST_VARIANT = "last_transfur_variant";

    private static float getValueToApply(Level world, Player player) {
        float maxTolerance = (float)Objects.requireNonNull(player.m_21051_((Attribute)ChangedAttributes.TRANSFUR_TOLERANCE.get())).m_22135_();
        return switch (world.m_46791_()) {
            case Difficulty.HARD -> maxTolerance * 0.125f;
            case Difficulty.NORMAL -> maxTolerance * 0.0625f;
            case Difficulty.EASY -> maxTolerance * 0.031f;
            default -> 0.0f;
        };
    }

    private static int getTickDelayForDifficulty(Level world) {
        return switch (world.m_46791_()) {
            case Difficulty.EASY -> 100;
            case Difficulty.NORMAL -> 60;
            case Difficulty.HARD -> 40;
            default -> -1;
        };
    }

    private static boolean isSurvivalOrAdventure(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GameType gameMode = serverPlayer.f_8941_.m_9290_();
            return gameMode == GameType.SURVIVAL || gameMode == GameType.ADVENTURE;
        }
        if (player.f_19853_.m_5776_() && player instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            PlayerInfo playerInfo = Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_104949_(clientPlayer.m_36316_().getId());
            return playerInfo != null && playerInfo.m_105325_() != GameType.SPECTATOR && playerInfo.m_105325_() != GameType.CREATIVE;
        }
        return false;
    }

    public static void setInfected(Player player, boolean value) {
        if (!player.f_19853_.f_46443_) {
            player.getPersistentData().m_128379_(NBT_INFECTED, value);
        }
    }

    public static boolean getInfected(Player player) {
        return player.getPersistentData().m_128441_(NBT_INFECTED) && player.getPersistentData().m_128471_(NBT_INFECTED);
    }

    private static void setLastVariant(Player player, TransfurVariant<?> variant) {
        if (variant != null && !player.f_19853_.f_46443_) {
            player.getPersistentData().m_128359_(NBT_LAST_VARIANT, variant.getFormId().toString());
        }
    }

    private static TransfurVariant<?> getLastVariant(Player player) {
        if (player.getPersistentData().m_128441_(NBT_LAST_VARIANT)) {
            String id = player.getPersistentData().m_128461_(NBT_LAST_VARIANT);
            return (TransfurVariant)ChangedRegistry.TRANSFUR_VARIANT.get().getValue(new ResourceLocation(id));
        }
        return null;
    }

    private static void clearTempData(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.getPersistentData().m_128473_(NBT_INFECTED);
            player.getPersistentData().m_128473_(NBT_LAST_VARIANT);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DoLatexInfectionTickHandle.run(event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerHit(ProcessTransfur.TransfurAttackEvent event) {
        LivingEntity entity = event.target;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_183503_().m_46469_().m_46207_(ChangedAddonGameRules.DO_LATEX_INFECTION)) {
            return;
        }
        if (DoLatexInfectionTickHandle.getInfected(player)) {
            DoLatexInfectionTickHandle.setLastVariant(player, event.variant);
        } else {
            DoLatexInfectionTickHandle.setInfected(player, true);
            DoLatexInfectionTickHandle.setLastVariant(player, event.variant);
        }
    }

    public static void run(Player player) {
        if (player == null) {
            return;
        }
        if (ProcessTransfur.isPlayerTransfurred((Player)player)) {
            return;
        }
        if (!player.m_183503_().m_46469_().m_46207_(ChangedAddonGameRules.DO_LATEX_INFECTION)) {
            DoLatexInfectionTickHandle.clearTempData(player);
            return;
        }
        ChangedAddonModVariables.PlayerVariables playerVariables = (ChangedAddonModVariables.PlayerVariables)player.getCapability(ChangedAddonModVariables.PLAYER_VARIABLES_CAPABILITY).orElse((Object)new ChangedAddonModVariables.PlayerVariables());
        int tickCounter = (int)playerVariables.LatexInfectionCooldown;
        float progress = ProcessTransfur.getPlayerTransfurProgress((Player)player);
        float maxTolerance = (float)ProcessTransfur.getEntityTransfurTolerance((LivingEntity)player);
        float mathNumber = DoLatexInfectionTickHandle.getValueToApply(player.m_183503_(), player);
        int tickDelay = DoLatexInfectionTickHandle.getTickDelayForDifficulty(player.m_183503_());
        if (((Boolean)ChangedAddonServerConfiguration.ALWAYS_INFECT.get()).booleanValue()) {
            if (progress > 0.0f && !DoLatexInfectionTickHandle.getInfected(player)) {
                DoLatexInfectionTickHandle.setInfected(player, true);
            }
            if (!DoLatexInfectionTickHandle.getInfected(player)) {
                return;
            }
            if (player.m_21023_((MobEffect)ChangedAddonMobEffects.LATEX_SOLVENT.get())) {
                DoLatexInfectionTickHandle.setInfected(player, false);
                DoLatexInfectionTickHandle.clearTempData(player);
                return;
            }
        } else {
            if (!(progress > 0.0f) && progress >= maxTolerance) {
                return;
            }
            if (player.m_21023_((MobEffect)ChangedAddonMobEffects.LATEX_SOLVENT.get())) {
                return;
            }
        }
        if (DoLatexInfectionTickHandle.isSurvivalOrAdventure(player) && player.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
            if (!DoLatexInfectionTickHandle.getInfected(player)) {
                return;
            }
            if (tickCounter >= tickDelay) {
                if (progress + mathNumber < maxTolerance * 0.998f) {
                    ProcessTransfur.setPlayerTransfurProgress((Player)player, (float)(progress + mathNumber));
                    playerVariables.LatexInfectionCooldown = 0.0;
                } else {
                    TransfurVariant<?> variant = DoLatexInfectionTickHandle.getLastVariant(player);
                    if (variant != null) {
                        ProcessTransfur.transfur((LivingEntity)player, (Level)player.m_183503_(), variant, (boolean)true, (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.GRAB_ABSORB));
                        DoLatexInfectionTickHandle.clearTempData(player);
                    }
                }
            } else {
                playerVariables.LatexInfectionCooldown += 1.0;
            }
        } else if (!DoLatexInfectionTickHandle.isSurvivalOrAdventure(player) && tickCounter != 0) {
            playerVariables.LatexInfectionCooldown = 0.0;
        }
    }
}

