/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.registries.ForgeRegistries;

public class SignalBlockFeatureProcedure {
    private static final int LARGE_SEARCH_RADIUS = 121;
    private static final int SMALL_SEARCH_RADIUS = 33;
    private static final int MAX_FOUND_BLOCKS = 10;

    public static void execute(LevelAccessor world, Entity entity, ItemStack itemstack) {
        Player player;
        if (SignalBlockFeatureProcedure.isSignalCatcherInHand(entity) && !(player = (Player)entity).m_36335_().m_41519_((Item)ChangedAddonItems.SIGNAL_CATCHER.get())) {
            int radius = player.m_6144_() ? 121 : 33;
            int cooldown = player.m_6144_() ? 225 : 75;
            SignalBlockFeatureProcedure.searchSignalBlockUsingChunks(world, player.m_20097_(), player, itemstack, radius, cooldown);
        }
    }

    private static boolean isSignalCatcherInHand(Entity entity) {
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity.m_21205_().m_41720_() == ChangedAddonItems.SIGNAL_CATCHER.get() || livingEntity.m_21206_().m_41720_() == ChangedAddonItems.SIGNAL_CATCHER.get();
    }

    private static void searchSignalBlockUsingChunks(LevelAccessor world, BlockPos pos, Player player, ItemStack itemstack, int radius, int cooldown) {
        ArrayList<BlockPos> foundPositions = new ArrayList<BlockPos>();
        int chunkRadius = (radius >> 4) + 1;
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        int chunkX = (int)x >> 4;
        int chunkZ = (int)z >> 4;
        for (int cx = chunkX - chunkRadius; cx <= chunkX + chunkRadius; ++cx) {
            for (int cz = chunkZ - chunkRadius; cz <= chunkZ + chunkRadius; ++cz) {
                if (!(world instanceof Level)) continue;
                Level level = (Level)world;
                LevelChunk chunk = level.m_6325_(cx, cz);
                chunk.m_62954_().forEach((BlockPos2, entity) -> {
                    if (entity.m_58900_().m_60734_() == ChangedAddonBlocks.SIGNAL_BLOCK.get()) {
                        Vec3i vec3i = new Vec3i(x, y, z);
                        if (BlockPos2.m_123331_(vec3i) <= (double)(radius * radius)) {
                            foundPositions.add((BlockPos)BlockPos2);
                            if (foundPositions.size() >= 10) {
                                // empty if block
                            }
                        }
                    }
                });
            }
        }
        if (!foundPositions.isEmpty()) {
            BlockPos firstFound = (BlockPos)foundPositions.get(0);
            SignalBlockFeatureProcedure.updatePlayerState(player, itemstack, firstFound.m_123341_(), firstFound.m_123342_(), firstFound.m_123343_(), cooldown);
            if (player.f_19853_.m_5776_()) {
                SignalBlockFeatureProcedure.displayFoundLocations(player, foundPositions);
            }
            SignalBlockFeatureProcedure.playSounds(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), firstFound);
        } else if (!player.f_19853_.m_5776_()) {
            player.m_5661_((Component)new TextComponent("No Signal Block Found"), false);
        }
    }

    private static void updatePlayerState(Player player, ItemStack itemstack, int x, int y, int z, int cooldown) {
        itemstack.m_41784_().m_128347_("x", (double)x);
        itemstack.m_41784_().m_128347_("y", (double)y);
        itemstack.m_41784_().m_128347_("z", (double)z);
        itemstack.m_41784_().m_128379_("set", true);
        player.m_36335_().m_41524_(itemstack.m_41720_(), cooldown);
    }

    private static void displayFoundLocations(Player player, List<BlockPos> positions) {
        boolean isCreative = player.m_7500_();
        player.m_5661_((Component)new TextComponent("Signal Blocks found at:"), false);
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos pos = positions.get(i);
            String positionText = String.format("Block %d: [%d, %d, %d]", i + 1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            TextComponent message = new TextComponent(positionText);
            if (isCreative) {
                Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/tp %d %d %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to copy the teleport command")));
                message.m_6270_(style);
            }
            player.m_5661_((Component)message, false);
        }
    }

    private static void playSounds(LevelAccessor world, double x, double y, double z, BlockPos foundPos) {
        SignalBlockFeatureProcedure.playSound(world, foundPos, "block.conduit.deactivate", SoundSource.BLOCKS, 1.5f);
        SignalBlockFeatureProcedure.playSound(world, new BlockPos(x, y, z), "block.conduit.activate", SoundSource.PLAYERS, 1.5f);
    }

    private static void playSound(LevelAccessor world, BlockPos pos, String soundEvent, SoundSource source, float volume) {
        if (world instanceof Level) {
            Level level = (Level)world;
            ResourceLocation soundLocation = new ResourceLocation(soundEvent);
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation)), source, volume, 0.0f);
            } else {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation)), source, volume, 0.0f, false);
            }
        }
    }
}

