/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.procedures.blocksHandle;

import com.ibm.icu.impl.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.ltxprogrammer.changed.block.AbstractLatexBlock;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class BoneMealExpansion {
    public static void spreadFromSource(ServerLevel level, BlockPos source, int maxDepth) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.of((Object)source, (Object)0));
        visited.add(source);
        while (!queue.isEmpty()) {
            BlockState state;
            Pair current = (Pair)queue.poll();
            BlockPos pos = (BlockPos)current.first;
            int depth = (Integer)current.second;
            if (depth > maxDepth || !AbstractLatexBlock.isLatexed((BlockState)(state = level.m_8055_(pos)))) continue;
            state.m_60735_(level, pos, level.m_5822_());
            level.m_46796_(1505, pos, 1);
            if (depth >= maxDepth) continue;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = pos.m_142300_(dir);
                if (visited.contains(neighbor)) continue;
                visited.add(neighbor);
                queue.add(Pair.of((Object)neighbor, (Object)(depth + 1)));
            }
        }
    }

    public static class GooApplyDispenserHandler {
        public static void registerDispenserBehavior() {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ChangedItems.DARK_LATEX_GOO.get()), (source, stack) -> {
                ServerLevel serverLevel = source.m_7727_();
                Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos targetPos = source.m_7961_().m_142300_(facing);
                BlockState targetState = serverLevel.m_8055_(targetPos);
                boolean success = false;
                if (!serverLevel.f_46443_ && !targetState.m_60795_()) {
                    if (targetState.m_61138_((Property)AbstractLatexBlock.COVERED)) {
                        BlockState newState = (BlockState)targetState.m_61124_((Property)AbstractLatexBlock.COVERED, (Comparable)LatexType.DARK_LATEX);
                        serverLevel.m_46597_(targetPos, newState);
                        serverLevel.m_46796_(1505, targetPos, 1);
                        newState.m_60735_(serverLevel, targetPos, serverLevel.m_5822_());
                        success = true;
                    }
                    if (success && !stack.m_41619_()) {
                        stack.m_41774_(1);
                    }
                }
                return stack;
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ChangedItems.WHITE_LATEX_GOO.get()), (source, stack) -> {
                ServerLevel serverLevel = source.m_7727_();
                Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos targetPos = source.m_7961_().m_142300_(facing);
                BlockState targetState = serverLevel.m_8055_(targetPos);
                boolean success = false;
                if (!serverLevel.f_46443_ && !targetState.m_60795_()) {
                    if (targetState.m_61138_((Property)AbstractLatexBlock.COVERED)) {
                        BlockState newState = (BlockState)targetState.m_61124_((Property)AbstractLatexBlock.COVERED, (Comparable)LatexType.WHITE_LATEX);
                        serverLevel.m_46597_(targetPos, newState);
                        serverLevel.m_46796_(1505, targetPos, 1);
                        newState.m_60735_(serverLevel, targetPos, serverLevel.m_5822_());
                        success = true;
                    }
                    if (success && !stack.m_41619_()) {
                        stack.m_41774_(1);
                    }
                }
                return stack;
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ChangedAddonItems.ANTI_LATEX_BASE.get()), (source, stack) -> {
                ServerLevel serverLevel = source.m_7727_();
                Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos targetPos = source.m_7961_().m_142300_(facing);
                BlockState targetState = serverLevel.m_8055_(targetPos);
                boolean success = false;
                if (!serverLevel.f_46443_ && !targetState.m_60795_()) {
                    if (AbstractLatexBlock.isLatexed((BlockState)targetState) && targetState.m_61138_((Property)AbstractLatexBlock.COVERED)) {
                        BlockState newState = (BlockState)targetState.m_61124_((Property)AbstractLatexBlock.COVERED, (Comparable)LatexType.NEUTRAL);
                        serverLevel.m_46597_(targetPos, newState);
                        serverLevel.m_46796_(1505, targetPos, 1);
                        success = true;
                    }
                    if (success && !stack.m_41619_()) {
                        stack.m_41774_(1);
                    }
                }
                return stack;
            });
        }
    }

    public static class BoneMealDispenserHandler {
        public static void registerDispenserBehavior() {
            DispenserBlock.m_52672_((ItemLike)Items.f_42499_, (source, stack) -> {
                ServerLevel serverLevel = source.m_7727_();
                Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos targetPos = source.m_7961_().m_142300_(facing);
                BlockState targetState = serverLevel.m_8055_(targetPos);
                boolean success = false;
                if (!serverLevel.f_46443_ && !targetState.m_60795_()) {
                    if (AbstractLatexBlock.isLatexed((BlockState)targetState)) {
                        BoneMealExpansion.spreadFromSource(serverLevel, targetPos, serverLevel.m_5822_().nextInt(16) + 1);
                        success = true;
                    }
                    if (!success && (success = BoneMealItem.applyBonemeal((ItemStack)stack, (Level)serverLevel, (BlockPos)targetPos, (Player)FakePlayerFactory.getMinecraft((ServerLevel)serverLevel)))) {
                        serverLevel.m_46796_(1505, targetPos, 0);
                    }
                    if (success && !stack.m_41619_()) {
                        stack.m_41774_(1);
                    }
                }
                return stack;
            });
        }
    }

    @Mod.EventBusSubscriber
    public static class AttemptToApply {
        @SubscribeEvent
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            Player player = event.getPlayer();
            Level level = event.getWorld();
            BlockPos pos = event.getPos();
            ItemStack stack = event.getItemStack();
            BlockState state = level.m_8055_(pos);
            if (!level.f_46443_ && stack.m_150930_(Items.f_42499_) && AbstractLatexBlock.isLatexed((BlockState)state)) {
                if (!player.m_6144_()) {
                    return;
                }
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.DENY);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BoneMealExpansion.spreadFromSource(serverLevel, pos, serverLevel.m_5822_().nextInt(16) + 1);
                }
                level.m_46796_(1505, pos, 1);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

