/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.process.features;

import java.util.Objects;
import net.foxyas.changedaddon.abilities.DodgeAbilityInstance;
import net.foxyas.changedaddon.init.ChangedAddonAbilities;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DodgeAbilityHandle {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile self = event.getProjectile();
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHitResult = (EntityHitResult)hitResult;
        Entity pTarget = entityHitResult.m_82443_();
        if (!pTarget.m_183503_().m_5776_()) {
            Player player;
            TransfurVariantInstance instance;
            Entity owner = self.m_37282_();
            Entity attacker = (Entity)Objects.requireNonNullElse(owner, self);
            if (pTarget instanceof ChangedEntity) {
                ChangedEntity changedEntity = (ChangedEntity)pTarget;
                DodgeAbilityInstance dodgeAbilityInstance = (DodgeAbilityInstance)changedEntity.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.DODGE.get());
                DodgeAbilityInstance teleportDodgeAbilityInstance = (DodgeAbilityInstance)changedEntity.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.TELEPORT_DODGE.get());
                if (dodgeAbilityInstance != null && dodgeAbilityInstance.canUse() && dodgeAbilityInstance.canKeepUsing() && dodgeAbilityInstance.isDodgeActive()) {
                    event.setCanceled(false);
                    dodgeAbilityInstance.executeDodgeEffects((LivingEntity)changedEntity, attacker);
                    dodgeAbilityInstance.executeDodgeHandle((LivingEntity)changedEntity, attacker);
                } else if (teleportDodgeAbilityInstance != null && teleportDodgeAbilityInstance.canUse() && teleportDodgeAbilityInstance.canKeepUsing() && teleportDodgeAbilityInstance.isDodgeActive()) {
                    event.setCanceled(false);
                    teleportDodgeAbilityInstance.executeDodgeEffects((LivingEntity)changedEntity, attacker);
                    teleportDodgeAbilityInstance.executeDodgeHandle((LivingEntity)changedEntity, attacker);
                }
            }
            if (pTarget instanceof Player && (instance = ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)pTarget))) != null) {
                DodgeAbilityInstance dodgeAbilityInstance = (DodgeAbilityInstance)instance.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.DODGE.get());
                DodgeAbilityInstance teleportDodgeAbilityInstance = (DodgeAbilityInstance)instance.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.TELEPORT_DODGE.get());
                if (dodgeAbilityInstance != null && dodgeAbilityInstance.canUse() && dodgeAbilityInstance.canKeepUsing() && dodgeAbilityInstance.isDodgeActive()) {
                    if (dodgeAbilityInstance.getDodgeType() == DodgeAbilityInstance.DodgeType.WEAVE) {
                        event.setCanceled(false);
                        dodgeAbilityInstance.executeDodgeEffects((LivingEntity)player, attacker);
                        dodgeAbilityInstance.executeDodgeHandle((LivingEntity)player, attacker);
                    }
                } else if (teleportDodgeAbilityInstance != null && teleportDodgeAbilityInstance.canUse() && teleportDodgeAbilityInstance.canKeepUsing() && teleportDodgeAbilityInstance.isDodgeActive() && teleportDodgeAbilityInstance.getDodgeType() == DodgeAbilityInstance.DodgeType.TELEPORT) {
                    event.setCanceled(false);
                    teleportDodgeAbilityInstance.executeDodgeEffects((LivingEntity)player, attacker);
                    teleportDodgeAbilityInstance.executeDodgeHandle((LivingEntity)player, attacker);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        Player player;
        Entity attacker;
        LivingEntity target;
        block12: {
            block11: {
                target = event.getEntityLiving();
                attacker = event.getSource().m_7639_();
                if (!(target instanceof Player)) break block11;
                player = (Player)target;
                if (attacker != null) break block12;
            }
            return;
        }
        Level world = target.f_19853_;
        TransfurVariantInstance variant = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (variant == null) {
            return;
        }
        DodgeAbilityInstance dodge = (DodgeAbilityInstance)variant.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.DODGE.get());
        if (dodge == null) {
            if (variant.abilityInstances.get(ChangedAddonAbilities.TELEPORT_DODGE.get()) == null) {
                return;
            }
            dodge = (DodgeAbilityInstance)variant.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.TELEPORT_DODGE.get());
        }
        if (!dodge.isDodgeActive()) {
            return;
        }
        if (dodge.getDodgeAmount() <= 0) {
            dodge.getController().deactivateAbility();
            return;
        }
        if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            return;
        }
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            return;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            DodgeAbilityHandle.applyDodgeEffects(player, livingAttacker, dodge, (LevelAccessor)world, event);
            DodgeAbilityHandle.applyDodgeHandle(player, livingAttacker, dodge, (LevelAccessor)world, event);
        }
    }

    private static void applyDodgeEffects(Player player, LivingEntity attacker, DodgeAbilityInstance dodge, LevelAccessor levelAccessor, LivingAttackEvent event) {
        dodge.executeDodgeEffects(levelAccessor, (Entity)attacker, (LivingEntity)player, event);
    }

    private static void applyDodgeHandle(Player player, LivingEntity attacker, DodgeAbilityInstance dodge, LevelAccessor levelAccessor, LivingAttackEvent event) {
        dodge.executeDodgeHandle(levelAccessor, (Entity)attacker, (LivingEntity)player, event, true);
    }

    public static void dashBackwards(Player target, boolean includeY) {
        Vec3 look = target.m_20154_().m_82541_();
        Vec3 motion = look.m_82490_(1.25);
        Vec3 finalMotion = includeY ? new Vec3(-motion.f_82479_, target.m_20184_().f_82480_, -motion.f_82481_) : target.m_20184_().m_82520_(-motion.f_82479_, 0.0, -motion.f_82481_);
        target.m_20256_(finalMotion);
    }

    public static void dashInFacingDirection(LivingEntity target) {
        double yaw = Math.toRadians(target.m_146908_());
        double pitch = Math.toRadians(target.m_146909_());
        double x = -Math.sin(yaw);
        double y = -Math.sin(pitch);
        double z = Math.cos(yaw);
        double speed = 1.05;
        Vec3 motion = new Vec3(x * speed, y * speed, z * speed);
        target.m_20256_(target.m_20184_().m_82549_(motion));
    }

    private static void dodgeAwayFromAttacker(Entity dodger, Entity attacker) {
        Vec3 motion = attacker.m_20182_().m_82546_(dodger.m_20182_()).m_82490_(-0.25);
        dodger.m_20334_(motion.f_82479_, dodger.m_20184_().f_82480_, motion.f_82481_);
    }
}

