/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.process.features;

import java.util.Objects;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.entity.interfaces.CustomPatReaction;
import net.foxyas.changedaddon.entity.interfaces.SpecialPatLatex;
import net.foxyas.changedaddon.init.ChangedAddonCriteriaTriggers;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.process.features.ProcessPatFeature;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.GrabEntityAbility;
import net.ltxprogrammer.changed.ability.GrabEntityAbilityInstance;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.beast.AbstractDarkLatexWolf;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAbilities;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;

public class PatFeatureHandle {
    public static boolean canPlayerPat(Player player) {
        TransfurVariantInstance variant = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (variant == null) {
            return GrabEntityAbility.getGrabber((LivingEntity)player) == null;
        }
        GrabEntityAbilityInstance ability = (GrabEntityAbilityInstance)variant.getAbilityInstance((AbstractAbility)ChangedAbilities.GRAB_ENTITY_ABILITY.get());
        if (ability != null && ability.suited && ability.grabbedHasControl) {
            return false;
        }
        return GrabEntityAbility.getGrabber((LivingEntity)player) == null;
    }

    public static void run(Level level, Player player) {
        if (player == null || player.m_5833_() || !PatFeatureHandle.canPlayerPat(player)) {
            return;
        }
        InteractionHand emptyHand = PatFeatureHandle.getEmptyHand(player);
        if (emptyHand == null) {
            return;
        }
        EntityHitResult targetEntityResult = PlayerUtil.getEntityHitLookingAt((Entity)player, (float)player.getReachDistance(), true, e -> {
            if (e.m_5833_()) {
                return false;
            }
            if (!(e instanceof LivingEntity)) {
                return false;
            }
            LivingEntity le = (LivingEntity)e;
            if (GrabEntityAbility.getGrabber((LivingEntity)le) == null) {
                return true;
            }
            LivingEntity livingEntity = Objects.requireNonNull(GrabEntityAbility.getGrabber((LivingEntity)le)).getEntity();
            return livingEntity != player;
        });
        if (targetEntityResult == null) {
            return;
        }
        Entity targetEntity = targetEntityResult.m_82443_();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)targetEntity;
        if (targetEntity instanceof SpecialPatLatex) {
            PatFeatureHandle.handleSpecialEntities(player, emptyHand, living, targetEntityResult);
            return;
        }
        if (targetEntity instanceof ChangedEntity) {
            ChangedEntity changed = (ChangedEntity)targetEntity;
            PatFeatureHandle.handleLatexEntity(player, emptyHand, changed, targetEntityResult, level);
            return;
        }
        if (targetEntity instanceof Player) {
            Player target = (Player)targetEntity;
            PatFeatureHandle.handlePlayerEntity(player, emptyHand, target, targetEntityResult, level);
            return;
        }
        if (targetEntity.m_6095_().m_204039_(ChangedAddonTags.EntityTypes.PATABLE)) {
            PatFeatureHandle.handlePatableEntity(player, emptyHand, targetEntityResult, level);
        }
    }

    private static void handleSpecialEntities(Player player, InteractionHand emptyHand, LivingEntity target, EntityHitResult entityHitResult) {
        player.m_6674_(emptyHand);
        if (!(target instanceof CustomPatReaction)) {
            return;
        }
        CustomPatReaction pat = (CustomPatReaction)target;
        pat.WhenPattedReactionSpecific(player, emptyHand, entityHitResult.m_82450_());
        pat.WhenPattedReaction(player, emptyHand);
        pat.WhenPattedReactionSimple();
    }

    private static void handleLatexEntity(Player player, InteractionHand emptyHand, ChangedEntity target, EntityHitResult entityHitResult, Level level) {
        ChangedEntity changedEntity;
        player.m_6674_(emptyHand);
        ProcessPatFeature.GlobalPatReactionEvent globalPatReactionEvent = new ProcessPatFeature.GlobalPatReactionEvent((LevelAccessor)level, player, emptyHand, (LivingEntity)target, entityHitResult.m_82450_());
        if (ChangedAddonMod.postEvent(globalPatReactionEvent)) {
            return;
        }
        TransfurVariantInstance selfTF = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (selfTF != null && (changedEntity = selfTF.getChangedEntity()) instanceof CustomPatReaction) {
            CustomPatReaction playerPat = (CustomPatReaction)changedEntity;
            playerPat.WhenPatEvent((LivingEntity)player, emptyHand, (LivingEntity)target);
            playerPat.WhenPatEventSpecific((LivingEntity)player, emptyHand, (LivingEntity)target, entityHitResult);
        }
        if (target instanceof CustomPatReaction) {
            CustomPatReaction e = (CustomPatReaction)target;
            e.WhenPattedReactionSpecific(player, emptyHand, entityHitResult.m_82450_());
            e.WhenPattedReaction(player, emptyHand);
            e.WhenPattedReactionSimple();
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PatFeatureHandle.GiveStealthPatAdvancement(sp, (Entity)target);
        }
    }

    private static void handlePlayerEntity(Player player, InteractionHand emptyHand, Player target, EntityHitResult entityHitResult, Level level) {
        ProcessPatFeature.GlobalPatReactionEvent globalPatReactionEvent;
        ChangedEntity changedEntity;
        TransfurVariantInstance selfTF = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        TransfurVariantInstance targetTF = ProcessTransfur.getPlayerTransfurVariant((Player)target);
        if (selfTF == null && targetTF == null) {
            return;
        }
        player.m_6674_(emptyHand);
        if (selfTF != null && (changedEntity = selfTF.getChangedEntity()) instanceof CustomPatReaction) {
            CustomPatReaction playerPat = (CustomPatReaction)changedEntity;
            playerPat.WhenPatEvent((LivingEntity)player, emptyHand, (LivingEntity)target);
        }
        if (targetTF != null && (changedEntity = targetTF.getChangedEntity()) instanceof CustomPatReaction) {
            CustomPatReaction TargetPat = (CustomPatReaction)changedEntity;
            TargetPat.WhenPattedReactionSpecific(player, emptyHand, entityHitResult.m_82450_());
            TargetPat.WhenPattedReaction(player, emptyHand);
            TargetPat.WhenPattedReactionSimple();
        }
        if (ChangedAddonMod.postEvent(globalPatReactionEvent = new ProcessPatFeature.GlobalPatReactionEvent((LevelAccessor)level, player, emptyHand, (LivingEntity)target, entityHitResult.m_82450_()))) {
            return;
        }
        if (targetTF == null || !(level instanceof ServerLevel)) {
            return;
        }
        if (player.m_21187_().nextFloat() > 0.025f + player.m_36336_() * 0.01f) {
            return;
        }
        target.m_5634_(6.0f);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            PatFeatureHandle.GivePatAdvancement(sPlayer, (Entity)target);
        }
    }

    private static void handlePatableEntity(Player player, InteractionHand emptyHand, EntityHitResult entityHitResult, Level level) {
        Entity target = entityHitResult.m_82443_();
        player.m_6674_(emptyHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.m_5661_((Component)new TranslatableComponent("key.changed_addon.pat_message", new Object[]{target.m_5446_().getString()}), true);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 7, 0.3, 0.3, 0.3, 1.0);
        }
    }

    private static InteractionHand getEmptyHand(Player player) {
        if (player.m_21205_().m_41619_()) {
            return InteractionHand.MAIN_HAND;
        }
        return player.m_21206_().m_41619_() ? InteractionHand.OFF_HAND : null;
    }

    public static boolean shouldBeConfused(Player player, ChangedEntity entity) {
        if (entity instanceof AbstractDarkLatexWolf) {
            return player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ChangedAddonItems.DARK_LATEX_HEAD_CAP.get()) && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ChangedAddonItems.DARK_LATEX_COAT.get());
        }
        return false;
    }

    public static void GivePatAdvancement(ServerPlayer player, Entity target) {
        ChangedAddonCriteriaTriggers.PAT_ENTITY_TRIGGER.Trigger(player, target, "chance");
    }

    public static void GiveStealthPatAdvancement(ServerPlayer player, Entity target) {
        ChangedAddonCriteriaTriggers.PAT_ENTITY_TRIGGER.Trigger(player, target, "stealth");
    }
}

