/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.process.sounds;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.foxyas.changedaddon.entity.interfaces.IHasBossMusic;
import net.foxyas.changedaddon.process.sounds.FadingBossMusicSound;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class BossMusicHandler {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Map<IHasBossMusic, FadingBossMusicSound> activeBosses = new HashMap<IHasBossMusic, FadingBossMusicSound>();

    public static void tick(ClientLevel level) {
        IHasBossMusic boss;
        if (BossMusicHandler.mc.f_91074_ == null || level == null) {
            return;
        }
        HashSet<IHasBossMusic> nearbyBosses = new HashSet<IHasBossMusic>();
        for (Entity entity : level.m_104735_()) {
            double distSq;
            ChangedEntity changedEntity;
            if (!(entity instanceof IHasBossMusic)) continue;
            boss = (IHasBossMusic)entity;
            if (entity instanceof ChangedEntity && (changedEntity = (ChangedEntity)entity).getUnderlyingPlayer() != null || !entity.m_6084_() || !((distSq = entity.m_20280_((Entity)BossMusicHandler.mc.f_91074_)) <= (double)(boss.getMusicRange() * boss.getMusicRange()))) continue;
            nearbyBosses.add(boss);
            if (!activeBosses.containsKey(boss)) {
                BossMusicHandler.playMusic(boss);
                continue;
            }
            FadingBossMusicSound sound = activeBosses.get(boss);
            if (!mc.m_91106_().m_120403_((SoundInstance)sound) || sound.m_7801_()) {
                BossMusicHandler.playMusic(boss);
                continue;
            }
            if (sound.m_7904_() == boss.getBossMusic()) continue;
            BossMusicHandler.stopMusic(boss);
            BossMusicHandler.playMusic(boss);
        }
        Iterator<Map.Entry<IHasBossMusic, FadingBossMusicSound>> it = activeBosses.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IHasBossMusic, FadingBossMusicSound> entry = it.next();
            boss = entry.getKey();
            FadingBossMusicSound sound = entry.getValue();
            if (nearbyBosses.contains(boss) && !boss.getSelf().m_21224_()) continue;
            BossMusicHandler.stopMusic(boss);
            it.remove();
        }
    }

    private static void playMusic(IHasBossMusic boss) {
        if (boss == null) {
            return;
        }
        ResourceLocation music = boss.getBossMusic();
        SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(music);
        if (event == null) {
            return;
        }
        FadingBossMusicSound sound = new FadingBossMusicSound(event, boss.getSelf());
        mc.m_91106_().m_120367_((SoundInstance)sound);
        activeBosses.put(boss, sound);
    }

    private static void stopMusic(IHasBossMusic boss) {
        FadingBossMusicSound sound = activeBosses.get(boss);
        if (sound != null) {
            sound.startFadeOut();
        }
    }
}

