/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.process.variantsExtraStats.visions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.process.variantsExtraStats.visions.TransfurVariantVision;
import net.foxyas.changedaddon.process.variantsExtraStats.visions.TransfurVisionRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class TransfurVisionReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().create();

    public TransfurVisionReloadListener() {
        super(GSON, "transfur_visions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> entries, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        TransfurVisionRegistry.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entries.entrySet()) {
            try {
                ResourceLocation id = entry.getKey();
                JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"Vision");
                TransfurVariantVision vision = TransfurVariantVision.fromJson(id, json);
                TransfurVisionRegistry.register(vision);
            }
            catch (Exception e) {
                ChangedAddonMod.LOGGER.error("Failed to parse vision {}: {}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
        ChangedAddonMod.LOGGER.info("Loaded {} transfur visions", (Object)entries.size());
    }
}

