/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class CatalyzerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final float ProgressSpeed;
    private final float NitrogenUsage;

    public CatalyzerRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, float ProgressSpeed, float NitrogenUsage) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.ProgressSpeed = ProgressSpeed;
        this.NitrogenUsage = NitrogenUsage;
    }

    public boolean matches(@NotNull SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        if (!this.recipeItems.isEmpty()) {
            for (Ingredient ingredient : this.recipeItems) {
                if (!ingredient.test(pContainer.m_8020_(2))) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public float getProgressSpeed() {
        return this.ProgressSpeed;
    }

    public float getNitrogenUsage() {
        return this.NitrogenUsage;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Type
    implements RecipeType<CatalyzerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "catalyzer";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<CatalyzerRecipe>,
    IForgeRegistryEntry<RecipeSerializer<?>> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("changed_addon", "catalyzer");

        @NotNull
        public CatalyzerRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(0)));
            float ProgressSpeed = GsonHelper.m_13820_((JsonObject)pSerializedRecipe, (String)"ProgressSpeed", (float)1.0f);
            float NitrogenUsage = GsonHelper.m_13820_((JsonObject)pSerializedRecipe, (String)"NitrogenUsage", (float)0.0f);
            return new CatalyzerRecipe(pRecipeId, output, (NonNullList<Ingredient>)inputs, ProgressSpeed, NitrogenUsage);
        }

        @Nullable
        public CatalyzerRecipe fromNetwork(@NotNull ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            float ProgressSpeed = buf.readFloat();
            float NitrogenUsage = buf.readFloat();
            return new CatalyzerRecipe(id, output, (NonNullList<Ingredient>)inputs, ProgressSpeed, NitrogenUsage);
        }

        public void toNetwork(FriendlyByteBuf buf, CatalyzerRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(recipe.m_8043_(), false);
            buf.writeFloat(recipe.getProgressSpeed());
            buf.writeFloat(recipe.getNitrogenUsage());
        }

        public ResourceLocation getRegistryName() {
            return ID;
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return this;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return RecipeSerializer.class;
        }
    }
}

