/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.recipes.special;

import com.google.gson.JsonObject;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.item.LaserPointer;
import net.foxyas.changedaddon.recipes.ChangedAddonModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LaserPointerColoringRecipe
extends CustomRecipe {
    public LaserPointerColoringRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, @NotNull Level level) {
        boolean hasPointer = false;
        boolean hasDye = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ChangedAddonItems.LASER_POINTER.get()) {
                if (hasPointer) {
                    return false;
                }
                hasPointer = true;
                continue;
            }
            if (item instanceof DyeItem) {
                hasDye = true;
                continue;
            }
            return false;
        }
        return hasPointer && hasDye;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container) {
        ItemStack pointer = ItemStack.f_41583_;
        int totalR = 0;
        int totalG = 0;
        int totalB = 0;
        int colorCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ChangedAddonItems.LASER_POINTER.get()) {
                pointer = stack;
                continue;
            }
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            int color = dyeItem.m_41089_().m_41071_();
            totalR += color >> 16 & 0xFF;
            totalG += color >> 8 & 0xFF;
            totalB += color & 0xFF;
            ++colorCount;
        }
        if (!pointer.m_41619_() && colorCount > 0) {
            ItemStack result = pointer.m_41777_();
            result.m_41764_(1);
            int existingColor = LaserPointer.getColor(result);
            if (existingColor != -1) {
                totalR += existingColor >> 16 & 0xFF;
                totalG += existingColor >> 8 & 0xFF;
                totalB += existingColor & 0xFF;
                ++colorCount;
            }
            int r = totalR / colorCount;
            int g = totalG / colorCount;
            int b = totalB / colorCount;
            int finalColor = r << 16 | g << 8 | b;
            LaserPointer.setLaserColor(result, finalColor);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ChangedAddonModRecipeTypes.LAZER_POINTER_COLORING.get();
    }

    public static class Serializer
    implements RecipeSerializer<LaserPointerColoringRecipe> {
        public static final ResourceLocation ID = new ResourceLocation("changed_addon", "laser_pointer_coloring");

        @NotNull
        public LaserPointerColoringRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            return new LaserPointerColoringRecipe(id);
        }

        public LaserPointerColoringRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
            return new LaserPointerColoringRecipe(id);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull LaserPointerColoringRecipe recipe) {
        }

        public ResourceLocation getRegistryName() {
            return ID;
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return this;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return RecipeSerializer.class;
        }
    }
}

