/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GeometryUtil {
    public static boolean isInsideEllipsoid(double dx, double dy, double dz, double radiusX, double radiusY, double radiusZ) {
        double nx = dx * dx / (radiusX * radiusX);
        double ny = dy * dy / (radiusY * radiusY);
        double nz = dz * dz / (radiusZ * radiusZ);
        return nx + ny + nz <= 1.0;
    }

    public static double getEllipsoidValue(double dx, double dy, double dz, double radiusX, double radiusY, double radiusZ) {
        double nx = dx * dx / (radiusX * radiusX);
        double ny = dy * dy / (radiusY * radiusY);
        double nz = dz * dz / (radiusZ * radiusZ);
        return nx + ny + nz;
    }

    public static boolean isInsideSphere(double dx, double dy, double dz, double radius) {
        return GeometryUtil.isInsideEllipsoid(dx, dy, dz, radius, radius, radius);
    }

    public static boolean isInsideCircle(Vec2 point, Vec2 center, float radius) {
        float dx = point.f_82470_ - center.f_82470_;
        float dy = point.f_82471_ - center.f_82471_;
        return dx * dx + dy * dy <= radius * radius;
    }

    public static boolean isInsideCircleXZ(Vec3 point, Vec3 center, float radius) {
        double dx = point.f_82479_ - center.f_82479_;
        double dz = point.f_82481_ - center.f_82481_;
        return dx * dx + dz * dz <= (double)(radius * radius);
    }

    public static boolean isInsideSphere(Vec3 point, Vec3 center, float radius) {
        double dx = point.f_82479_ - center.f_82479_;
        double dy = point.f_82480_ - center.f_82480_;
        double dz = point.f_82481_ - center.f_82481_;
        return dx * dx + dy * dy + dz * dz <= (double)(radius * radius);
    }

    public static double distanceSquared(Vec3 a, Vec3 b) {
        double dx = a.f_82479_ - b.f_82479_;
        double dy = a.f_82480_ - b.f_82480_;
        double dz = a.f_82481_ - b.f_82481_;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distanceSquaredXZ(Vec3 a, Vec3 b) {
        double dx = a.f_82479_ - b.f_82479_;
        double dz = a.f_82481_ - b.f_82481_;
        return dx * dx + dz * dz;
    }

    public static boolean isInsideRectangle(Vec2 point, Vec2 min, Vec2 max) {
        return point.f_82470_ >= min.f_82470_ && point.f_82470_ <= max.f_82470_ && point.f_82471_ >= min.f_82471_ && point.f_82471_ <= max.f_82471_;
    }

    public static boolean isInsideCube(Vec3 point, Vec3 min, Vec3 max) {
        return point.f_82479_ >= min.f_82479_ && point.f_82479_ <= max.f_82479_ && point.f_82480_ >= min.f_82480_ && point.f_82480_ <= max.f_82480_ && point.f_82481_ >= min.f_82481_ && point.f_82481_ <= max.f_82481_;
    }
}

