/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RenderUtil {
    private static final int FULL_LIGHT = 0xF000F0;

    public static void drawCentered(Font font, PoseStack stack, Component comp, float x, float y, int color) {
        int width = font.m_92852_((FormattedText)comp);
        font.m_92889_(stack, comp, x - (float)width / 2.0f, y - 4.0f, color);
    }

    public static void drawCentered(Font font, PoseStack stack, String str, float x, float y, int color) {
        int width = font.m_92895_(str);
        font.m_92883_(stack, str, x - (float)width / 2.0f, y - 4.0f, color);
    }

    public static void fill(PoseStack stack, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtil.fill(stack.m_85850_().m_85861_(), minX, minY, maxX, maxY, color);
    }

    public static void fill(Matrix4f pMatrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(pMatrix, minX, maxY, 0.0f).m_193479_(color).m_5752_();
        bufferbuilder.m_85982_(pMatrix, maxX, maxY, 0.0f).m_193479_(color).m_5752_();
        bufferbuilder.m_85982_(pMatrix, maxX, minY, 0.0f).m_193479_(color).m_5752_();
        bufferbuilder.m_85982_(pMatrix, minX, minY, 0.0f).m_193479_(color).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void vertex(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, float x, float y, float z, int r, int g, int b, float u, float v) {
        builder.m_85982_(poseMatrix, x, y, z).m_6122_(r, g, b, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void vertex(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, float x, float y, float z, int r, int g, int b, int a, float u, float v) {
        builder.m_85982_(poseMatrix, x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void vertex(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, float x, float y, float z, int r, int g, int b, int a, float u, float v, int overlay, int light) {
        builder.m_85982_(poseMatrix, x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(overlay).m_85969_(light).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void drawQuadXZ(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, Vec3 origin, float width, float depth, int r, int g, int b) {
        float x = (float)origin.f_82479_;
        float y = (float)origin.f_82480_;
        float z = (float)origin.f_82481_;
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z, r, g, b, 0.0f, 1.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y, z, r, g, b, 1.0f, 1.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y, z + depth, r, g, b, 1.0f, 0.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z + depth, r, g, b, 0.0f, 0.0f);
    }

    public static void drawQuadXY(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, Vec3 origin, float width, float height, int r, int g, int b) {
        float x = (float)origin.f_82479_;
        float y = (float)origin.f_82480_;
        float z = (float)origin.f_82481_;
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z, r, g, b, 0.0f, 1.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y, z, r, g, b, 1.0f, 1.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y + height, z, r, g, b, 1.0f, 0.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y + height, z, r, g, b, 0.0f, 0.0f);
    }

    public static void drawQuadYZ(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, Vec3 origin, float height, float depth, int r, int g, int b) {
        float x = (float)origin.f_82479_;
        float y = (float)origin.f_82480_;
        float z = (float)origin.f_82481_;
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z, r, g, b, 0.0f, 1.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z + depth, r, g, b, 1.0f, 1.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y + height, z + depth, r, g, b, 1.0f, 0.0f);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y + height, z, r, g, b, 0.0f, 0.0f);
    }

    public static void vertex(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, float x, float y, float z, Color color, float u, float v) {
        builder.m_85982_(poseMatrix, x, y, z).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void drawQuadXZ(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, Vec3 origin, float width, float depth, List<Vec2> uvs, Color fromColor, Color toColor) {
        float x = (float)origin.f_82479_;
        float y = (float)origin.f_82480_;
        float z = (float)origin.f_82481_;
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z, fromColor, uvs.get((int)0).f_82470_, uvs.get((int)0).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y, z, fromColor, uvs.get((int)1).f_82470_, uvs.get((int)1).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y, z + depth, toColor, uvs.get((int)2).f_82470_, uvs.get((int)2).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z + depth, toColor, uvs.get((int)3).f_82470_, uvs.get((int)3).f_82471_);
    }

    public static void drawQuadXY(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, Vec3 origin, float width, float height, List<Vec2> uvs, Color fromColor, Color toColor) {
        float x = (float)origin.f_82479_;
        float y = (float)origin.f_82480_;
        float z = (float)origin.f_82481_;
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z, fromColor, uvs.get((int)0).f_82470_, uvs.get((int)0).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y, z, fromColor, uvs.get((int)1).f_82470_, uvs.get((int)1).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x + width, y + height, z, toColor, uvs.get((int)2).f_82470_, uvs.get((int)2).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y + height, z, toColor, uvs.get((int)3).f_82470_, uvs.get((int)3).f_82471_);
    }

    public static void drawQuadYZ(VertexConsumer builder, Matrix4f poseMatrix, Matrix3f normalMatrix, Vec3 origin, float height, float depth, List<Vec2> uvs, Color fromColor, Color toColor) {
        float x = (float)origin.f_82479_;
        float y = (float)origin.f_82480_;
        float z = (float)origin.f_82481_;
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z, fromColor, uvs.get((int)0).f_82470_, uvs.get((int)0).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y, z + depth, fromColor, uvs.get((int)1).f_82470_, uvs.get((int)1).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y + height, z + depth, toColor, uvs.get((int)2).f_82470_, uvs.get((int)2).f_82471_);
        RenderUtil.vertex(builder, poseMatrix, normalMatrix, x, y + height, z, toColor, uvs.get((int)3).f_82470_, uvs.get((int)3).f_82471_);
    }
}

