/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.util.Cacheable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class TransfurVariantUtils {
    private static final Cacheable<AttributeMap> BASE_ATTRIBUTES = Cacheable.of(() -> new AttributeMap(Player.m_36340_().m_22265_()));

    private static ChangedEntity entity(TransfurVariant<?> variant, Level level) {
        return variant == null ? null : (ChangedEntity)variant.getEntityType().m_20615_(level);
    }

    public static float GetLandSpeed(TransfurVariant<?> variant, Player player) {
        ChangedEntity entity = TransfurVariantUtils.entity(variant, player.f_19853_);
        if (entity == null) {
            return 0.0f;
        }
        entity.setUnderlyingPlayer(player);
        return (float)(entity.m_21172_(Attributes.f_22279_) * (double)0.1f / ((AttributeMap)BASE_ATTRIBUTES.get()).m_22185_(Attributes.f_22279_));
    }

    public static float GetSwimSpeed(TransfurVariant<?> variant, Player player) {
        ChangedEntity entity = TransfurVariantUtils.entity(variant, player.f_19853_);
        if (entity == null) {
            return 0.0f;
        }
        entity.setUnderlyingPlayer(player);
        return (float)(entity.m_21172_((Attribute)ForgeMod.SWIM_SPEED.get()) / ((AttributeMap)BASE_ATTRIBUTES.get()).m_22185_((Attribute)ForgeMod.SWIM_SPEED.get()));
    }

    public static float GetExtraHp(TransfurVariant<?> variant, Player player) {
        ChangedEntity entity = TransfurVariantUtils.entity(variant, player.f_19853_);
        if (entity == null) {
            return 0.0f;
        }
        entity.setUnderlyingPlayer(player);
        return entity.m_21233_() - 20.0f;
    }

    public static String getMiningStrength(TransfurVariant<?> variant) {
        return variant == null ? "unknown" : variant.miningStrength.name().toLowerCase();
    }

    public static boolean CanGlideAndFly(TransfurVariant<?> variant) {
        return variant != null && variant.canGlide;
    }

    public static boolean CanClimb(TransfurVariant<?> variant) {
        return variant != null && variant.canClimb;
    }

    public static float GetJumpStrength(TransfurVariant<?> variant) {
        return variant == null ? 0.0f : variant.jumpStrength;
    }
}

