/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.util;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Mth;

@ParametersAreNonnullByDefault
public final class Vector2f {
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float x, float y) {
        this.set(x, y);
    }

    public Vector2f(Vector2f other) {
        this.set(other);
    }

    public static float distSqr(Vector2f vec, Vector2f other) {
        float dx = vec.x - other.x;
        float dy = vec.y - other.y;
        return dx * dx + dy * dy;
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f set(Vector2f other) {
        return this.set(other.x, other.y);
    }

    public Vector2f add(float x, float y) {
        return this.set(this.x + x, this.y + y);
    }

    public Vector2f add(Vector2f vec) {
        return this.add(vec.x, vec.y);
    }

    public Vector2f sub(float x, float y) {
        return this.set(this.x - x, this.y - y);
    }

    public Vector2f sub(Vector2f vec) {
        return this.sub(vec.x, vec.y);
    }

    public Vector2f mul(float scalar) {
        return this.set(this.x * scalar, this.y * scalar);
    }

    public Vector2f mul(float x, float y) {
        return this.set(this.x * x, this.y * y);
    }

    public Vector2f mul(Vector2f vec) {
        return this.mul(vec.x, vec.y);
    }

    public Vector2f div(float scalar) {
        return this.set(this.x / scalar, this.y / scalar);
    }

    public Vector2f div(float x, float y) {
        return this.set(this.x / x, this.y / y);
    }

    public Vector2f div(Vector2f vec) {
        return this.div(vec.x, vec.y);
    }

    public Vector2f lerp(float delta, Vector2f other) {
        return this.set(Mth.m_14179_((float)delta, (float)this.x, (float)other.x), Mth.m_14179_((float)delta, (float)this.y, (float)other.y));
    }

    public Vector2f clamp(float min, float max) {
        return this.set(Mth.m_14036_((float)this.x, (float)min, (float)max), Mth.m_14036_((float)this.y, (float)min, (float)max));
    }

    public Vector2f clamp(float minX, float maxX, float minY, float maxY) {
        return this.set(Mth.m_14036_((float)this.x, (float)minX, (float)maxX), Mth.m_14036_((float)this.y, (float)minY, (float)maxY));
    }

    public Vector2f clamp(Vector2f min, Vector2f max) {
        return this.clamp(min.x, max.x, min.y, max.y);
    }

    public Vector2f cpy() {
        return new Vector2f(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector2f)) {
            return false;
        }
        Vector2f vector2f = (Vector2f)o;
        return Float.compare(this.x, vector2f.x) == 0 && Float.compare(this.y, vector2f.y) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = 31 * result + Float.hashCode(this.y);
        return result;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }
}

