/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.variants;

import java.util.List;
import net.foxyas.changedaddon.procedures.CreatureDietsHandleProcedure;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.minecraft.nbt.CompoundTag;

public interface VariantExtraStats {
    public static final float defaultPlayerFlySpeed = 0.05f;

    default public float extraBlockBreakSpeed() {
        return 0.0f;
    }

    default public float getBlockBreakSpeedMultiplier() {
        return this.extraBlockBreakSpeed() + 1.0f;
    }

    default public float getFlySpeed() {
        return 0.0f;
    }

    default public FlyType getFlyType() {
        ChangedEntity changedEntity;
        VariantExtraStats variantExtraStats = this;
        if (variantExtraStats instanceof ChangedEntity && (changedEntity = (ChangedEntity)variantExtraStats).getSelfVariant() != null) {
            TransfurVariant variant = changedEntity.getSelfVariant();
            return variant.canGlide ? FlyType.BOTH : FlyType.NONE;
        }
        return FlyType.NONE;
    }

    default public void readExtraData(CompoundTag tag) {
    }

    default public void saveExtraData(CompoundTag tag) {
    }

    default public List<CreatureDietsHandleProcedure.DietType> getExtraDietTypes() {
        return List.of();
    }

    public static enum FlyType {
        NONE,
        ONLY_FALL,
        ONLY_FLY,
        BOTH;


        public boolean canGlide() {
            return this == ONLY_FALL || this == BOTH;
        }

        public boolean canFly() {
            return this == ONLY_FLY || this == BOTH;
        }
    }
}

