/*
 * Decompiled with CFR 0.152.
 */
package io.github.catomon.sddeathsoundsmod;

import io.github.catomon.sddeathsoundsmod.Config;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="scream_disappear_ds")
public class DeathSoundHandler {
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"scream_disappear_ds");
    public static final DeferredHolder<SoundEvent, SoundEvent> TYLER1 = SOUND_EVENTS.register("tyler1", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"tyler1")));
    public static final DeferredHolder<SoundEvent, SoundEvent> EMOJI = SOUND_EVENTS.register("emoji", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"emoji")));
    public static final DeferredHolder<SoundEvent, SoundEvent> YODA = SOUND_EVENTS.register("yoda", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"yoda")));
    public static final DeferredHolder<SoundEvent, SoundEvent> VSAUSE_MICHAEL = SOUND_EVENTS.register("vsause_michael", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"vsause_michael")));
    public static final DeferredHolder<SoundEvent, SoundEvent> MOIST_CR1TIKALZ = SOUND_EVENTS.register("moist_cr1tikalz", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"moist_cr1tikalz")));
    public static final DeferredHolder<SoundEvent, SoundEvent> TOM_SCOTT = SOUND_EVENTS.register("tom_scott", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"tom_scott")));
    public static final DeferredHolder<SoundEvent, SoundEvent> POPAYE_BISQUIT_GUY = SOUND_EVENTS.register("popaye_bisquit_guy", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"popaye_bisquit_guy")));
    public static final DeferredHolder<SoundEvent, SoundEvent> NIKOCADO_AVOCADO = SOUND_EVENTS.register("nikocado_avocado", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"nikocado_avocado")));
    public static final DeferredHolder<SoundEvent, SoundEvent> TOMMYINNIT = SOUND_EVENTS.register("tommyinnit", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"scream_disappear_ds", (String)"tommyinnit")));

    public static void register(IEventBus bus) {
        SOUND_EVENTS.register(bus);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ArrayList<SoundEvent> enabledSounds = new ArrayList<SoundEvent>();
            if (((Boolean)Config.playTyler1.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)TYLER1.get());
            }
            if (((Boolean)Config.playEmoji.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)EMOJI.get());
            }
            if (((Boolean)Config.playYoda.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)YODA.get());
            }
            if (((Boolean)Config.playVsauseMichael.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)VSAUSE_MICHAEL.get());
            }
            if (((Boolean)Config.playMoistCr1tikalz.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)MOIST_CR1TIKALZ.get());
            }
            if (((Boolean)Config.playTomScott.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)TOM_SCOTT.get());
            }
            if (((Boolean)Config.playPopayeBisquitGuy.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)POPAYE_BISQUIT_GUY.get());
            }
            if (((Boolean)Config.playTommyInnit.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)NIKOCADO_AVOCADO.get());
            }
            if (((Boolean)Config.playTommyInnit.get()).booleanValue()) {
                enabledSounds.add((SoundEvent)TOMMYINNIT.get());
            }
            if (!enabledSounds.isEmpty()) {
                SoundEvent soundToPlay = (SoundEvent)enabledSounds.get(new Random().nextInt(enabledSounds.size()));
                player.level().playSound(null, player.blockPosition(), soundToPlay, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

