/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.objectively;

import com.github.tatercertified.objectively.Command;
import com.github.tatercertified.objectively.Objectives;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleBuilder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_12279;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5198;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Objectively
implements ModInitializer {
    public static final List<class_266> objectivesOnJoin = new ArrayList<class_266>();
    private static final Path OBJECTIVELY_FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("objectively.json");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Objectively");
    public static final class_12279<Integer> SCOREBOARD_QUERY_FREQ = GameRuleBuilder.forInteger((int)1).minValue(Integer.valueOf(1)).category(class_5198.field_24094).buildAndRegister(class_2960.method_60655((String)"objectively", (String)"scoreboardQueryFrequency"));

    public void onInitialize() {
        Command.register();
        Objectives.init();
        ServerLifecycleEvents.SERVER_STARTING.register(this::loadObjectives);
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> {
            class_3222 player = serverPlayNetworkHandler.field_14140;
            for (class_266 objective : objectivesOnJoin) {
                if (!Objectives.notHaveObjective((class_9015)player, (class_269)minecraftServer.method_3845(), objective)) continue;
                minecraftServer.method_3845().method_1180((class_9015)serverPlayNetworkHandler.field_14140, objective);
            }
        });
    }

    public static void saveObjectives() {
        ArrayList<String> objectiveNames = new ArrayList<String>(objectivesOnJoin.size());
        for (class_266 objective : objectivesOnJoin) {
            objectiveNames.add(objective.method_1113());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(objectiveNames);
        try {
            if (Files.notExists(OBJECTIVELY_FILE_PATH, new LinkOption[0])) {
                Files.createFile(OBJECTIVELY_FILE_PATH, new FileAttribute[0]);
            }
            Files.writeString(OBJECTIVELY_FILE_PATH, (CharSequence)json, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadObjectives(MinecraftServer server) {
        Gson gson = new GsonBuilder().create();
        try {
            if (Files.exists(OBJECTIVELY_FILE_PATH, new LinkOption[0])) {
                String json = new String(Files.readAllBytes(OBJECTIVELY_FILE_PATH));
                List objectiveNames = (List)gson.fromJson(json, List.class);
                objectivesOnJoin.addAll(server.method_3845().method_1151().stream().filter(objective -> objectiveNames.contains(objective.method_1113())).toList());
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse config: ", (Throwable)e);
        }
    }
}

