/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.zetaplugins.netwatchz.common.NetwatchzServices;
import com.zetaplugins.netwatchz.common.config.IpInfoProviderConfig;
import com.zetaplugins.netwatchz.common.config.IpListConfig;
import com.zetaplugins.netwatchz.common.config.VpnBlockConfig;
import com.zetaplugins.netwatchz.common.ipapi.fetchers.IpDataFetcher;
import com.zetaplugins.netwatchz.common.iplist.IpListFetcher;
import com.zetaplugins.netwatchz.common.iplist.IpListService;
import com.zetaplugins.netwatchz.common.vpnblock.providers.VpnInfoProvider;
import com.zetaplugins.netwatchz.velocity.commands.IpInfoCommand;
import com.zetaplugins.netwatchz.velocity.listeners.PlayerLoginListener;
import com.zetaplugins.netwatchz.velocity.util.ConfigInitializer;
import com.zetaplugins.netwatchz.velocity.util.JulFromSlf4j;
import com.zetaplugins.netwatchz.velocity.util.Metrics;
import com.zetaplugins.netwatchz.velocity.util.VelocityConfigManager;
import com.zetaplugins.netwatchz.velocity.util.VelocityLocalizationService;
import com.zetaplugins.netwatchz.velocity.util.VelocityMessageService;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;

@Plugin(id="netwatchz", name="NetwatchZ", version="1.0.0", description="Anti VPN, Geoblocking and IP blacklisting plugin for Velocity", authors={"ZetaPlugins"}, url="zetaplugins.com")
public class NetwatchzVelocity {
    @Inject
    private Logger logger;
    @Inject
    private ProxyServer server;
    @Inject
    @DataDirectory
    private Path dataDirectory;
    @Inject
    private Metrics.Factory metricsFactory;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        new ConfigInitializer(this.logger, this.dataDirectory).initializeDefaultConfig();
        VelocityConfigManager configManager = new VelocityConfigManager(this.logger, this.dataDirectory);
        VelocityLocalizationService localizationService = new VelocityLocalizationService(this.dataDirectory, this.logger, List.of("en-US", "de-DE"), configManager.getString("lang", "en-US"));
        VelocityMessageService messageSevice = new VelocityMessageService(localizationService);
        IpInfoProviderConfig ipInfoCfg = configManager.loadIpInfoProviderConfig();
        IpListConfig ipListCfg = configManager.loadIpListConfig();
        VpnBlockConfig vpnBlockCfg = configManager.loadVpnBlockConfig();
        IpDataFetcher ipDataFetcher = IpDataFetcher.fromConfig((IpInfoProviderConfig)ipInfoCfg, (java.util.logging.Logger)new JulFromSlf4j("NetwatchZLogger", this.logger));
        IpListFetcher ipListFetcher = IpListFetcher.fromConfig((IpListConfig)ipListCfg, (java.util.logging.Logger)new JulFromSlf4j("NetwatchZLogger", this.logger));
        IpListService ipListService = IpListService.fromConfig((IpListConfig)ipListCfg, (java.util.logging.Logger)new JulFromSlf4j("NetwatchZLogger", this.logger));
        VpnInfoProvider vpnInfoProvider = VpnInfoProvider.fromConfig((VpnBlockConfig)vpnBlockCfg);
        NetwatchzServices services = new NetwatchzServices(ipDataFetcher, ipListService, ipListFetcher, vpnInfoProvider);
        this.server.getEventManager().register((Object)this, (Object)new PlayerLoginListener(this.server, services, configManager, this.logger, messageSevice));
        this.server.getCommandManager().register("ipinfo", (Command)new IpInfoCommand(this.server, services, messageSevice), new String[0]);
        this.initializeBStats(configManager);
        this.logger.info("NetwatchZ has been initialized!");
    }

    private void initializeBStats(VelocityConfigManager cfg) {
        int pluginId = 27407;
        Metrics metrics = this.metricsFactory.make(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("ip_info_provider", () -> cfg.getString("ip_info_provider.provider", "ip-api")));
        metrics.addCustomChart(new Metrics.SimplePie("geo_blocking_enabled", () -> cfg.getBoolean("geo_blocking.enabled", false) ? "true" : "false"));
        metrics.addCustomChart(new Metrics.SimplePie("ip_list_enabled", () -> cfg.getBoolean("ip_list.enabled", true) ? "true" : "false"));
    }
}

