/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.zetaplugins.netwatchz.common.NetwatchzServices;
import com.zetaplugins.netwatchz.common.ipapi.IpData;
import com.zetaplugins.netwatchz.velocity.util.VelocityMessageService;
import java.lang.invoke.CallSite;
import java.util.List;

public class IpInfoCommand
implements SimpleCommand {
    private final ProxyServer server;
    private final NetwatchzServices services;
    private final VelocityMessageService messageService;

    public IpInfoCommand(ProxyServer server, NetwatchzServices services, VelocityMessageService messageService) {
        this.server = server;
        this.services = services;
        this.messageService = messageService;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length != 1) {
            sender.sendMessage(this.messageService.getAndFormatMsg(false, "usage_error", "&cUsage: %usage%", new VelocityMessageService.Replaceable<String>("%usage%", "/ipinfo <player>")));
            return;
        }
        String targetName = args[0];
        Player player = this.server.getPlayer(targetName).orElse(null);
        if (player == null) {
            sender.sendMessage(this.messageService.getAndFormatMsg(false, "player_not_found", "&cPlayer not found!", new VelocityMessageService.Replaceable[0]));
            return;
        }
        String playerIp = player.getRemoteAddress().getAddress().getHostAddress();
        IpData ipData = this.services.ipDataFetcher().fetchIpData(playerIp);
        if (ipData == null) {
            sender.sendMessage(this.messageService.getAndFormatMsg(false, "ip_data_fetch_error", "&cFailed to fetch IP data for player %player%!", new VelocityMessageService.Replaceable<String>("%player%", targetName)));
            return;
        }
        sender.sendMessage(this.messageService.getAndFormatMsg(false, "ip_info", "<br>&8--- <gradient:#FF80AB:#D81B60>&lIP Information </gradient>&r&8---<br><br><#FF80AB>Player: <click:copy_to_clipboard:%player%><hover:show_text:'&7Click to copy to clipboard'>&7%player%</hover></click><br><#FF80AB>IP: <click:copy_to_clipboard:%ip%><hover:show_text:'&7Click to copy to clipboard'>&7%ip%</hover></click><br><#FF80AB>Country: <click:copy_to_clipboard:%country%><hover:show_text:'&7Click to copy to clipboard'>&7%country%</hover></click><br><#FF80AB>Region: <click:copy_to_clipboard:%region%><hover:show_text:'&7Click to copy to clipboard'>&7%region%</hover></click><br><#FF80AB>ISP: <click:copy_to_clipboard:%isp%><hover:show_text:'&7Click to copy to clipboard'>&7%isp%</hover></click><br><#FF80AB>Organization: <click:copy_to_clipboard:%org%><hover:show_text:'&7Click to copy to clipboard'>&7%org%</hover></click><br><#FF80AB>ASN: <click:copy_to_clipboard:%asn%><hover:show_text:'&7Click to copy to clipboard'>&7%asn%</hover></click><br><br>&8----------------------<br>", new VelocityMessageService.Replaceable<String>("%player%", targetName), new VelocityMessageService.Replaceable<String>("%ip%", ipData.ip()), new VelocityMessageService.Replaceable<CallSite>("%country%", (CallSite)((Object)(ipData.country() + " (" + ipData.countryCode() + ")"))), new VelocityMessageService.Replaceable<CallSite>("%region%", (CallSite)((Object)(ipData.regionName() + " (" + ipData.regionCode() + ")"))), new VelocityMessageService.Replaceable<String>("%city%", ipData.city()), new VelocityMessageService.Replaceable<String>("%isp%", ipData.isp()), new VelocityMessageService.Replaceable<String>("%org%", ipData.org()), new VelocityMessageService.Replaceable<String>("%asn%", ipData.asn())));
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 1) {
            return this.server.getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
        }
        return List.of();
    }
}

