/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.velocity.listeners;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import com.zetaplugins.netwatchz.common.NetwatchzServices;
import com.zetaplugins.netwatchz.common.ipapi.IpData;
import com.zetaplugins.netwatchz.common.vpnblock.VpnInfoData;
import com.zetaplugins.netwatchz.velocity.util.VelocityConfigManager;
import com.zetaplugins.netwatchz.velocity.util.VelocityMessageService;
import java.net.InetSocketAddress;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;

public class PlayerLoginListener {
    private final ProxyServer server;
    private final NetwatchzServices services;
    private final Logger logger;
    private final VelocityConfigManager cfg;
    private final VelocityMessageService msg;

    public PlayerLoginListener(ProxyServer server, NetwatchzServices services, VelocityConfigManager cfg, Logger logger, VelocityMessageService msg) {
        this.server = server;
        this.services = services;
        this.logger = logger;
        this.cfg = cfg;
        this.msg = msg;
    }

    @Subscribe
    public void onPreLogin(PreLoginEvent event) {
        InetSocketAddress address = event.getConnection().getRemoteAddress();
        String ip = address.getAddress().getHostAddress();
        String playerName = event.getUsername();
        if (this.handleIpListBlock(playerName, ip, event)) {
            return;
        }
        if (this.handleGeoBlock(playerName, ip, event)) {
            return;
        }
        this.handleVpnBlock(playerName, ip, event);
    }

    private boolean handleIpListBlock(String playerName, String ip, PreLoginEvent event) {
        boolean ipListEnabled = this.cfg.getBoolean("ip_list.enabled", true);
        if (!ipListEnabled) {
            return false;
        }
        String mode = this.cfg.getString("ip_list.mode", "blacklist").toLowerCase();
        boolean isInList = this.services.ipListService().isIpInAnyList(ip);
        if (mode.equals("blacklist") && isInList || mode.equals("whitelist") && !isInList) {
            this.logger.info("Blocked {} due to IP list ({})", (Object)playerName, (Object)ip);
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)this.msg.getAndFormatMsg(false, "iplist_ban_message", "&cYour IP address has been blocked due to suspicious activity!<br><br>&7If you believe this is an error, please contact support.", new VelocityMessageService.Replaceable[0])));
            return true;
        }
        return false;
    }

    private boolean handleGeoBlock(String playerName, String ip, PreLoginEvent event) {
        boolean blocked;
        boolean geoEnabled = this.cfg.getBoolean("geo_blocking.enabled", true);
        if (!geoEnabled) {
            return false;
        }
        IpData ipData = this.services.ipDataFetcher().fetchIpData(ip);
        if (ipData == null) {
            this.logger.warn("Failed to fetch IP data for {} ({})", (Object)playerName, (Object)ip);
            return false;
        }
        boolean blacklist = this.cfg.getBoolean("geo_blocking.blacklist", true);
        List<String> countryList = this.cfg.getStringList("geo_blocking.countries");
        boolean bl = blocked = blacklist && countryList.contains(ipData.countryCode()) || !blacklist && !countryList.contains(ipData.countryCode());
        if (blocked) {
            this.logger.info("Blocked {} due to geoblocking: {}", (Object)playerName, (Object)ipData.countryCode());
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)this.msg.getAndFormatMsg(false, "geoblock_ban_message", "&cYour IP address has been blocked due to suspicious activity!<br><br>&7If you believe this is an error, please contact support.", new VelocityMessageService.Replaceable[0])));
            return true;
        }
        return false;
    }

    private void handleVpnBlock(String playerName, String ip, PreLoginEvent event) {
        boolean vpnEnabled = this.cfg.getBoolean("vpn_block.enabled", true);
        if (!vpnEnabled) {
            return;
        }
        VpnInfoData vpnData = this.services.vpnInfoProvider().fetchVpnData(ip);
        if (vpnData == null) {
            this.logger.warn("Failed to fetch VPN info for {} ({})", (Object)playerName, (Object)ip);
            return;
        }
        if (!(vpnData.isVpn() || vpnData.isProxy() || vpnData.isTor() || vpnData.isRelay() || vpnData.isHosting())) {
            return;
        }
        String type = vpnData.isVpn() ? "vpn" : (vpnData.isProxy() ? "proxy" : (vpnData.isTor() ? "tor" : (vpnData.isRelay() ? "relay" : (vpnData.isHosting() ? "hosting" : "unknown"))));
        this.logger.info("Blocked {} due to {}", (Object)playerName, (Object)type);
        List<String> commands = this.cfg.getStringList("vpn_block." + type + ".commands");
        boolean shouldBlock = this.cfg.getBoolean("vpn_block." + type + ".block", true);
        for (String cmd : commands) {
            String parsed = cmd.replace("%player%", playerName).replace("%ip%", ip);
            this.server.getScheduler().buildTask((Object)this.server, () -> this.server.getCommandManager().executeAsync((CommandSource)this.server.getConsoleCommandSource(), parsed)).schedule();
        }
        if (shouldBlock) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)this.msg.getAndFormatMsg(false, "vpnblock_ban_message", "&cYour IP address has been blocked because it is associated with a VPN service!<br>Try disabling your VPN and reconnecting.<br><br>&7If you believe this is an error, please contact support.", new VelocityMessageService.Replaceable[0])));
        }
    }
}

