/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.velocity.util;

import com.google.inject.Inject;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public class ConfigInitializer {
    private final Logger logger;
    private final Path dataDirectory;

    @Inject
    public ConfigInitializer(Logger logger, @DataDirectory Path dataDirectory) {
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    public void initializeDefaultConfig() {
        Path configFile = this.dataDirectory.resolve("config.yml");
        if (Files.notExists(configFile, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
                try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("config.yml");){
                    if (in == null) {
                        this.logger.error("Default config.yml not found in plugin resources!");
                        return;
                    }
                    Files.copy(in, configFile, new CopyOption[0]);
                    this.logger.info("Default config.yml created in {}", (Object)configFile.toAbsolutePath());
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to create default config.yml", (Throwable)e);
            }
        } else {
            this.logger.info("Config file already exists: {}", (Object)configFile.toAbsolutePath());
        }
    }
}

