/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.velocity.util;

import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.zetaplugins.netwatchz.common.config.ConfigManager;
import com.zetaplugins.netwatchz.common.config.CustomProviderConfig;
import com.zetaplugins.netwatchz.common.config.GeoLite2Config;
import com.zetaplugins.netwatchz.common.config.IpInfoProviderConfig;
import com.zetaplugins.netwatchz.common.config.IpListConfig;
import com.zetaplugins.netwatchz.common.config.VpnBlockConfig;
import com.zetaplugins.netwatchz.common.iplist.IpListFetchJob;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class VelocityConfigManager
extends ConfigManager {
    private final Logger logger;
    private final Path dataDirectory;
    private ConfigurationNode rootNode;

    public VelocityConfigManager(Logger logger, @DataDirectory Path dataDirectory) {
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        Path configFile = dataDirectory.resolve("config.yml");
        try {
            if (Files.notExists(configFile, new LinkOption[0])) {
                Files.createDirectories(dataDirectory, new FileAttribute[0]);
                InputStream configStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml");
                if (configStream == null) {
                    throw new IOException("Default config.yml not found in resources.");
                }
                Files.copy(configStream, configFile, new CopyOption[0]);
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configFile)).build();
            this.rootNode = loader.load();
        }
        catch (IOException e) {
            logger.error("Failed to load config.yml", (Throwable)e);
        }
    }

    public String getString(String path, String def) {
        try {
            return this.rootNode.node((Object[])path.split("\\.")).getString(def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public List<String> getStringList(String path) {
        try {
            return this.rootNode.node((Object[])path.split("\\.")).getList(String.class, List.of());
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public boolean getBoolean(String path, boolean def) {
        try {
            return this.rootNode.node((Object[])path.split("\\.")).getBoolean(def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public int getInt(String path, int def) {
        try {
            return this.rootNode.node((Object[])path.split("\\.")).getInt(def);
        }
        catch (Exception e) {
            return def;
        }
    }

    private ConfigurationNode getNode(String path) {
        return this.rootNode.node((Object[])path.split("\\."));
    }

    public IpInfoProviderConfig loadIpInfoProviderConfig() {
        String raw;
        IpInfoProviderConfig.Provider p = switch (raw = this.getString("ip_info_provider.provider", "ip-api").trim().toLowerCase(Locale.ROOT)) {
            case "ipwhois" -> IpInfoProviderConfig.Provider.IPWHOIS;
            case "geolite2" -> IpInfoProviderConfig.Provider.GEOLITE2;
            case "custom" -> IpInfoProviderConfig.Provider.CUSTOM;
            default -> IpInfoProviderConfig.Provider.IP_API;
        };
        GeoLite2Config geo = null;
        if (p == IpInfoProviderConfig.Provider.GEOLITE2) {
            String asnUrl = this.getString("ip_info_provider.geolite2.asn_url", "");
            String cityUrl = this.getString("ip_info_provider.geolite2.city_url", "");
            String countryUrl = this.getString("ip_info_provider.geolite2.country_url", "");
            Path storage = this.dataDirectory.resolve("GeoLite2");
            if (!asnUrl.isBlank() && !VelocityConfigManager.isValidUrl((String)asnUrl)) {
                this.logger.warn("Invalid GeoLite2 ASN URL; ignoring.");
                asnUrl = "";
            }
            if (!cityUrl.isBlank() && !VelocityConfigManager.isValidUrl((String)cityUrl)) {
                this.logger.warn("Invalid GeoLite2 City URL; ignoring.");
                cityUrl = "";
            }
            if (!countryUrl.isBlank() && !VelocityConfigManager.isValidUrl((String)countryUrl)) {
                this.logger.warn("Invalid GeoLite2 Country URL; ignoring.");
                countryUrl = "";
            }
            geo = new GeoLite2Config(asnUrl, cityUrl, countryUrl, storage, Duration.ofDays(7L));
        }
        CustomProviderConfig custom = null;
        if (p == IpInfoProviderConfig.Provider.CUSTOM) {
            String apiUrl = this.getString("ip_info_provider.custom.url", "http://ip-api.com/json/%ip%");
            ConfigurationNode headersNode = this.getNode("ip_info_provider.custom.headers");
            HashMap headers = new HashMap();
            headersNode.childrenMap().forEach((k, v) -> headers.put(k.toString(), v.getString("")));
            ConfigurationNode parseNode = this.getNode("ip_info_provider.custom.parse_fields");
            HashMap parseFields = new HashMap();
            parseNode.childrenMap().forEach((k, v) -> parseFields.put(k.toString(), v.getString("")));
            custom = new CustomProviderConfig(apiUrl, headers, parseFields);
        }
        return new IpInfoProviderConfig(p, geo, custom);
    }

    public IpListConfig loadIpListConfig() {
        List<String> listNames;
        Path ipListsDir = this.dataDirectory.resolve("ipLists");
        try {
            Files.createDirectories(ipListsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.warn("Failed to create ipLists directory at {}", (Object)ipListsDir, (Object)e);
        }
        try {
            listNames = this.rootNode.node(new Object[]{"ip_list", "lists"}).getList(String.class, List.of()).stream().map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
        catch (SerializationException e) {
            this.logger.warn("Failed to load IP list names from config", (Throwable)e);
            return new IpListConfig(ipListsDir, List.of(), Set.of());
        }
        ArrayList<IpListFetchJob> jobs = new ArrayList<IpListFetchJob>();
        ConfigurationNode jobsNode = this.getNode("ip_list.fetch_jobs");
        for (Map.Entry entry : jobsNode.childrenMap().entrySet()) {
            ConfigurationNode jobNode = (ConfigurationNode)entry.getValue();
            String url = jobNode.node(new Object[]{"url"}).getString("").trim();
            String filename = jobNode.node(new Object[]{"filename"}).getString("").trim();
            int intervalHours = Math.max(1, jobNode.node(new Object[]{"update_interval_hours"}).getInt(24));
            if (!url.isEmpty() && !filename.isEmpty()) {
                jobs.add(new IpListFetchJob(url, ipListsDir.resolve(filename), Duration.ofHours(intervalHours)));
                continue;
            }
            this.logger.warn("Invalid fetch job '{}', missing url or filename", entry.getKey());
        }
        return new IpListConfig(ipListsDir, jobs, new HashSet<String>(listNames));
    }

    public VpnBlockConfig loadVpnBlockConfig() {
        String raw;
        boolean enabled = this.rootNode.node(new Object[]{"vpn_block.enabled"}).getBoolean(false);
        String apiKey = this.getString("vpn_block.api_key", "").trim();
        VpnBlockConfig.Provider p = switch (raw = this.getString("vpn_block.provider", "vpnapi").trim().toLowerCase(Locale.ROOT)) {
            case "custom" -> VpnBlockConfig.Provider.CUSTOM;
            case "proxycheck" -> VpnBlockConfig.Provider.PROXYCHECK;
            default -> VpnBlockConfig.Provider.VPNAPI;
        };
        CustomProviderConfig custom = null;
        if (p == VpnBlockConfig.Provider.CUSTOM) {
            String apiUrl = this.getString("vpn_block.custom.url", "");
            if (apiUrl.isBlank() || !VelocityConfigManager.isValidUrl((String)apiUrl)) {
                this.logger.warn("Invalid VPN Block custom URL; defaulting to VPNAPI.");
                p = VpnBlockConfig.Provider.VPNAPI;
            } else {
                ConfigurationNode headersNode = this.getNode("vpn_block.custom.headers");
                HashMap headers = new HashMap();
                headersNode.childrenMap().forEach((k, v) -> headers.put(k.toString(), v.getString("")));
                ConfigurationNode parseNode = this.getNode("vpn_block.custom.parse_fields");
                HashMap parseFields = new HashMap();
                parseNode.childrenMap().forEach((k, v) -> parseFields.put(k.toString(), v.getString("")));
                custom = new CustomProviderConfig(apiUrl, headers, parseFields);
            }
        }
        return new VpnBlockConfig(enabled, p, apiKey, custom);
    }
}

