/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.velocity.util;

import com.google.inject.Inject;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class VelocityLocalizationService {
    private final Path dataDirectory;
    private final Logger logger;
    private final List<String> defaultLangs;
    private final String langToUse;
    private final String langFolder;
    private Map<String, Object> langConfig;

    @Inject
    public VelocityLocalizationService(@DataDirectory Path dataDirectory, Logger logger, List<String> defaultLangs, String langToUse) {
        this(dataDirectory, logger, defaultLangs, langToUse, "lang/");
    }

    public VelocityLocalizationService(Path dataDirectory, Logger logger, List<String> defaultLangs, String langToUse, String langFolder) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.defaultLangs = defaultLangs;
        this.langToUse = langToUse;
        this.langFolder = langFolder;
        this.loadLanguageConfig();
    }

    public void reload() {
        this.loadLanguageConfig();
    }

    private void loadLanguageConfig() {
        try {
            Path langDir = this.dataDirectory.resolve(this.langFolder);
            if (!Files.exists(langDir, new LinkOption[0])) {
                Files.createDirectories(langDir, new FileAttribute[0]);
            }
            for (String lang : this.defaultLangs) {
                Path langFile = langDir.resolve(lang + ".yml");
                if (Files.exists(langFile, new LinkOption[0])) continue;
                InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(this.langFolder + lang + ".yml");
                try {
                    if (resourceStream != null) {
                        Files.copy(resourceStream, langFile, StandardCopyOption.REPLACE_EXISTING);
                        this.logger.info("Saved default language file: {}", (Object)langFile);
                        continue;
                    }
                    this.logger.warn("Default language resource {}.yml not found in JAR", (Object)lang);
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
            Path selectedLangFile = langDir.resolve(this.langToUse + ".yml");
            if (!Files.exists(selectedLangFile, new LinkOption[0])) {
                this.logger.error("Selected language {} not found. Messages will not be localized.", (Object)this.langToUse);
                return;
            }
            this.logger.info("Using language file: {}", (Object)selectedLangFile);
            try (InputStream is = Files.newInputStream(selectedLangFile, new OpenOption[0]);){
                Yaml yaml = new Yaml();
                this.langConfig = (Map)yaml.load(is);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load language configuration", (Throwable)e);
        }
    }

    public String getString(String key) {
        return this.langConfig.getOrDefault(key, key).toString();
    }

    public String getString(String key, String fallback) {
        Object value = this.langConfig.get(key);
        return value != null ? value.toString() : fallback;
    }

    public List<String> getStringList(String key) {
        Object value = this.langConfig.get(key);
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        return List.of();
    }
}

