/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.spigot.listeners;

import com.zetaplugins.netwatchz.common.ipapi.IpData;
import com.zetaplugins.netwatchz.common.vpnblock.VpnInfoData;
import com.zetaplugins.netwatchz.spigot.NetwatchZSpigot;
import com.zetaplugins.netwatchz.spigot.util.SpigotMessageService;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;

public final class AsyncPlayerPreLoginListener
implements Listener {
    private final NetwatchZSpigot plugin;

    public AsyncPlayerPreLoginListener(NetwatchZSpigot plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        boolean enableVpnBlocking;
        UUID playerUuid;
        OfflinePlayer offlinePlayer;
        String playerName = event.getName();
        String playerIp = NetwatchZSpigot.getIpFromInetAdress(event.getAddress());
        boolean bypassOp = this.plugin.getConfig().getBoolean("always_allow_ops", true);
        if (bypassOp && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)(playerUuid = event.getUniqueId()))).isOp()) {
            return;
        }
        boolean ipListEnabled = this.plugin.getConfig().getBoolean("ip_list.enabled", true);
        if (ipListEnabled && this.handleIpListBlocking(playerName, playerIp, event)) {
            return;
        }
        boolean enableGeoBlocking = this.plugin.getConfig().getBoolean("geo_blocking.enabled", true);
        if (enableGeoBlocking) {
            IpData ipData = this.plugin.getIpDataFetcher().fetchIpData(playerIp);
            if (ipData == null) {
                this.plugin.getLogger().warning("Failed to fetch IP data for player " + playerName + " with IP: " + playerIp);
                return;
            }
            if (this.handleGeoBlocking(ipData, playerName, playerIp, event)) {
                return;
            }
        }
        if (enableVpnBlocking = this.plugin.getConfig().getBoolean("vpn_block.enabled", true)) {
            VpnInfoData vpnInfoData = this.plugin.getVpnInfoProvider().fetchVpnData(playerIp);
            if (vpnInfoData == null) {
                this.plugin.getLogger().warning("Failed to fetch VPN info for player " + playerName + " with IP: " + playerIp);
                return;
            }
            if (this.handleVpnBlocking(vpnInfoData, playerName, playerIp, event)) {
                return;
            }
        }
    }

    private boolean handleGeoBlocking(IpData ipData, String playerName, String playerIp, AsyncPlayerPreLoginEvent event) {
        boolean blackList = this.plugin.getConfig().getBoolean("geo_blocking.blacklist", true);
        List countryList = this.plugin.getConfig().getStringList("geo_blocking.countries");
        if (blackList && countryList.contains(ipData.countryCode()) || !blackList && !countryList.contains(ipData.countryCode())) {
            this.plugin.getLogger().info("Player " + playerName + " with IP: " + playerIp + " was blocked due to country: " + ipData.countryCode());
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, this.plugin.getMessageService().getAndFormatMsg(false, "geoblock_ban_message", "&cYour IP address has been blocked due to suspicious activity!<br><br>&7If you believe this is an error, please contact support.", new SpigotMessageService.Replaceable[0]));
            return true;
        }
        return false;
    }

    private boolean handleIpListBlocking(String playerName, String playerIp, AsyncPlayerPreLoginEvent event) {
        String ipListMode = this.plugin.getConfig().getString("ip_list.mode", "blacklist").toLowerCase();
        if (ipListMode.equals("blacklist") || ipListMode.equals("whitelist")) {
            boolean isInList = this.plugin.getIpListService().isIpInAnyList(playerIp);
            if (ipListMode.equals("blacklist") && isInList) {
                this.plugin.getLogger().info("Player " + playerName + " with IP: " + playerIp + " was blocked (blacklist).");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, this.getFormattedIpListBanMessage());
                return true;
            }
            if (ipListMode.equals("whitelist") && !isInList) {
                this.plugin.getLogger().info("Player " + playerName + " with IP: " + playerIp + " was blocked (not in whitelist).");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, this.getFormattedIpListBanMessage());
                return true;
            }
        }
        return false;
    }

    private String getFormattedIpListBanMessage() {
        return this.plugin.getMessageService().getAndFormatMsg(false, "iplist_ban_message", "&cYour IP address has been blocked due to suspicious activity!<br><br>&7If you believe this is an error, please contact support.", new SpigotMessageService.Replaceable[0]);
    }

    private boolean handleVpnBlocking(VpnInfoData ipData, String playerName, String playerIp, AsyncPlayerPreLoginEvent event) {
        String type = null;
        if (ipData.isVpn()) {
            type = "is_vpn";
        } else if (ipData.isProxy()) {
            type = "is_proxy";
        } else if (ipData.isTor()) {
            type = "is_tor";
        } else if (ipData.isRelay()) {
            type = "is_relay";
        } else if (ipData.isHosting()) {
            type = "is_hosting";
        }
        if (type == null) {
            return false;
        }
        List commands = this.plugin.getConfig().getStringList("vpn_block." + type + ".commands");
        for (String command : commands) {
            String parsedCommand = command.replace("%player%", playerName).replace("%ip%", playerIp);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCommand));
        }
        boolean shouldBlock = this.plugin.getConfig().getBoolean("vpn_block." + type + ".block", true);
        if (shouldBlock) {
            this.plugin.getLogger().info("Player " + playerName + " with IP: " + playerIp + " was blocked due to VPN/Proxy/Tor/Relay/Hosting usage.");
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, this.plugin.getMessageService().getAndFormatMsg(false, "vpnblock_ban_message", "&cYour IP address has been blocked because it is associated with a VPN service!<br>Try disabling your VPN and reconnecting.<br><br>&7If you believe this is an error, please contact support.", new SpigotMessageService.Replaceable[0]));
            return true;
        }
        return false;
    }
}

