/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.spigot.util;

import com.zetaplugins.zetacore.services.LocalizationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class SpigotMessageService {
    private final LocalizationService localizationService;
    private static final Map<String, String> colorMap = new HashMap<String, String>();

    public SpigotMessageService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public static String formatMsg(String msg, Replaceable<?> ... replaceables) {
        msg = SpigotMessageService.replacePlaceholders(msg, replaceables);
        return SpigotMessageService.convertToLegacy(msg);
    }

    public String getAndFormatMsg(boolean addPrefix, String path, String fallback, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        String msg = this.localizationService.getString(path, fallback);
        String prefix = this.localizationService.getString("prefix", "&8[&aTimberZ&8]");
        msg = !prefix.isEmpty() && addPrefix ? prefix + " " + msg : msg;
        msg = this.replacePlaceholdersWithAccentColors(msg, replaceables);
        return SpigotMessageService.convertToLegacy(msg);
    }

    public List<String> getAndFormatMsgList(String path, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        List<String> msgList = this.localizationService.getStringList(path);
        ArrayList<String> components = new ArrayList<String>();
        for (String string : msgList) {
            String s = this.replacePlaceholdersWithAccentColors(string, replaceables);
            components.add(SpigotMessageService.convertToLegacy(s));
        }
        return components;
    }

    public String getAccentColor() {
        return this.localizationService.getString("accentColor", "&a");
    }

    @NotNull
    public static String replacePlaceholders(String msg, Replaceable<?> ... replaceables) {
        StringBuilder msgBuilder = new StringBuilder(msg);
        for (Replaceable<?> replaceable : replaceables) {
            String placeholder = replaceable.placeholder();
            String value = String.valueOf(replaceable.value());
            SpigotMessageService.replaceInBuilder(msgBuilder, placeholder, value);
        }
        colorMap.forEach((key, valuex) -> SpigotMessageService.replaceInBuilder(msgBuilder, key, valuex));
        return msgBuilder.toString();
    }

    @NotNull
    public String replacePlaceholdersWithAccentColors(String msg, Replaceable<?> ... replaceables) {
        String replacedMsg = SpigotMessageService.replacePlaceholders(msg, replaceables);
        StringBuilder msgBuilder = new StringBuilder(replacedMsg);
        SpigotMessageService.replaceInBuilder(msgBuilder, "%ac%", this.getAccentColor());
        return msgBuilder.toString();
    }

    public static String convertToLegacy(String input) {
        if (input == null) {
            return "";
        }
        String out = input.replace("<br>", "\n").replace("<br/>", "\n").replace("<br />", "\n");
        out = out.replaceAll("(?i)</?click(?::[^>]*)?>", "");
        out = out.replaceAll("(?i)</?hover(?::[^>]*)?>", "");
        Pattern gradPat = Pattern.compile("(?i)<gradient:#([0-9a-fA-F]{6}):#([0-9a-fA-F]{6})>(.*?)</gradient>", 32);
        Matcher gradMatcher = gradPat.matcher(out);
        StringBuilder gradBuff = new StringBuilder();
        while (gradMatcher.find()) {
            String fromHex = gradMatcher.group(1);
            String toHex = gradMatcher.group(2);
            String inner = gradMatcher.group(3);
            String replaced = SpigotMessageService.applyGradientToText(inner, fromHex, toHex);
            gradMatcher.appendReplacement(gradBuff, Matcher.quoteReplacement(replaced));
        }
        gradMatcher.appendTail(gradBuff);
        out = gradBuff.toString();
        Pattern hexPat = Pattern.compile("(?i)<#([0-9a-fA-F]{6})>");
        Matcher hexMatcher = hexPat.matcher(out);
        StringBuilder hexBuff = new StringBuilder();
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1);
            hexMatcher.appendReplacement(hexBuff, Matcher.quoteReplacement(SpigotMessageService.hexToLegacy(hex)));
        }
        hexMatcher.appendTail(hexBuff);
        out = hexBuff.toString();
        out = out.replace("<b>", "\u00a7l");
        out = out.replace("</b>", "\u00a7r");
        out = out.replace("<i>", "\u00a7o");
        out = out.replace("</i>", "\u00a7r");
        out = out.replace("<u>", "\u00a7n");
        out = out.replace("</u>", "\u00a7r");
        out = out.replace("<s>", "\u00a7m");
        out = out.replace("</s>", "\u00a7r");
        out = out.replace("<obf>", "\u00a7k");
        out = out.replace("</obf>", "\u00a7r");
        out = out.replace("<!b>", "\u00a7r");
        out = out.replace("<!i>", "\u00a7r");
        out = out.replace("<!u>", "\u00a7r");
        out = out.replace("<!s>", "\u00a7r");
        out = out.replace("<!obf>", "\u00a7r");
        out = out.replace('&', '\u00a7');
        return out;
    }

    private static String applyGradientToText(String text, String fromHex, String toHex) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        text = text.replace('&', '\u00a7');
        int len = text.codePointCount(0, text.length());
        int[] from = SpigotMessageService.hexToRgb(fromHex);
        int[] to = SpigotMessageService.hexToRgb(toHex);
        StringBuilder sb = new StringBuilder();
        Object activeFormatting = "";
        int cpIndex = 0;
        int offset = 0;
        while (offset < text.length()) {
            int cp = text.codePointAt(offset);
            int charLen = Character.charCount(cp);
            if (cp == 167 && offset + 1 < text.length()) {
                char code = text.charAt(offset + 1);
                if ("lmnok".indexOf(code) != -1) {
                    activeFormatting = (String)activeFormatting + "\u00a7" + code;
                } else if (code == 'r') {
                    activeFormatting = "";
                }
                offset += 2;
                continue;
            }
            double t = len == 1 ? 0.0 : (double)cpIndex / (double)(len - 1);
            int r = (int)Math.round(SpigotMessageService.lerp(from[0], to[0], t));
            int g = (int)Math.round(SpigotMessageService.lerp(from[1], to[1], t));
            int b = (int)Math.round(SpigotMessageService.lerp(from[2], to[2], t));
            String hex = String.format("%02x%02x%02x", r, g, b);
            sb.append(SpigotMessageService.hexToLegacy(hex));
            sb.append((String)activeFormatting);
            sb.appendCodePoint(cp);
            offset += charLen;
            ++cpIndex;
        }
        return sb.toString();
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    private static int[] hexToRgb(String hex) {
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return new int[]{r, g, b};
    }

    private static String hexToLegacy(String hex) {
        hex = hex.replace("#", "");
        StringBuilder sb = new StringBuilder("\u00a7x");
        for (char c : hex.toLowerCase().toCharArray()) {
            sb.append('\u00a7').append(c);
        }
        return sb.toString();
    }

    private static void replaceInBuilder(StringBuilder builder, String placeholder, String replacement) {
        int index;
        if (placeholder == null || placeholder.isEmpty()) {
            return;
        }
        int start = 0;
        while ((index = builder.indexOf(placeholder, start)) != -1) {
            builder.replace(index, index + placeholder.length(), replacement);
            start = index + replacement.length();
            if (start >= 0 && start <= builder.length()) continue;
            break;
        }
    }

    static {
        colorMap.put("&0", "&0");
        colorMap.put("&1", "&1");
        colorMap.put("&2", "&2");
        colorMap.put("&3", "&3");
        colorMap.put("&4", "&4");
        colorMap.put("&5", "&5");
        colorMap.put("&6", "&6");
        colorMap.put("&7", "&7");
        colorMap.put("&8", "&8");
        colorMap.put("&9", "&9");
        colorMap.put("&a", "&a");
        colorMap.put("&b", "&b");
        colorMap.put("&c", "&c");
        colorMap.put("&d", "&d");
        colorMap.put("&e", "&e");
        colorMap.put("&f", "&f");
        colorMap.put("&k", "&k");
        colorMap.put("&l", "&l");
        colorMap.put("&m", "&m");
        colorMap.put("&n", "&n");
        colorMap.put("&o", "&o");
        colorMap.put("&r", "&r");
    }

    public record Replaceable<T>(String placeholder, T value) {
    }
}

