/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.paper;

import com.zetaplugins.netwatchz.common.config.IpInfoProviderConfig;
import com.zetaplugins.netwatchz.common.config.IpListConfig;
import com.zetaplugins.netwatchz.common.config.VpnBlockConfig;
import com.zetaplugins.netwatchz.common.ipapi.fetchers.IpDataFetcher;
import com.zetaplugins.netwatchz.common.iplist.IpListFetcher;
import com.zetaplugins.netwatchz.common.iplist.IpListService;
import com.zetaplugins.netwatchz.common.vpnblock.providers.VpnInfoProvider;
import com.zetaplugins.netwatchz.paper.util.CommandManager;
import com.zetaplugins.netwatchz.paper.util.EventManager;
import com.zetaplugins.netwatchz.paper.util.Metrics;
import com.zetaplugins.netwatchz.paper.util.PaperConfigManager;
import com.zetaplugins.zetacore.ZetaCorePlugin;
import com.zetaplugins.zetacore.services.LocalizationService;
import com.zetaplugins.zetacore.services.MessageService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class NetwatchZPaper
extends ZetaCorePlugin {
    private IpDataFetcher ipDataFetcher;
    private LocalizationService localizationService;
    private MessageService messageService;
    private IpListService ipListService;
    private IpListFetcher ipListFetcher;
    private VpnInfoProvider vpnInfoProvider;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        PaperConfigManager configManager = new PaperConfigManager(this);
        IpInfoProviderConfig ipInfoCfg = configManager.loadIpInfoProviderConfig();
        IpListConfig ipListCfg = configManager.loadIpListConfig();
        VpnBlockConfig vpnBlockCfg = configManager.loadVpnBlockConfig();
        this.ipDataFetcher = IpDataFetcher.fromConfig((IpInfoProviderConfig)ipInfoCfg, (Logger)this.getLogger());
        this.ipListFetcher = IpListFetcher.fromConfig((IpListConfig)ipListCfg, (Logger)this.getLogger());
        this.ipListService = IpListService.fromConfig((IpListConfig)ipListCfg, (Logger)this.getLogger());
        this.vpnInfoProvider = VpnInfoProvider.fromConfig((VpnBlockConfig)vpnBlockCfg);
        this.localizationService = new LocalizationService(this, (List<String>)new ArrayList<String>(){
            {
                this.add("en-US");
                this.add("de-DE");
            }
        });
        this.messageService = new MessageService(this.localizationService);
        new EventManager(this).registerListeners();
        new CommandManager(this).registerCommands();
        this.initializeBStats();
        this.getLogger().info("NetwatchZ-Paper has been enabled!");
    }

    public IpDataFetcher getIpDataFetcher() {
        return this.ipDataFetcher;
    }

    public IpListService getIpListService() {
        return this.ipListService;
    }

    public IpListFetcher getIpListFetcher() {
        return this.ipListFetcher;
    }

    public VpnInfoProvider getVpnInfoProvider() {
        return this.vpnInfoProvider;
    }

    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void onDisable() {
        if (this.ipDataFetcher != null) {
            this.ipDataFetcher.onShutDown();
        }
        this.getLogger().info("NetwatchZ-Paper has been disabled!");
    }

    public static String getIpFromInetAdress(InetAddress addr) {
        return addr.getHostAddress();
    }

    private void initializeBStats() {
        int pluginId = 27376;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("ip_info_provider", () -> this.getConfig().getString("ip_info_provider.provider")));
        metrics.addCustomChart(new Metrics.SimplePie("geo_blocking_enabled", () -> this.getConfig().getBoolean("geo_blocking.enabled") ? "true" : "false"));
        metrics.addCustomChart(new Metrics.SimplePie("ip_list_enabled", () -> this.getConfig().getBoolean("ip_list.enabled") ? "true" : "false"));
    }
}

