/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.paper.commands;

import com.zetaplugins.netwatchz.common.ipapi.IpData;
import com.zetaplugins.netwatchz.paper.NetwatchZPaper;
import com.zetaplugins.zetacore.services.MessageService;
import java.lang.invoke.CallSite;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IpInfoCommand
implements CommandExecutor,
TabCompleter {
    private final NetwatchZPaper plugin;

    public IpInfoCommand(NetwatchZPaper plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "usage_error", "&cUsage: %usage%", new MessageService.Replaceable<String>("%usage%", "/ipinfo <name>")));
            return false;
        }
        String playerName = args[0];
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "player_not_found", "&cPlayer not found!", new MessageService.Replaceable[0]));
            return false;
        }
        String playerIp = player.getAddress() != null ? NetwatchZPaper.getIpFromInetAdress(player.getAddress().getAddress()) : "Unknown IP";
        IpData ipData = this.plugin.getIpDataFetcher().fetchIpData(playerIp);
        if (ipData == null) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "ip_data_fetch_error", "&cFailed to fetch IP data for player %player%!", new MessageService.Replaceable<String>("%player%", playerName)));
            return false;
        }
        sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "ip_info", "&7IP: &e%ip%&7 | Country: &e%country%&7 | Region: &e%region%&7 | City: &e%city%&7 | ISP: &e%isp%", new MessageService.Replaceable<String>("%player%", playerName), new MessageService.Replaceable<String>("%ip%", ipData.ip()), new MessageService.Replaceable<CallSite>("%country%", (CallSite)((Object)(ipData.country() + " (" + ipData.countryCode() + ")"))), new MessageService.Replaceable<CallSite>("%region%", (CallSite)((Object)(ipData.regionName() + " (" + ipData.regionCode() + ")"))), new MessageService.Replaceable<String>("%city%", ipData.city()), new MessageService.Replaceable<String>("%isp%", ipData.isp()), new MessageService.Replaceable<String>("%org%", ipData.org()), new MessageService.Replaceable<String>("%asn%", ipData.asn())));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return null;
        }
        return List.of();
    }
}

