/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.paper.util;

import com.zetaplugins.netwatchz.common.config.ConfigManager;
import com.zetaplugins.netwatchz.common.config.CustomProviderConfig;
import com.zetaplugins.netwatchz.common.config.GeoLite2Config;
import com.zetaplugins.netwatchz.common.config.IpInfoProviderConfig;
import com.zetaplugins.netwatchz.common.config.IpListConfig;
import com.zetaplugins.netwatchz.common.config.VpnBlockConfig;
import com.zetaplugins.netwatchz.common.iplist.IpListFetchJob;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class PaperConfigManager
extends ConfigManager {
    private final JavaPlugin plugin;
    private final FileConfiguration cfg;

    public PaperConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.cfg = plugin.getConfig();
    }

    public IpInfoProviderConfig loadIpInfoProviderConfig() {
        String raw;
        IpInfoProviderConfig.Provider p = switch (raw = this.cfg.getString("ip_info_provider.provider", "ip-api").trim().toLowerCase(Locale.ROOT)) {
            case "ipwhois" -> IpInfoProviderConfig.Provider.IPWHOIS;
            case "geolite2" -> IpInfoProviderConfig.Provider.GEOLITE2;
            case "custom" -> IpInfoProviderConfig.Provider.CUSTOM;
            default -> IpInfoProviderConfig.Provider.IP_API;
        };
        GeoLite2Config geo = null;
        if (p == IpInfoProviderConfig.Provider.GEOLITE2) {
            String asnUrl = this.cfg.getString("ip_info_provider.geolite2.asn_url", "");
            String cityUrl = this.cfg.getString("ip_info_provider.geolite2.city_url", "");
            String countryUrl = this.cfg.getString("ip_info_provider.geolite2.country_url", "");
            Path storage = this.plugin.getDataFolder().toPath().resolve("GeoLite2");
            if (!asnUrl.isBlank() && !PaperConfigManager.isValidUrl((String)asnUrl)) {
                this.plugin.getLogger().warning("Invalid GeoLite2 ASN URL; ignoring.");
                asnUrl = "";
            }
            if (!cityUrl.isBlank() && !PaperConfigManager.isValidUrl((String)cityUrl)) {
                this.plugin.getLogger().warning("Invalid GeoLite2 City URL; ignoring.");
                cityUrl = "";
            }
            if (!countryUrl.isBlank() && !PaperConfigManager.isValidUrl((String)countryUrl)) {
                this.plugin.getLogger().warning("Invalid GeoLite2 Country URL; ignoring.");
                countryUrl = "";
            }
            geo = new GeoLite2Config(asnUrl, cityUrl, countryUrl, storage, Duration.ofDays(7L));
        }
        CustomProviderConfig custom = null;
        if (p == IpInfoProviderConfig.Provider.CUSTOM) {
            String apiUrl = this.cfg.getString("ip_info_provider.custom.url", "http://ip-api.com/json/%ip%");
            ConfigurationSection sec = this.cfg.getConfigurationSection("ip_info_provider.custom.headers");
            Map headers = sec == null ? Map.of() : sec.getKeys(false).stream().collect(Collectors.toMap(k -> k, k -> sec.getString(k, "")));
            ConfigurationSection parseSec = this.cfg.getConfigurationSection("ip_info_provider.custom.parse_fields");
            Map parseFields = parseSec == null ? Map.of() : parseSec.getKeys(false).stream().collect(Collectors.toMap(k -> k, k -> parseSec.getString(k, "")));
            custom = new CustomProviderConfig(apiUrl, headers, parseFields);
        }
        return new IpInfoProviderConfig(p, geo, custom);
    }

    public IpListConfig loadIpListConfig() {
        Path ipListsDir = this.plugin.getDataFolder().toPath().resolve("ipLists");
        if (!ipListsDir.toFile().exists() && !ipListsDir.toFile().mkdirs()) {
            this.plugin.getLogger().warning("Failed to create ipLists directory at " + String.valueOf(ipListsDir));
        }
        Set listNames = this.cfg.getStringList("ip_list.lists").stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        ConfigurationSection jobsSection = this.cfg.getConfigurationSection("ip_list.fetch_jobs");
        List<Object> jobs = List.of();
        if (jobsSection != null) {
            jobs = jobsSection.getKeys(false).stream().map(key -> {
                String url = this.cfg.getString("ip_list.fetch_jobs." + key + ".url", "").trim();
                String filename = this.cfg.getString("ip_list.fetch_jobs." + key + ".filename", "").trim();
                int intervalHours = Math.max(1, this.cfg.getInt("ip_list.fetch_jobs." + key + ".update_interval_hours", 24));
                if (url.isEmpty() || filename.isEmpty()) {
                    this.plugin.getLogger().warning("Invalid fetch job '" + key + "', missing url or filename");
                    return null;
                }
                return new IpListFetchJob(url, ipListsDir.resolve(filename), Duration.ofHours(intervalHours));
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new IpListConfig(ipListsDir, jobs, listNames);
    }

    public VpnBlockConfig loadVpnBlockConfig() {
        String raw;
        boolean enabled = this.cfg.getBoolean("vpn_block.enabled", false);
        String apiKey = this.cfg.getString("vpn_block.api_key", "").trim();
        VpnBlockConfig.Provider p = switch (raw = this.cfg.getString("vpn_block.provider", "vpnapi").trim().toLowerCase(Locale.ROOT)) {
            case "custom" -> VpnBlockConfig.Provider.CUSTOM;
            case "proxycheck" -> VpnBlockConfig.Provider.PROXYCHECK;
            default -> VpnBlockConfig.Provider.VPNAPI;
        };
        CustomProviderConfig custom = null;
        if (p == VpnBlockConfig.Provider.CUSTOM) {
            String apiUrl = this.cfg.getString("vpn_block.custom.url", "");
            if (apiUrl.isBlank() || !PaperConfigManager.isValidUrl((String)apiUrl)) {
                this.plugin.getLogger().warning("Invalid VPN Block custom URL; defaulting to VPNAPI.");
                p = VpnBlockConfig.Provider.VPNAPI;
            } else {
                ConfigurationSection sec = this.cfg.getConfigurationSection("vpn_block.custom.headers");
                Map headers = sec == null ? Map.of() : sec.getKeys(false).stream().collect(Collectors.toMap(k -> k, k -> sec.getString(k, "")));
                ConfigurationSection parseSec = this.cfg.getConfigurationSection("vpn_block.custom.parse_fields");
                Map parseFields = parseSec == null ? Map.of() : parseSec.getKeys(false).stream().collect(Collectors.toMap(k -> k, k -> parseSec.getString(k, "")));
                custom = new CustomProviderConfig(apiUrl, headers, parseFields);
            }
        }
        return new VpnBlockConfig(enabled, p, apiKey, custom);
    }
}

