/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.netwatchz.spigot.commands;

import com.zetaplugins.netwatchz.spigot.NetwatchZSpigot;
import com.zetaplugins.netwatchz.spigot.util.SpigotMessageService;
import com.zetaplugins.zetacore.debug.ReportDataCollector;
import com.zetaplugins.zetacore.debug.ReportFileWriter;
import com.zetaplugins.zetacore.debug.data.DebugReport;
import com.zetaplugins.zetacore.debug.uploader.ZetaDebugReportUploader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugCommand
implements CommandExecutor,
TabCompleter {
    private final NetwatchZSpigot plugin;
    private final File pluginFile;
    private final String permission = "netwatchz.debug";
    private final String modrinthId = "pVji8xJW";
    private final Map<String, String> configs;

    public DebugCommand(NetwatchZSpigot plugin) {
        this.plugin = plugin;
        this.pluginFile = plugin.getPluginFile();
        this.configs = Map.of("config.yml", plugin.getConfig().saveToString());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.throwUsageError(sender, this.plugin.getMessageService().getAndFormatMsg(false, "debug_usage", "&cUsage: /%command% <upload | generate>", new SpigotMessageService.Replaceable<String>("%command%", command.getName())));
            return true;
        }
        return switch (subCommand = args[0].toLowerCase()) {
            case "upload" -> {
                if (!sender.hasPermission("netwatchz.debug")) {
                    this.throwPermissionError(sender);
                    yield true;
                }
                yield this.handleUpload(sender, args.length > 1 && args[1].equalsIgnoreCase("confirm"), command.getName());
            }
            case "generate" -> {
                if (!sender.hasPermission("netwatchz.debug")) {
                    this.throwPermissionError(sender);
                    yield true;
                }
                yield this.handleGenerate(sender);
            }
            default -> {
                this.throwUsageError(sender, this.plugin.getMessageService().getAndFormatMsg(false, "debug_usage", "&cUsage: /%command% <upload | generate>", new SpigotMessageService.Replaceable<String>("%command%", command.getName())));
                yield true;
            }
        };
    }

    private void throwUsageError(@NotNull CommandSender sender, String usage) {
        sender.sendMessage(usage);
    }

    private void throwPermissionError(@NotNull CommandSender sender) {
        sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "debug_no_permission", "&cYou do not have permission to use this command!", new SpigotMessageService.Replaceable[0]));
    }

    private boolean handleUpload(CommandSender sender, boolean confirmed, String commandName) {
        if (!confirmed) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "debug_upload_confirm", "<br><#8b73f6>&lUploading Debug Report&r<br><br>&7 Are you sure you want to upload the debug report? By confirming, you accept our <u><click:OPEN_URL:https://debug.zetaplugins.com/privacy>Privacy Policy</click></u>.<br><br>&8 <#8b73f6><click:RUN_COMMAND:%command%>[Click Here]</click> &r&8or run <u>%command%</u><br>", new SpigotMessageService.Replaceable<CallSite>("%command%", (CallSite)((Object)("/" + commandName + " upload confirm")))));
            return true;
        }
        if (!sender.hasPermission("netwatchz.debug")) {
            this.throwPermissionError(sender);
            return true;
        }
        DebugReport report = ReportDataCollector.collect("pVji8xJW", this.plugin, this.pluginFile, this.configs);
        String url = ZetaDebugReportUploader.uploadReport(report, this.plugin);
        if (url == null) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "debug_upload_failed", "&cFailed to upload debug report: %error%", new SpigotMessageService.Replaceable<String>("%error%", "Failed to upload report.")));
            return false;
        }
        String formattedUrl = url.replaceAll("\\\\", "");
        sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "debug_upload_success", "&8 [&a\u2714&8] &7Debug report uploaded successfully! You can view it here:<br>&8 <u><#8b73f6><click:OPEN_URL:%url%>%url%</click></u><br>", new SpigotMessageService.Replaceable<String>("%url%", formattedUrl)));
        return true;
    }

    private boolean handleGenerate(CommandSender sender) {
        DebugReport report = ReportDataCollector.collect("pVji8xJW", this.plugin, this.pluginFile, this.configs);
        File reportJson = new File("debug-report.json");
        File reportTxt = new File("debug-report.txt");
        try {
            ReportFileWriter.writeJsonReportToFile(report, reportJson);
            ReportFileWriter.writeTextReportToFile(report, reportTxt);
        }
        catch (IOException e) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "debug_failed_to_create_file", "&cFailed to create debug report file: %error%", new SpigotMessageService.Replaceable<String>("%error%", e.getMessage())));
            this.plugin.getLogger().log(Level.SEVERE, "Failed to write debug report", e);
            return false;
        }
        sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "debug_file_create_success", "&8 [&a\u2714&8] &7Saved debug data to the following files:<br><click:COPY_TO_CLIPBOARD:%jsonPath%><#8b73f6>%jsonPath%</click><br><click:COPY_TO_CLIPBOARD:%txtPath%><#8b73f6>%txtPath%</click>", new SpigotMessageService.Replaceable<String>("%jsonPath%", reportJson.getAbsolutePath()), new SpigotMessageService.Replaceable<String>("%txtPath%", reportTxt.getAbsolutePath())));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return List.of("upload", "generate");
        }
        return null;
    }
}

