/*
 * Decompiled with CFR 0.152.
 */
package com.example.fabricmod.mixins;

import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1887.class})
public class EnchantmentNameMixin {
    @Inject(method={"getName"}, at={@At(value="RETURN")}, cancellable=true)
    private static void convertToRomanNumerals(class_6880<class_1887> enchantment, int level, CallbackInfoReturnable<class_2561> cir) {
        if (level > 0 && level <= 50) {
            String romanNumeral = EnchantmentNameMixin.toRomanNumeral(level);
            class_2561 originalText = (class_2561)cir.getReturnValue();
            String originalString = originalText.getString();
            String baseName = originalString.replaceAll(" enchantment\\.level\\.\\d+", "").replaceAll(" enchantment\\.level\\.blank", "").replaceAll(" \\d+$", "").replaceAll(" blank$", "").trim();
            class_5250 newText = class_2561.method_43470((String)(baseName + " " + romanNumeral));
            newText.method_10862(originalText.method_10866());
            cir.setReturnValue((Object)newText);
        }
    }

    private static String toRomanNumeral(int number) {
        if (number < 1 || number > 50) {
            return String.valueOf(number);
        }
        String[] tens = new String[]{"", "X", "XX", "XXX", "XL", "L"};
        String[] ones = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        if (number == 50) {
            return "L";
        }
        if (number >= 10) {
            return tens[number / 10] + ones[number % 10];
        }
        return ones[number];
    }
}

