/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11697;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7764;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import xfacthd.atlasviewer.AtlasViewer;
import xfacthd.atlasviewer.client.screen.AtlasInfoScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.MessageScreen;
import xfacthd.atlasviewer.client.screen.SpriteInfoScreen;
import xfacthd.atlasviewer.client.screen.widget.BackgroundSwitchButton;
import xfacthd.atlasviewer.client.screen.widget.DiscreteSliderButton;
import xfacthd.atlasviewer.client.screen.widget.IndicatorButton;
import xfacthd.atlasviewer.client.screen.widget.MenuContainer;
import xfacthd.atlasviewer.client.screen.widget.SelectionWidget;
import xfacthd.atlasviewer.client.screen.widget.search.SearchBox;
import xfacthd.atlasviewer.client.screen.widget.search.SearchHandler;
import xfacthd.atlasviewer.client.util.ClientUtils;
import xfacthd.atlasviewer.client.util.QuadTree;
import xfacthd.atlasviewer.client.util.Rect2i;
import xfacthd.atlasviewer.platform.Services;

public final class AtlasScreen
extends AtlasViewerScreen
implements SearchHandler {
    public static final class_2960 BACKGROUND_LOC = AtlasViewer.rl("background");
    private static final class_2561 TITLE = class_2561.method_43471((String)"title.atlasviewer.atlasviewer");
    private static final class_2561 TITLE_HIGHLIGHT_ANIM = class_2561.method_43471((String)"btn.atlasviewer.highlight_animated");
    private static final class_2561 TITLE_EXPORT = class_2561.method_43471((String)"btn.atlasviewer.export_atlas");
    private static final class_2561 TITLE_EXPORT_MIPPED = class_2561.method_43471((String)"btn.atlasviewer.export_mipped_atlas");
    private static final class_2561 TITLE_TOOLS = class_2561.method_43471((String)"btn.atlasviewer.menu");
    private static final class_2561 TITLE_DETAILS = class_2561.method_43471((String)"btn.atlasviewer.details");
    private static final class_2561 MSG_EXPORT_DETAILS = class_2561.method_43471((String)"msg.atlasviewer.export_atlas.detail");
    private static final class_2561 MSG_EXPORT_SUCCESS = class_2561.method_43471((String)"msg.atlasviewer.export_atlas_success");
    private static final class_2561 MSG_EXPORT_ERROR = class_2561.method_43471((String)"msg.atlasviewer.export_atlas_error");
    private static final class_2561 HOVER_MSG_CLICK_TO_OPEN = class_2561.method_43471((String)"hover.atlasviewer.path.click");
    private static final int PADDING = 5;
    private static final int HIGHLIGHT_ANIM_WIDTH = 160;
    private static final int HIGHLIGHT_ANIM_HEIGHT = 20;
    private static final int EXPORT_WIDTH = 100;
    private static final int EXPORT_HEIGHT = 20;
    private static final int SEARCH_BAR_WIDTH = 198;
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int SELECT_WIDTH = 300;
    private static final int SELECT_HEIGHT = 20;
    private static final int DETAILS_WIDTH = 100;
    private static final int DETAILS_HEIGHT = 20;
    private static final int MIP_LEVEL_WIDTH = 160;
    private static final int MIP_LEVEL_HEIGHT = 20;
    private static final int BG_SWITCHER_WIDTH = 180;
    private static final int TOOL_MENU_Y = 15;
    private static final Map<class_1059, Size> ATLAS_SIZES = new WeakHashMap<class_1059, Size>();
    private int atlasLeft;
    private int atlasTop;
    private int maxAtlasWidth;
    private int maxAtlasHeight;
    private @UnknownNullability MenuContainer menu;
    private @UnknownNullability IndicatorButton btnHighlightAnim;
    private @UnknownNullability class_4185 btnExport;
    private @UnknownNullability class_4185 btnExportMipped;
    private @UnknownNullability DiscreteSliderButton mipLevelSlider;
    private @UnknownNullability BackgroundSwitchButton bgSwitchButton;
    private @UnknownNullability SearchBox searchBar;
    private final Map<class_2960, class_11697.class_7772> atlases = new HashMap<class_2960, class_11697.class_7772>();
    @Nullable
    private class_11697.class_7772 currentAtlas;
    @Nullable
    private QuadTree<class_1058> spriteTree;
    @Nullable
    private Collection<class_1058> sprites;
    private Size atlasSize = new Size(0, 0);
    @Nullable
    private AtlasInfoScreen.AtlasInfo cachedInfo;
    private double atlasScale = 1.0;
    private double scrollScale = 1.0;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private final List<Rect2i> animatedLocations = new ArrayList<Rect2i>();
    private final List<Rect2i> searchResultLocations = new ArrayList<Rect2i>();
    @Nullable
    private class_1058 hoveredSprite = null;
    private int currentMipLevel = 0;
    private int focusedSearchResultIdx = -1;

    public AtlasScreen() {
        super(TITLE);
    }

    protected void method_25426() {
        this.atlasTop = 40;
        this.atlasLeft = 15;
        this.maxAtlasWidth = this.field_22789 - 30;
        this.maxAtlasHeight = this.field_22790 - this.atlasTop - 15;
        int titleLen = this.field_22793.method_27525((class_5348)TITLE);
        int selectWidth = Math.min(300, this.field_22789 - 40 - titleLen - 40);
        SelectionWidget<AtlasEntry> atlasSelection = new SelectionWidget<AtlasEntry>(this, this.field_22789 - 20 - selectWidth - 40, 15, selectWidth, (class_2561)class_2561.method_43473(), this::selectAtlas);
        this.method_37063((class_364)atlasSelection);
        class_4185 menuButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)TITLE_TOOLS, this::toggleMenu).method_46433(this.field_22789 - 15 - 40, 15).method_46437(40, 20).method_46431());
        this.menu = new MenuContainer(menuButton, true);
        this.btnHighlightAnim = (IndicatorButton)this.method_37063((class_364)new IndicatorButton(0, 0, 160, 20, TITLE_HIGHLIGHT_ANIM, this.btnHighlightAnim, this::highlightAnimated));
        this.menu.addMenuEntry((class_8021)this.btnHighlightAnim);
        this.btnExport = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)TITLE_EXPORT, this::exportAtlas).method_46433(0, 0).method_46437(100, 20).method_46431());
        this.menu.addMenuEntry((class_8021)this.btnExport);
        this.btnExportMipped = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)TITLE_EXPORT_MIPPED, this::exportAtlasMipped).method_46433(0, 0).method_46437(100, 20).method_46431());
        this.menu.addMenuEntry((class_8021)this.btnExportMipped);
        this.menu.addMenuEntry((class_8021)this.method_37063((class_364)class_4185.method_46430((class_2561)TITLE_DETAILS, this::openAtlasDetails).method_46433(0, 0).method_46437(100, 20).method_46431()));
        this.mipLevelSlider = (DiscreteSliderButton)this.method_37063((class_364)new DiscreteSliderButton(0, 0, 160, 20, "btn.atlasviewer.mip_level", this.mipLevelSlider != null ? this.mipLevelSlider.getStep() : 0, this.mipLevelSlider != null ? this.mipLevelSlider.getMaxStep() : 0, this::selectMipLevel));
        this.menu.addMenuEntry((class_8021)this.mipLevelSlider);
        this.bgSwitchButton = (BackgroundSwitchButton)this.method_37063((class_364)new BackgroundSwitchButton(0, 0, 180, this.bgSwitchButton != null ? this.bgSwitchButton.getSelectedType() : null));
        this.menu.addMenuEntry((class_8021)this.bgSwitchButton);
        this.searchBar = new SearchBox(0, 0, 198, 20, this.searchBar, this, x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.menu.addMenuEntry((class_8021)this.searchBar);
        this.menu.method_48222();
        this.atlases.clear();
        this.atlases.putAll(this.minecraft().method_72703().atlasviewer$getAtlasesByTexture());
        for (class_2960 loc : this.atlases.keySet()) {
            atlasSelection.addEntry(new AtlasEntry(loc));
        }
        class_2960 currLoc = this.currentAtlas != null && this.atlases.containsKey(this.currentAtlas.comp_4557().comp_4553()) ? this.currentAtlas.comp_4557().comp_4553() : class_1059.field_5275;
        AtlasEntry current = atlasSelection.stream().filter(entry -> entry.atlas.equals((Object)currLoc)).findFirst().orElseThrow();
        atlasSelection.setSelected(current, true);
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        boolean hasSearchResults;
        this.method_57734(graphics);
        graphics.method_52706(class_10799.field_56883, BACKGROUND_LOC, 5, 5, this.field_22789 - 10, this.field_22790 - 10);
        graphics.method_51439(this.field_22793, this.field_22785, 15, 15, -12566464, false);
        float scale = (float)(this.atlasScale * this.scrollScale);
        int bgWidth = (int)Math.min((float)this.maxAtlasWidth, (float)this.atlasSize.width * scale);
        int bgHeight = (int)Math.min((float)this.maxAtlasHeight, (float)this.atlasSize.height * scale);
        class_2960 bgSprite = this.bgSwitchButton.getSelectedType().getSprite();
        graphics.method_52706(class_10799.field_56883, bgSprite, this.atlasLeft, this.atlasTop, bgWidth, bgHeight);
        graphics.method_44379(this.atlasLeft, this.atlasTop, this.atlasLeft + this.maxAtlasWidth, this.atlasTop + this.maxAtlasHeight);
        Objects.requireNonNull(this.currentAtlas);
        GpuTextureView atlasTexView = this.currentAtlas.comp_1051().atlasview$getMippedTextureView(this.currentMipLevel);
        ClientUtils.blitSpecial(graphics, class_10799.field_56883, class_11231.method_70900((GpuTextureView)atlasTexView), (float)this.atlasLeft + this.offsetX, (float)this.atlasTop + this.offsetY, (float)this.atlasLeft + this.offsetX + (float)this.atlasSize.width * scale, (float)this.atlasTop + this.offsetY + (float)this.atlasSize.height * scale, 0.0f, 1.0f, 0.0f, 1.0f, -1);
        graphics.method_44380();
        graphics.method_44379(this.atlasLeft - 1, this.atlasTop - 1, this.atlasLeft + this.maxAtlasWidth + 1, this.atlasTop + this.maxAtlasHeight + 1);
        boolean cursorOnAtlas = this.isMouseOverAtlas(mouseX, mouseY);
        boolean highlightAnimated = this.btnHighlightAnim.isChecked();
        boolean bl = hasSearchResults = !this.searchResultLocations.isEmpty();
        if (highlightAnimated && !this.animatedLocations.isEmpty()) {
            for (Rect2i rect : this.animatedLocations) {
                this.drawColoredBox(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), scale, false, -16711936);
            }
        }
        if (hasSearchResults) {
            for (Rect2i rect : this.searchResultLocations) {
                boolean focused = System.currentTimeMillis() / 200L % 2L == 0L && this.focusedSearchResultIdx == this.searchResultLocations.indexOf(rect);
                this.drawColoredBox(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), scale, false, focused ? -3407617 : -17664);
            }
        }
        if (cursorOnAtlas) {
            class_1058 sprite;
            int mx = (int)((double)((float)(mouseX - this.atlasLeft) - this.offsetX) * (1.0 / this.atlasScale) / this.scrollScale);
            int my = (int)((double)((float)(mouseY - this.atlasTop) - this.offsetY) * (1.0 / this.atlasScale) / this.scrollScale);
            this.hoveredSprite = sprite = Objects.requireNonNull(this.spriteTree).find(mx, my);
            if (sprite != null) {
                class_7764 contents = sprite.method_45851();
                this.drawColoredBox(graphics, sprite.method_35806(), sprite.method_35807(), contents.method_45807(), contents.method_45815(), scale, true, -65536);
            }
        } else {
            this.hoveredSprite = null;
        }
        graphics.method_44380();
        this.menu.render(graphics);
        if (this.btnExport.method_49606()) {
            this.setTooltipForNextFrame(graphics, MSG_EXPORT_DETAILS, mouseX, mouseY);
        } else if (this.btnExportMipped.field_22763 && this.btnExportMipped.method_49606()) {
            this.setTooltipForNextFrame(graphics, (class_2561)class_2561.method_43469((String)"msg.atlasviewer.export_mipped_atlas.detail", (Object[])new Object[]{this.currentMipLevel}), mouseX, mouseY);
        }
    }

    private boolean isMouseOverAtlas(int mouseX, int mouseY) {
        if (mouseX < this.atlasLeft || mouseX > this.atlasLeft + this.maxAtlasWidth) {
            return false;
        }
        if (mouseY < this.atlasTop || mouseY > this.atlasTop + this.maxAtlasHeight) {
            return false;
        }
        return !this.menu.isOpen() || !this.menu.isMouseOver(mouseX, mouseY);
    }

    private void drawColoredBox(class_332 graphics, int x, int y, int width, int height, float scale, boolean expand, int color) {
        float sx = (float)x * scale + (float)this.atlasLeft + this.offsetX;
        float sy = (float)y * scale + (float)this.atlasTop + this.offsetY;
        float sw = (float)width * scale;
        float sh = (float)height * scale;
        float nsx = Math.max(sx, (float)this.atlasLeft);
        float nsy = Math.max(sy, (float)this.atlasTop);
        sw = Math.min(sw - (nsx - sx), Math.max((float)(this.atlasLeft + this.maxAtlasWidth) - nsx, 0.0f));
        sh = Math.min(sh - (nsy - sy), Math.max((float)(this.atlasTop + this.maxAtlasHeight) - nsy, 0.0f));
        sx = nsx;
        sy = nsy;
        if (expand) {
            sx -= 1.0f;
            sy -= 1.0f;
            sw += 2.0f;
            sh += 2.0f;
        }
        ClientUtils.drawColoredBox(graphics, sx, sy, sw, sh, color);
    }

    public void method_25393() {
        this.searchBar.tick();
    }

    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        if (super.method_25403(event, dragX, dragY)) {
            return true;
        }
        if (event.method_74245() == 0 && event.comp_4798() >= (double)this.atlasLeft && event.comp_4798() <= (double)(this.atlasLeft + this.maxAtlasWidth) && event.comp_4799() >= (double)this.atlasTop && event.comp_4799() <= (double)(this.atlasTop + this.maxAtlasHeight)) {
            class_1041 window = class_310.method_1551().method_22683();
            float scaleX = (float)window.method_4486() / (float)window.method_4480();
            float scaleY = (float)window.method_4502() / (float)window.method_4507();
            this.clampOffsetX(this.offsetX + (float)(dragX * (double)scaleX * (double)window.method_4495()));
            this.clampOffsetY(this.offsetY + (float)(dragY * (double)scaleY * (double)window.method_4495()));
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (super.method_25401(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        if (mouseX >= (double)this.atlasLeft && mouseX <= (double)(this.atlasLeft + this.maxAtlasWidth) && mouseY >= (double)this.atlasTop && mouseY <= (double)(this.atlasTop + this.maxAtlasHeight)) {
            double prevScale = this.scrollScale;
            this.scrollScale = Math.max(this.scrollScale + (double)((float)(deltaY * 0.1)), 1.0);
            double mOffX = mouseX - (double)this.atlasLeft;
            double mOffY = mouseY - (double)this.atlasTop;
            double offsetX = ((double)this.offsetX - mOffX) / prevScale * this.scrollScale + mOffX;
            double offsetY = ((double)this.offsetY - mOffY) / prevScale * this.scrollScale + mOffY;
            this.clampOffsetX((float)offsetX);
            this.clampOffsetY((float)offsetY);
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.menu.isOpen() && !this.menu.isMouseOver(event.comp_4798(), event.comp_4799())) {
            this.menu.setOpen(false);
        }
        if (!super.method_25402(event, doubleClick)) {
            this.method_25395(null);
            return false;
        }
        return true;
    }

    public boolean method_25406(class_11909 event) {
        if (super.method_25406(event)) {
            return true;
        }
        if (!(this.hoveredSprite == null || event.method_74245() != 1 || this.menu.isOpen() && this.menu.isMouseOver(event.comp_4798(), event.comp_4799()))) {
            Services.PLATFORM.pushScreenLayer(new SpriteInfoScreen(Objects.requireNonNull(this.currentAtlas), this.hoveredSprite, this.currentMipLevel, this.bgSwitchButton.getSelectedType()));
            return true;
        }
        return false;
    }

    private void selectAtlas(AtlasEntry entry) {
        this.currentAtlas = this.atlases.get(entry.atlas);
        this.atlasSize = ATLAS_SIZES.get(this.currentAtlas.comp_1051());
        this.atlasScale = (float)this.maxAtlasWidth / (float)this.atlasSize.width;
        if ((double)this.atlasSize.height * this.atlasScale > (double)this.maxAtlasHeight) {
            this.atlasScale = (float)this.maxAtlasHeight / (float)this.atlasSize.height;
        }
        this.sprites = Objects.requireNonNull(this.currentAtlas).comp_1051().atlasviewer$getTexturesByName().values();
        int minSize = this.sprites.stream().map(class_1058::method_45851).mapToInt(c -> Math.max(c.method_45807(), c.method_45815())).min().orElseThrow();
        this.spriteTree = new QuadTree(this.atlasSize.width, this.atlasSize.height, minSize);
        this.sprites.forEach(s -> this.spriteTree.insert((class_1058)s, AtlasScreen::getSpriteSize));
        this.spriteTree.trim();
        Rect2i minRect = this.spriteTree.minSize();
        AtlasViewer.LOGGER.debug("QuadTree for atlas '{}' has a depth of {}. Smallest sub-tree sized {}x{}, requested {}x{}", new Object[]{this.currentAtlas.comp_4557().comp_4553(), this.spriteTree.depth(), minRect.getWidth(), minRect.getHeight(), minSize, minSize});
        int mipLevels = this.currentAtlas.comp_1051().atlasviewer$getMipLevel();
        this.mipLevelSlider.setStep(0, true);
        this.mipLevelSlider.setMaxStep(mipLevels);
        this.mipLevelSlider.field_22763 = mipLevels > 0;
        this.btnExportMipped.field_22763 = false;
        this.scrollScale = 1.0;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.searchBar.clear();
        this.searchResultLocations.clear();
        this.focusedSearchResultIdx = -1;
        this.cachedInfo = null;
        if (this.btnHighlightAnim.isChecked()) {
            this.gatherAnimatedLocations();
        }
    }

    private void highlightAnimated(class_4185 btn) {
        if (this.btnHighlightAnim.isChecked()) {
            this.gatherAnimatedLocations();
        }
    }

    private void gatherAnimatedLocations() {
        this.animatedLocations.clear();
        Objects.requireNonNull(this.sprites).stream().filter(sprite -> sprite.method_45851().atlasviewer$getAnimatedTexture() != null).forEach(sprite -> this.animatedLocations.add(AtlasScreen.getSpriteSize(sprite)));
    }

    private void exportAtlas(class_4185 btn) {
        this.exportAtlas(0);
    }

    private void exportAtlasMipped(class_4185 btn) {
        this.exportAtlas(this.currentMipLevel);
    }

    private void exportAtlas(int mipLevel) {
        ClientUtils.downloadTexture(Objects.requireNonNull(this.currentAtlas).comp_1051().method_68004(), mipLevel, image -> {
            try {
                Path imgPath = AtlasScreen.exportNativeImage(image, this.currentAtlas.comp_4557().comp_4553(), "atlas", mipLevel, true, MSG_EXPORT_SUCCESS);
                if (mipLevel == 0) {
                    Map sprites = this.currentAtlas.comp_1051().atlasviewer$getTexturesByName();
                    class_1059.method_45849((Path)imgPath.getParent(), (String)imgPath.getFileName().toString(), (Map)sprites);
                }
            }
            catch (IOException e) {
                AtlasViewer.LOGGER.error("Encountered an error while exporting selected texture atlas", (Throwable)e);
                Services.PLATFORM.pushScreenLayer(MessageScreen.error(List.of(MSG_EXPORT_ERROR, class_2561.method_43470((String)e.toString()).method_27692(class_124.field_1079))));
            }
        });
    }

    private void clampOffsetX(float offsetX) {
        this.offsetX = this.clampOffset(this.atlasSize.width, this.maxAtlasWidth, offsetX);
    }

    private void clampOffsetY(float offsetY) {
        this.offsetY = this.clampOffset(this.atlasSize.height, this.maxAtlasHeight, offsetY);
    }

    private float clampOffset(float atlasDim, float viewDim, float offset) {
        float minOffset = atlasDim * (float)(this.atlasScale * this.scrollScale) - viewDim;
        minOffset = Math.max(minOffset, 0.0f);
        return class_3532.method_15363((float)offset, (float)(-minOffset), (float)0.0f);
    }

    private void toggleMenu(class_4185 btn) {
        this.menu.toggleOpen();
    }

    private void openAtlasDetails(class_4185 btn) {
        if (this.cachedInfo == null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.cachedInfo = AtlasInfoScreen.computeInfo(Objects.requireNonNull(this.currentAtlas), Objects.requireNonNull(this.sprites));
            stopwatch.stop();
            AtlasViewer.LOGGER.debug("Took {} to compute atlas info for atlas '{}'", (Object)stopwatch, (Object)this.currentAtlas.comp_4557().comp_4553());
        }
        Services.PLATFORM.pushScreenLayer(new AtlasInfoScreen(this.cachedInfo));
    }

    private void selectMipLevel(int level) {
        this.currentMipLevel = level;
        this.btnExportMipped.field_22763 = level > 0;
    }

    @Override
    public int getResultCount() {
        return this.searchResultLocations.size();
    }

    @Override
    public void updateSearch(String text) {
        this.searchResultLocations.clear();
        this.focusedSearchResultIdx = -1;
        if (!text.isEmpty()) {
            Objects.requireNonNull(this.sprites).forEach(sprite -> {
                if (sprite.method_45851().method_45816().toString().contains(text)) {
                    this.searchResultLocations.add(AtlasScreen.getSpriteSize(sprite));
                }
            });
            this.searchResultLocations.sort(Comparator.comparingInt(Rect2i::getY).thenComparing(Rect2i::getX));
        }
    }

    @Override
    public void jumpToNextResult() {
        if (!this.searchResultLocations.isEmpty()) {
            this.focusedSearchResultIdx = (this.focusedSearchResultIdx + 1) % this.searchResultLocations.size();
            Rect2i result = this.searchResultLocations.get(this.focusedSearchResultIdx);
            this.scrollScale = Math.max(1.0 / this.atlasScale, 1.0);
            double cx = (float)result.getX() + (float)result.getWidth() / 2.0f;
            double cy = (float)result.getY() + (float)result.getHeight() / 2.0f;
            double scale = this.atlasScale * this.scrollScale;
            this.clampOffsetX((float)(-((cx - (double)this.maxAtlasWidth / scale) * scale + (double)((float)this.maxAtlasWidth / 2.0f))));
            this.clampOffsetY((float)(-((cy - (double)this.maxAtlasHeight / scale) * scale + (double)((float)this.maxAtlasHeight / 2.0f))));
        }
    }

    @Override
    public int getFocusedResultIndex() {
        return this.focusedSearchResultIdx;
    }

    private static Rect2i getSpriteSize(class_1058 sprite) {
        class_7764 contents = sprite.method_45851();
        return new Rect2i(sprite.method_35806(), sprite.method_35807(), contents.method_45807(), contents.method_45815());
    }

    public static void storeAtlasSize(class_1059 atlas, int width, int height) {
        ATLAS_SIZES.put(atlas, new Size(width, height));
    }

    public static Path exportNativeImage(class_1011 image, class_2960 name, String prefix, int mipLevel, boolean shortenPath, class_2561 msgSuccess) throws IOException {
        Path filePath;
        int idx;
        Path folderPath = Services.PLATFORM.getGameDir().resolve("atlasviewer");
        Files.createDirectories(folderPath, new FileAttribute[0]);
        String texPath = name.method_12832();
        texPath = shortenPath ? texPath.substring((idx = texPath.lastIndexOf(47)) == -1 ? 0 : idx + 1) : texPath.replace('/', '-');
        Object fileName = prefix + "_" + name.method_12836() + "_" + texPath;
        if (((String)fileName).endsWith(".png")) {
            fileName = ((String)fileName).substring(0, ((String)fileName).length() - 4);
        }
        if (mipLevel > 0) {
            fileName = (String)fileName + "_" + mipLevel;
        }
        if (Files.notExists(filePath = folderPath.resolve((String)(fileName = (String)fileName + ".png")), LinkOption.NOFOLLOW_LINKS)) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        image.method_4314(filePath);
        Services.PLATFORM.pushScreenLayer(MessageScreen.info(List.of(msgSuccess, AtlasScreen.buildPathComponent(filePath))));
        return filePath;
    }

    private static class_2561 buildPathComponent(Path path) {
        path = path.getParent().toAbsolutePath().normalize();
        return class_2561.method_43470((String)path.toString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1063).method_10949((class_2568)new class_2568.class_10613(HOVER_MSG_CLICK_TO_OPEN)).method_10958((class_2558)new class_2558.class_10607(path.toString())));
    }

    public record Size(int width, int height) {
    }

    private static class AtlasEntry
    extends SelectionWidget.SelectionEntry<AtlasEntry> {
        private final class_2960 atlas;

        public AtlasEntry(class_2960 atlas) {
            super((class_2561)class_2561.method_43470((String)atlas.toString()));
            this.atlas = atlas;
        }
    }
}

