/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.client.screen.AtlasScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.stacking.IStackedScreen;
import xfacthd.atlasviewer.client.util.ClientUtils;
import xfacthd.atlasviewer.platform.Services;

public final class MessageScreen
extends AtlasViewerScreen
implements IStackedScreen {
    private static final class_2561 INFO_TITLE = class_2561.method_43471((String)"atlasviewer.message.info.title");
    private static final class_2561 ERROR_TITLE = class_2561.method_43471((String)"atlasviewer.message.error.title");
    private static final class_2561 TITLE_BTN_OK = class_2561.method_43471((String)"atlasviewer.message.btn.ok");
    private static final int WIDTH = 176;
    private static final int BASE_HEIGHT = 64;
    private static final int TEXT_WIDTH = 164;
    private static final int TITLE_X = 8;
    private static final int TITLE_Y = 6;
    private final List<class_2561> messages;
    private final List<List<class_5481>> textBlocks = new ArrayList<List<class_5481>>();
    private int leftPos;
    private int topPos;
    private int imageHeight;

    public static MessageScreen info(List<class_2561> message) {
        return new MessageScreen(INFO_TITLE, message);
    }

    public static MessageScreen error(List<class_2561> message) {
        return new MessageScreen(ERROR_TITLE, message);
    }

    public MessageScreen(class_2561 title, List<class_2561> messages) {
        super(title);
        this.messages = messages;
    }

    protected void method_25426() {
        this.textBlocks.clear();
        this.imageHeight = 64;
        for (class_2561 msg : this.messages) {
            this.imageHeight += ClientUtils.getWrappedHeight(this.field_22793, (class_5348)msg, 164);
            Objects.requireNonNull(this.field_22793);
            this.imageHeight += 9;
            this.textBlocks.add(this.field_22793.method_1728((class_5348)msg, 164));
        }
        Objects.requireNonNull(this.field_22793);
        this.imageHeight -= 9;
        this.leftPos = (this.field_22789 - 176) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)TITLE_BTN_OK, btn -> this.method_25419()).method_46433(this.leftPos + 88 - 30, this.topPos + this.imageHeight - 30).method_46437(60, 20).method_46431());
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_57734(graphics);
        graphics.method_52706(class_10799.field_56883, AtlasScreen.BACKGROUND_LOC, this.leftPos, this.topPos, 176, this.imageHeight);
        graphics.method_51439(this.field_22793, this.field_22785, this.leftPos + 8, this.topPos + 6, -12566464, false);
        Objects.requireNonNull(this.field_22793);
        int y = this.topPos + 6 + 9 * 2;
        for (List<class_5481> block : this.textBlocks) {
            for (class_5481 line : block) {
                graphics.method_51430(this.field_22793, line, this.leftPos + 8, y, -16777216, false);
                Objects.requireNonNull(this.field_22793);
                y += 9;
            }
            Objects.requireNonNull(this.field_22793);
            y += 9;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        class_2583 style = this.findTextLine(mouseX, mouseY);
        if (style != null) {
            graphics.method_51441(this.field_22793, style, mouseX, mouseY);
        }
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        class_2583 style = this.findTextLine((int)event.comp_4798(), (int)event.comp_4799());
        if (style != null && this.method_25430(style)) {
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    @Nullable
    private class_2583 findTextLine(int mouseX, int mouseY) {
        int localX = mouseX - this.leftPos - 8;
        if (localX < 0) {
            return null;
        }
        Objects.requireNonNull(this.field_22793);
        int y = this.topPos + 6 + 9 * 2;
        for (List<class_5481> block : this.textBlocks) {
            int n = block.size();
            Objects.requireNonNull(this.field_22793);
            int height = n * 9;
            if (mouseY >= y && mouseY <= y + height) {
                Objects.requireNonNull(this.field_22793);
                int idx = (mouseY - y) / 9;
                if (idx >= block.size()) {
                    return null;
                }
                return this.field_22793.method_27527().method_30876(block.get(idx), localX);
            }
            Objects.requireNonNull(this.field_22793);
            y += height + 9;
        }
        return null;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        Services.PLATFORM.popScreenLayer();
    }
}

