/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import xfacthd.atlasviewer.client.screen.AtlasInfoScreen;
import xfacthd.atlasviewer.client.util.ClientUtils;

public final class AtlasLoadTable
extends class_339 {
    private static final class_2960 ARROW_UP = class_2960.method_60656((String)"transferable_list/move_up");
    private static final class_2960 ARROW_DOWN = class_2960.method_60656((String)"transferable_list/move_down");
    private static final float ARROW_SCALE = 0.5f;
    private static final float ARROW_UP_OFF_X = 9.0f;
    private static final float ARROW_UP_OFF_Y = 2.5f;
    private static final float ARROW_DOWN_OFF_X = 9.0f;
    private static final float ARROW_DOWN_OFF_Y = 10.0f;
    private static final class_2561 HEADER_NAMESPACE = class_2561.method_43471((String)"header.atlasviewer.atlasload.namespace");
    private static final class_2561 HEADER_COUNT = class_2561.method_43471((String)"header.atlasviewer.atlasload.count");
    private static final class_2561 HEADER_OF_TOTAL = class_2561.method_43471((String)"header.atlasviewer.atlasload.of_total");
    private static final class_2561 HEADER_OF_FILLED = class_2561.method_43471((String)"header.atlasviewer.atlasload.of_filled");
    private static final class_2561[] HEADERS = new class_2561[]{HEADER_NAMESPACE, HEADER_COUNT, HEADER_OF_TOTAL, HEADER_OF_FILLED};
    private static final Comparator<AtlasInfoScreen.FillStat> DEFAULT_STAT_COMPARATOR = Comparator.comparing(AtlasInfoScreen.FillStat::namespace);
    public static final int TABLE_HEIGHT = 56;
    private static final int SCROLL_BAR_WIDTH = 4;
    private static final int SORT_ARROW_WIDTH = 8;
    private final AtlasInfoScreen.AtlasInfo atlasInfo;
    private final int nsCount;
    private final int contentWidth;
    private final int[] colWidth = new int[4];
    private final int[] colTextX = new int[4];
    private final int[] colArrowX = new int[4];
    private final boolean scrollBar;
    private final int entryHeight;
    private final int scrollBarX;
    private final int scrollBarHeight;
    private final float scrollFactor;
    private final class_327 font;
    private int scrollOffset;
    private SortTarget sorting;
    private boolean reverse;

    public AtlasLoadTable(int x, int y, int width, AtlasInfoScreen.AtlasInfo atlasInfo) {
        super(x, y, width, 56, (class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        this.scrollOffset = 0;
        this.sorting = SortTarget.NAMESPACE;
        this.reverse = false;
        this.atlasInfo = atlasInfo;
        this.nsCount = atlasInfo.fillStats().size();
        this.scrollBar = atlasInfo.fillStats().size() > 4;
        this.contentWidth = width - 2 - (this.scrollBar ? 5 : 0);
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 + 2;
        this.scrollBarX = this.scrollBar ? x + width - 1 - 4 : 0;
        this.scrollBarHeight = this.scrollBar ? (int)Math.max((float)(this.field_22759 - 1 - this.entryHeight) * (4.0f / (float)this.nsCount), 3.0f) : 0;
        this.scrollFactor = this.scrollBar ? (float)(this.entryHeight * 4 - this.scrollBarHeight - 1) / (float)(this.nsCount - 4) : 0.0f;
        this.colWidth[1] = this.font.method_27525((class_5348)HEADER_COUNT) + 8 + 3;
        this.colWidth[2] = this.font.method_27525((class_5348)HEADER_OF_TOTAL) + 8 + 3;
        this.colWidth[3] = this.font.method_27525((class_5348)HEADER_OF_FILLED) + 8 + 3;
        this.colWidth[0] = this.contentWidth - (this.colWidth[1] + this.colWidth[2] + this.colWidth[3]) - 3;
        int tx = x + 3;
        for (int i = 0; i < 4; ++i) {
            this.colTextX[i] = tx;
            this.colArrowX[i] = tx + this.font.method_27525((class_5348)HEADERS[i]) + 1;
            tx += this.colWidth[i] + 1;
        }
        this.sorting.sort(atlasInfo.fillStats(), false);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        ClientUtils.drawColoredBox(graphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, -16777216);
        int x = this.method_46426() + 1;
        int y = this.method_46427() + 1;
        for (int i = 0; i < 4; ++i) {
            int w = this.colWidth[i];
            int color = i % 2 == 0 ? -7697782 : -6250336;
            graphics.method_25294(x, y, x + w, y + this.field_22759 - 2, color);
            if (i != 3) {
                graphics.method_51742(x + w, this.method_46427(), this.method_46427() + this.field_22759 - 1, -16777216);
            }
            x += w + 1;
        }
        x = this.method_46426() + 1;
        Objects.requireNonNull(this.font);
        graphics.method_51738(x, x + this.field_22758 - 2, ++y + 9, -16777216);
        graphics.method_51439(this.font, HEADER_NAMESPACE, this.colTextX[0], y, -13619152, false);
        graphics.method_51439(this.font, HEADER_COUNT, this.colTextX[1], y, -13619152, false);
        graphics.method_51439(this.font, HEADER_OF_TOTAL, this.colTextX[2], y, -13619152, false);
        graphics.method_51439(this.font, HEADER_OF_FILLED, this.colTextX[3], y, -13619152, false);
        x = this.method_46426() + 3;
        y += this.entryHeight;
        int maxIdx = class_3532.method_15340((int)(this.nsCount - this.scrollOffset), (int)0, (int)4);
        for (int i = 0; i < maxIdx; ++i) {
            int idx = i + this.scrollOffset;
            int tx = this.colTextX[0];
            AtlasInfoScreen.FillStat stat = this.atlasInfo.fillStats().get(idx);
            graphics.method_51433(this.font, stat.namespace(), tx, y, -13619152, false);
            String count = Integer.toString(stat.count());
            tx = this.colTextX[1];
            int tw = this.font.method_1727(count);
            graphics.method_51433(this.font, count, tx + this.colWidth[1] - tw - 3, y, -13619152, false);
            String percentOfTotal = "%.1f %%".formatted(Float.valueOf(stat.percentOfTotal() * 100.0f));
            tx = this.colTextX[2];
            tw = this.font.method_1727(percentOfTotal);
            graphics.method_51433(this.font, percentOfTotal, tx + this.colWidth[2] - tw - 3, y, -13619152, false);
            String percentOfFilled = "%.1f %%".formatted(Float.valueOf(stat.percentOfFilled() * 100.0f));
            tx = this.colTextX[3];
            tw = this.font.method_1727(percentOfFilled);
            graphics.method_51433(this.font, percentOfFilled, tx + this.colWidth[3] - tw - 3, y, -13619152, false);
            Objects.requireNonNull(this.font);
            graphics.method_51738(x - 3, x + this.contentWidth - 2, y + 9, -16777216);
            y += this.entryHeight;
        }
        if (this.scrollBar) {
            graphics.method_51742(this.method_46426() + 1 + this.contentWidth, this.method_46427(), this.method_46427() + this.field_22759 - 1, -16777216);
            int by = this.method_46427() + 1 + this.entryHeight + Math.round(this.scrollFactor * (float)this.scrollOffset);
            by = Math.min(by, this.method_46427() + this.field_22759 - this.scrollBarHeight - 1);
            graphics.method_25294(this.scrollBarX, by, this.scrollBarX + 4, by + this.scrollBarHeight, -10066330);
            graphics.method_25294(this.scrollBarX + 1, by + 1, this.scrollBarX + 4 - 1, by + this.scrollBarHeight - 1, -5592406);
        }
        class_2960 tex = this.reverse ? ARROW_UP : ARROW_DOWN;
        float xOff = this.reverse ? 9.0f : 9.0f;
        float yOff = this.reverse ? 2.5f : 10.0f;
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate((float)this.colArrowX[this.sorting.ordinal()] - xOff, (float)(this.method_46427() + 4) - yOff);
        graphics.method_51448().scale(0.5f, 0.5f);
        graphics.method_52706(class_10799.field_56883, tex, 0, 0, 32, 32);
        graphics.method_51448().popMatrix();
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0 && event.comp_4799() >= (double)(this.method_46427() + 1)) {
            double d = event.comp_4799();
            int n = this.method_46427();
            Objects.requireNonNull(this.font);
            if (d <= (double)(n + 9 + 2)) {
                SortTarget newTarget = null;
                int x = this.method_46426() + 1;
                for (int i = 0; i < 4; ++i) {
                    int w = this.colWidth[i];
                    if (event.comp_4798() >= (double)x && event.comp_4798() <= (double)(x + w)) {
                        newTarget = SortTarget.VALUES[i];
                        break;
                    }
                    x += w + 1;
                }
                if (newTarget != null) {
                    if (newTarget == this.sorting) {
                        this.reverse = !this.reverse;
                    } else {
                        this.sorting = newTarget;
                        this.reverse = false;
                    }
                    this.sorting.sort(this.atlasInfo.fillStats(), this.reverse);
                    return true;
                }
            }
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.scrollBar && mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.field_22759)) {
            if (deltaY < 0.0 && this.scrollOffset < this.atlasInfo.fillStats().size() - 4) {
                ++this.scrollOffset;
            } else if (deltaY > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 out) {
    }

    private static enum SortTarget {
        NAMESPACE(DEFAULT_STAT_COMPARATOR),
        COUNT(Comparator.comparingInt(AtlasInfoScreen.FillStat::count)),
        PERCENT_OF_TOTAL(Comparator.comparingDouble(AtlasInfoScreen.FillStat::percentOfTotal)),
        PERCENT_OF_FILLED(Comparator.comparingDouble(AtlasInfoScreen.FillStat::percentOfFilled));

        private static final SortTarget[] VALUES;
        private final Comparator<AtlasInfoScreen.FillStat> statComparator;
        private final Comparator<AtlasInfoScreen.FillStat> statComparatorReverse;

        private SortTarget(Comparator<AtlasInfoScreen.FillStat> statComparator) {
            if (statComparator != DEFAULT_STAT_COMPARATOR) {
                statComparator = statComparator.thenComparing(DEFAULT_STAT_COMPARATOR);
            }
            this.statComparator = statComparator;
            this.statComparatorReverse = statComparator.reversed();
        }

        public void sort(List<AtlasInfoScreen.FillStat> stats, boolean reverse) {
            stats.sort(reverse ? this.statComparatorReverse : this.statComparator);
        }

        static {
            VALUES = SortTarget.values();
        }
    }
}

