/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.client.util.Rect2i;

public final class QuadTree<T>
extends Rect2i {
    private static final int MAX_DEPTH = 12;
    @Nullable
    private final @Nullable QuadTree<T> @Nullable [] children;
    @Nullable
    private List<Entry<T>> entries = null;

    public QuadTree(int width, int height, int minSize) {
        this(0, 0, width, height, minSize, 0);
    }

    private QuadTree(int x, int y, int width, int height, int minSize, int depth) {
        super(x, y, width, height);
        if (++depth < 12 && width > minSize && width % 2 == 0) {
            this.children = new QuadTree[4];
            int childWidth = width / 2;
            int childHeight = height / 2;
            if (width == height / 2) {
                this.children[0] = new QuadTree<T>(x, y, width, childHeight, minSize, depth);
                this.children[1] = null;
                this.children[2] = null;
                this.children[3] = new QuadTree<T>(x, y + childHeight, width, childHeight, minSize, depth);
            } else if (height == width / 2) {
                this.children[0] = new QuadTree<T>(x, y, childWidth, height, minSize, depth);
                this.children[1] = new QuadTree<T>(x + childWidth, y, childWidth, height, minSize, depth);
                this.children[2] = null;
                this.children[3] = null;
            } else {
                this.children[0] = new QuadTree<T>(x, y, childWidth, childHeight, minSize, depth);
                this.children[1] = new QuadTree<T>(x + childWidth, y, childWidth, childHeight, minSize, depth);
                this.children[2] = new QuadTree<T>(x + childWidth, y + childHeight, childWidth, childHeight, minSize, depth);
                this.children[3] = new QuadTree<T>(x, y + childHeight, childWidth, childHeight, minSize, depth);
            }
        } else {
            this.children = null;
        }
    }

    public void insert(T item, Function<T, Rect2i> sizeFactory) {
        this.insert(item, sizeFactory.apply(item));
    }

    private void insert(T item, Rect2i size) {
        if (this.children != null) {
            for (int i = 0; i < 4; ++i) {
                QuadTree<T> child = this.children[i];
                if (child == null || !child.contains(size)) continue;
                child.insert(item, size);
                return;
            }
        }
        if (this.entries == null) {
            this.entries = new ArrayList<Entry<T>>();
        }
        this.entries.add(new Entry<T>(item, size));
    }

    public void trim() {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                QuadTree<T> child = this.children[i];
                if (child == null) continue;
                child.trim();
                if (!child.isEmpty()) continue;
                this.children[i] = null;
            }
        }
    }

    @Nullable
    public T find(int x, int y) {
        if (this.entries != null) {
            for (Entry<T> e : this.entries) {
                if (!e.contains(x, y)) continue;
                return e.item;
            }
        }
        if (this.children != null) {
            for (int i = 0; i < 4; ++i) {
                T item;
                QuadTree<T> child = this.children[i];
                if (child == null || !child.contains(x, y) || (item = child.find(x, y)) == null) continue;
                return item;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        if (this.children != null) {
            for (QuadTree<T> child : this.children) {
                if (child == null) continue;
                return false;
            }
        }
        return this.entries == null;
    }

    public int depth() {
        if (this.children != null) {
            int d = 0;
            for (QuadTree<T> child : this.children) {
                if (child == null) continue;
                d = Math.max(child.depth(), d);
            }
            return d + 1;
        }
        return 1;
    }

    public Rect2i minSize() {
        if (this.children != null) {
            Rect2i minRect = this;
            for (QuadTree<T> child : this.children) {
                if (child == null) continue;
                Rect2i childRect = child.minSize();
                if (childRect.width >= this.width && childRect.height >= this.height) continue;
                minRect = childRect;
            }
            return minRect;
        }
        return this;
    }

    private static final class Entry<T>
    extends Rect2i {
        private final T item;

        private Entry(T item, Rect2i size) {
            super(size.x, size.y, size.width, size.height);
            this.item = item;
        }
    }
}

