/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.AtlasViewer;
import xfacthd.atlasviewer.client.screen.AtlasScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.stacking.IStackedScreen;
import xfacthd.atlasviewer.client.screen.widget.AtlasLoadTable;
import xfacthd.atlasviewer.client.screen.widget.CloseButton;
import xfacthd.atlasviewer.platform.Services;

public final class AtlasInfoScreen
extends AtlasViewerScreen
implements IStackedScreen {
    private static final Component TITLE = Component.translatable((String)"title.atlasviewer.atlasinfo");
    private static final Component MSG_HW_DEPEND = Component.translatable((String)"msg.atlasviewer.atlas_hw_dependent");
    private static final Component MSG_SPRITES_BY_MAX_MIP = Component.translatable((String)"msg.atlasviewer.atlas_sprites_by_max_mip");
    private static final Component CHAR_ARROW = Component.literal((String)"\u21b3").withStyle(s -> s.withFont((FontDescription)new FontDescription.Resource(AtlasViewer.rl("arrow"))));
    private static final Component LABEL_NAME = Component.translatable((String)"label.atlasviewer.atlas_name");
    private static final Component LABEL_SIZE = Component.translatable((String)"label.atlasviewer.atlas_size");
    private static final Component LABEL_MAX_SIZE = Component.translatable((String)"label.atlasviewer.atlas_max_size", (Object[])new Object[]{Component.literal((String)"\u26a0").withStyle(s -> s.withColor(0xFF7700))});
    private static final Component LABEL_MIP_LEVELS = Component.translatable((String)"label.atlasviewer.atlas_mip_levels");
    private static final Component LABEL_SPRITES = Component.translatable((String)"label.atlasviewer.atlas_sprite_count");
    private static final Component LABEL_SPRITES_BY_MAX_MIP = Component.translatable((String)"label.atlasviewer.atlas_sprite_count_by_max_mip", (Object[])new Object[]{CHAR_ARROW, Component.literal((String)"i").withStyle(ChatFormatting.BLUE)});
    private static final Component LABEL_PERCENT_FILLED = Component.translatable((String)"label.atlasviewer.atlas_percent_filled");
    private static final Label[] LABELS = new Label[]{new Label(LABEL_NAME), new Label(LABEL_SIZE), new Label(LABEL_MAX_SIZE), new Label(LABEL_MIP_LEVELS, screen -> screen.atlasInfo.mipped), new Label(LABEL_SPRITES), new Label(LABEL_SPRITES_BY_MAX_MIP, screen -> screen.atlasInfo.mipped), new Label(LABEL_PERCENT_FILLED)};
    private static final int WIDTH = 400;
    private static final int PADDING = 5;
    private static final int LINE_HEIGHT = 12;
    private static final int TITLE_Y = 10;
    private static final int TEXT_X = 10;
    private static final int FIRST_LINE_Y = 30;
    private static final int TABLE_WIDTH = 380;
    private static final int CLOSE_SIZE = 12;
    private final AtlasInfo atlasInfo;
    private final Component atlasSizeText;
    private final Component atlasMaxSizeText;
    private final Component atlasMipLevelText;
    private final Component spriteCountText;
    @Nullable
    private final Component countsByMip;
    private final Component percentFilledText;
    private final Component tableHeader;
    private int imageHeight;
    private int xLeft;
    private int yTop;
    private int valueX;
    private int tableTitleY;

    public AtlasInfoScreen(AtlasInfo atlasInfo) {
        super(TITLE);
        this.atlasInfo = atlasInfo;
        this.atlasSizeText = Component.translatable((String)"value.atlasviewer.size", (Object[])new Object[]{atlasInfo.width, atlasInfo.height});
        this.atlasMaxSizeText = Component.translatable((String)"value.atlasviewer.size", (Object[])new Object[]{atlasInfo.maxSize, atlasInfo.maxSize});
        this.atlasMipLevelText = Component.literal((String)Integer.toString(atlasInfo.mipLevels));
        this.spriteCountText = Component.literal((String)Integer.toString(atlasInfo.spriteCount));
        this.countsByMip = atlasInfo.mipped ? Component.translatable((String)"value.atlasviewer.atlas_sprites_by_max_mip", (Object[])Arrays.stream(atlasInfo.spriteCountByMaxMipLevel).mapToObj(String::valueOf).map(v -> Component.literal((String)v).withStyle(Style.EMPTY.withColor(0x666666))).toArray()) : null;
        this.percentFilledText = Component.literal((String)"%.1f %%".formatted(Float.valueOf(atlasInfo.percentFilled * 100.0f)));
        int nsCount = atlasInfo.fillStats.size();
        this.tableHeader = nsCount == 1 ? Component.translatable((String)"label.atlasviewer.atlas_percent_filled_by_ns_single", (Object[])new Object[]{CHAR_ARROW}) : Component.translatable((String)"label.atlasviewer.atlas_percent_filled_by_ns", (Object[])new Object[]{CHAR_ARROW, nsCount});
    }

    protected void init() {
        int labelLen = 0;
        int labelHeight = 0;
        for (Label label : LABELS) {
            if (!label.active.test(this)) continue;
            labelLen = Math.max(labelLen, this.font.width((FormattedText)label.text));
            labelHeight += 12;
        }
        this.valueX = 10 + labelLen + 5;
        this.imageHeight = 30 + labelHeight + 12 + 56 + 10;
        this.xLeft = this.width / 2 - 200;
        this.yTop = this.height / 2 - this.imageHeight / 2;
        this.tableTitleY = this.yTop + 30 + labelHeight;
        this.addRenderableWidget((GuiEventListener)new AtlasLoadTable(this.xLeft + 10, this.tableTitleY + 12, 380, this.atlasInfo));
        this.addRenderableWidget((GuiEventListener)new CloseButton(this.xLeft + 400 - 5 - 12, this.yTop + 5, this));
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBlurredBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, AtlasScreen.BACKGROUND_LOC, this.xLeft, this.yTop, 400, this.imageHeight);
        graphics.drawString(this.font, this.title, this.xLeft + 10, this.yTop + 10, -12566464, false);
        int y = this.yTop + 30;
        y = this.drawLine(graphics, LABEL_NAME, (Component)Component.literal((String)this.atlasInfo.name), y);
        y = this.drawLine(graphics, LABEL_SIZE, this.atlasSizeText, y);
        y = this.drawLine(graphics, LABEL_MAX_SIZE, this.atlasMaxSizeText, y);
        if (this.atlasInfo.mipped) {
            y = this.drawLine(graphics, LABEL_MIP_LEVELS, this.atlasMipLevelText, y);
        }
        y = this.drawLine(graphics, LABEL_SPRITES, this.spriteCountText, y);
        if (this.atlasInfo.mipped) {
            y = this.drawLine(graphics, LABEL_SPRITES_BY_MAX_MIP, Objects.requireNonNull(this.countsByMip), y);
        }
        y = this.drawLine(graphics, LABEL_PERCENT_FILLED, this.percentFilledText, y);
        graphics.drawString(this.font, this.tableHeader, this.xLeft + 10, this.tableTitleY, -12566464, false);
        int len = this.font.width((FormattedText)LABEL_MAX_SIZE);
        int minY = this.yTop + 30 + 24;
        if (mouseX >= this.xLeft + 10 && mouseX < this.xLeft + 10 + len && mouseY >= minY) {
            Objects.requireNonNull(this.font);
            if (mouseY <= minY + 9) {
                this.setTooltipForNextFrame(graphics, MSG_HW_DEPEND, mouseX, mouseY);
            }
        }
        if (this.atlasInfo.mipped) {
            len = this.font.width((FormattedText)LABEL_SPRITES_BY_MAX_MIP);
            minY = this.yTop + 30 + 60;
            if (mouseX >= this.xLeft + 10 && mouseX < this.xLeft + 10 + len && mouseY >= minY) {
                Objects.requireNonNull(this.font);
                if (mouseY <= minY + 9) {
                    this.setTooltipForNextFrame(graphics, MSG_SPRITES_BY_MAX_MIP, mouseX, mouseY);
                }
            }
        }
    }

    private int drawLine(GuiGraphics graphics, Component label, Component value, int y) {
        graphics.drawString(this.font, label, this.xLeft + 10, y, -12566464, false);
        graphics.drawString(this.font, value, this.xLeft + this.valueX, y, -12566464, false);
        return y + 12;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (event.button() == 0 && (event.x() < (double)this.xLeft || event.y() < (double)this.yTop || event.x() > (double)(this.xLeft + 400) || event.y() > (double)(this.yTop + this.imageHeight))) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public void onClose() {
        Services.PLATFORM.popScreenLayer();
    }

    public static AtlasInfo computeInfo(AtlasManager.AtlasEntry atlasEntry, Collection<TextureAtlasSprite> sprites) {
        Map<String, Integer> areaByNamespace = sprites.stream().map(TextureAtlasSprite::contents).map(c -> ObjectIntPair.of((Object)c.name().getNamespace(), (int)(c.width() * c.height()))).collect(Collectors.groupingBy(Pair::first, Collectors.summingInt(ObjectIntPair::rightInt)));
        Object2IntLinkedOpenHashMap countByNamespace = new Object2IntLinkedOpenHashMap();
        sprites.stream().map(TextureAtlasSprite::contents).map(SpriteContents::name).map(ResourceLocation::getNamespace).forEach(arg_0 -> AtlasInfoScreen.lambda$computeInfo$7((Object2IntMap)countByNamespace, arg_0));
        int[] spritesByMaxMip = new int[5];
        sprites.forEach(sprite -> {
            int maxLevel;
            SpriteContents contents = sprite.contents();
            int lowestOne = Math.min(Integer.lowestOneBit(contents.width()), Integer.lowestOneBit(contents.height()));
            int n = maxLevel = Math.min(Mth.log2((int)lowestOne), 4);
            spritesByMaxMip[n] = spritesByMaxMip[n] + 1;
        });
        TextureAtlas atlas = atlasEntry.atlas();
        int width = atlas.getWidth();
        int height = atlas.getHeight();
        int area = width * height;
        int areaFilled = areaByNamespace.values().stream().mapToInt(Integer::intValue).sum();
        float filled = (float)areaFilled / (float)area;
        ArrayList<FillStat> fillStats = new ArrayList<FillStat>();
        areaByNamespace.forEach((arg_0, arg_1) -> AtlasInfoScreen.lambda$computeInfo$9(area, areaFilled, fillStats, (Object2IntMap)countByNamespace, arg_0, arg_1));
        return new AtlasInfo(atlasEntry.config().textureId().toString(), atlasEntry.config().createMipmaps(), atlas.maxSupportedTextureSize(), width, height, atlas.atlasviewer$getMipLevel(), sprites.size(), spritesByMaxMip, filled, fillStats);
    }

    private static /* synthetic */ void lambda$computeInfo$9(int area, int areaFilled, List fillStats, Object2IntMap countByNamespace, String namespace, Integer value) {
        float namespaceArea = value.intValue();
        float percentOfTotal = namespaceArea / (float)area;
        float percentOfFilled = namespaceArea / (float)areaFilled;
        fillStats.add(new FillStat(namespace, countByNamespace.getInt((Object)namespace), percentOfTotal, percentOfFilled));
    }

    private static /* synthetic */ void lambda$computeInfo$7(Object2IntMap countByNamespace, String s) {
        countByNamespace.computeInt((Object)s, (ns, count) -> (count != null ? count : 0) + 1);
    }

    public record AtlasInfo(String name, boolean mipped, int maxSize, int width, int height, int mipLevels, int spriteCount, int[] spriteCountByMaxMipLevel, float percentFilled, List<FillStat> fillStats) {
    }

    private record Label(Component text, Predicate<AtlasInfoScreen> active) {
        public Label(Component text) {
            this(text, screen -> true);
        }
    }

    public record FillStat(String namespace, int count, float percentOfTotal, float percentOfFilled) {
    }
}

