/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import xfacthd.atlasviewer.AtlasViewer;
import xfacthd.atlasviewer.client.screen.AtlasInfoScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.MessageScreen;
import xfacthd.atlasviewer.client.screen.SpriteInfoScreen;
import xfacthd.atlasviewer.client.screen.widget.BackgroundSwitchButton;
import xfacthd.atlasviewer.client.screen.widget.DiscreteSliderButton;
import xfacthd.atlasviewer.client.screen.widget.IndicatorButton;
import xfacthd.atlasviewer.client.screen.widget.MenuContainer;
import xfacthd.atlasviewer.client.screen.widget.SelectionWidget;
import xfacthd.atlasviewer.client.screen.widget.search.SearchBox;
import xfacthd.atlasviewer.client.screen.widget.search.SearchHandler;
import xfacthd.atlasviewer.client.util.ClientUtils;
import xfacthd.atlasviewer.client.util.QuadTree;
import xfacthd.atlasviewer.client.util.Rect2i;
import xfacthd.atlasviewer.platform.Services;

public final class AtlasScreen
extends AtlasViewerScreen
implements SearchHandler {
    public static final ResourceLocation BACKGROUND_LOC = AtlasViewer.rl("background");
    private static final Component TITLE = Component.translatable((String)"title.atlasviewer.atlasviewer");
    private static final Component TITLE_HIGHLIGHT_ANIM = Component.translatable((String)"btn.atlasviewer.highlight_animated");
    private static final Component TITLE_EXPORT = Component.translatable((String)"btn.atlasviewer.export_atlas");
    private static final Component TITLE_EXPORT_MIPPED = Component.translatable((String)"btn.atlasviewer.export_mipped_atlas");
    private static final Component TITLE_TOOLS = Component.translatable((String)"btn.atlasviewer.menu");
    private static final Component TITLE_DETAILS = Component.translatable((String)"btn.atlasviewer.details");
    private static final Component MSG_EXPORT_DETAILS = Component.translatable((String)"msg.atlasviewer.export_atlas.detail");
    private static final Component MSG_EXPORT_SUCCESS = Component.translatable((String)"msg.atlasviewer.export_atlas_success");
    private static final Component MSG_EXPORT_ERROR = Component.translatable((String)"msg.atlasviewer.export_atlas_error");
    private static final Component HOVER_MSG_CLICK_TO_OPEN = Component.translatable((String)"hover.atlasviewer.path.click");
    private static final int PADDING = 5;
    private static final int HIGHLIGHT_ANIM_WIDTH = 160;
    private static final int HIGHLIGHT_ANIM_HEIGHT = 20;
    private static final int EXPORT_WIDTH = 100;
    private static final int EXPORT_HEIGHT = 20;
    private static final int SEARCH_BAR_WIDTH = 198;
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int SELECT_WIDTH = 300;
    private static final int SELECT_HEIGHT = 20;
    private static final int DETAILS_WIDTH = 100;
    private static final int DETAILS_HEIGHT = 20;
    private static final int MIP_LEVEL_WIDTH = 160;
    private static final int MIP_LEVEL_HEIGHT = 20;
    private static final int BG_SWITCHER_WIDTH = 180;
    private static final int TOOL_MENU_Y = 15;
    private static final Map<TextureAtlas, Size> ATLAS_SIZES = new WeakHashMap<TextureAtlas, Size>();
    private int atlasLeft;
    private int atlasTop;
    private int maxAtlasWidth;
    private int maxAtlasHeight;
    private @UnknownNullability MenuContainer menu;
    private @UnknownNullability IndicatorButton btnHighlightAnim;
    private @UnknownNullability Button btnExport;
    private @UnknownNullability Button btnExportMipped;
    private @UnknownNullability DiscreteSliderButton mipLevelSlider;
    private @UnknownNullability BackgroundSwitchButton bgSwitchButton;
    private @UnknownNullability SearchBox searchBar;
    private final Map<ResourceLocation, AtlasManager.AtlasEntry> atlases = new HashMap<ResourceLocation, AtlasManager.AtlasEntry>();
    @Nullable
    private AtlasManager.AtlasEntry currentAtlas;
    @Nullable
    private QuadTree<TextureAtlasSprite> spriteTree;
    @Nullable
    private Collection<TextureAtlasSprite> sprites;
    private Size atlasSize = new Size(0, 0);
    @Nullable
    private AtlasInfoScreen.AtlasInfo cachedInfo;
    private double atlasScale = 1.0;
    private double scrollScale = 1.0;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private final List<Rect2i> animatedLocations = new ArrayList<Rect2i>();
    private final List<Rect2i> searchResultLocations = new ArrayList<Rect2i>();
    @Nullable
    private TextureAtlasSprite hoveredSprite = null;
    private int currentMipLevel = 0;
    private int focusedSearchResultIdx = -1;

    public AtlasScreen() {
        super(TITLE);
    }

    protected void init() {
        this.atlasTop = 40;
        this.atlasLeft = 15;
        this.maxAtlasWidth = this.width - 30;
        this.maxAtlasHeight = this.height - this.atlasTop - 15;
        int titleLen = this.font.width((FormattedText)TITLE);
        int selectWidth = Math.min(300, this.width - 40 - titleLen - 40);
        SelectionWidget<AtlasEntry> atlasSelection = new SelectionWidget<AtlasEntry>(this, this.width - 20 - selectWidth - 40, 15, selectWidth, (Component)Component.empty(), this::selectAtlas);
        this.addRenderableWidget((GuiEventListener)atlasSelection);
        Button menuButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)TITLE_TOOLS, this::toggleMenu).pos(this.width - 15 - 40, 15).size(40, 20).build());
        this.menu = new MenuContainer(menuButton, true);
        this.btnHighlightAnim = (IndicatorButton)this.addRenderableWidget((GuiEventListener)new IndicatorButton(0, 0, 160, 20, TITLE_HIGHLIGHT_ANIM, this.btnHighlightAnim, this::highlightAnimated));
        this.menu.addMenuEntry((LayoutElement)this.btnHighlightAnim);
        this.btnExport = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)TITLE_EXPORT, this::exportAtlas).pos(0, 0).size(100, 20).build());
        this.menu.addMenuEntry((LayoutElement)this.btnExport);
        this.btnExportMipped = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)TITLE_EXPORT_MIPPED, this::exportAtlasMipped).pos(0, 0).size(100, 20).build());
        this.menu.addMenuEntry((LayoutElement)this.btnExportMipped);
        this.menu.addMenuEntry((LayoutElement)this.addRenderableWidget((GuiEventListener)Button.builder((Component)TITLE_DETAILS, this::openAtlasDetails).pos(0, 0).size(100, 20).build()));
        this.mipLevelSlider = (DiscreteSliderButton)this.addRenderableWidget((GuiEventListener)new DiscreteSliderButton(0, 0, 160, 20, "btn.atlasviewer.mip_level", this.mipLevelSlider != null ? this.mipLevelSlider.getStep() : 0, this.mipLevelSlider != null ? this.mipLevelSlider.getMaxStep() : 0, this::selectMipLevel));
        this.menu.addMenuEntry((LayoutElement)this.mipLevelSlider);
        this.bgSwitchButton = (BackgroundSwitchButton)this.addRenderableWidget((GuiEventListener)new BackgroundSwitchButton(0, 0, 180, this.bgSwitchButton != null ? this.bgSwitchButton.getSelectedType() : null));
        this.menu.addMenuEntry((LayoutElement)this.bgSwitchButton);
        this.searchBar = new SearchBox(0, 0, 198, 20, this.searchBar, this, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.menu.addMenuEntry((LayoutElement)this.searchBar);
        this.menu.arrangeElements();
        this.atlases.clear();
        this.atlases.putAll(this.minecraft().getAtlasManager().atlasviewer$getAtlasesByTexture());
        for (ResourceLocation loc : this.atlases.keySet()) {
            atlasSelection.addEntry(new AtlasEntry(loc));
        }
        ResourceLocation currLoc = this.currentAtlas != null && this.atlases.containsKey(this.currentAtlas.config().textureId()) ? this.currentAtlas.config().textureId() : TextureAtlas.LOCATION_BLOCKS;
        AtlasEntry current = atlasSelection.stream().filter(entry -> entry.atlas.equals((Object)currLoc)).findFirst().orElseThrow();
        atlasSelection.setSelected(current, true);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean hasSearchResults;
        this.renderBlurredBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_LOC, 5, 5, this.width - 10, this.height - 10);
        graphics.drawString(this.font, this.title, 15, 15, -12566464, false);
        float scale = (float)(this.atlasScale * this.scrollScale);
        int bgWidth = (int)Math.min((float)this.maxAtlasWidth, (float)this.atlasSize.width * scale);
        int bgHeight = (int)Math.min((float)this.maxAtlasHeight, (float)this.atlasSize.height * scale);
        ResourceLocation bgSprite = this.bgSwitchButton.getSelectedType().getSprite();
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, bgSprite, this.atlasLeft, this.atlasTop, bgWidth, bgHeight);
        graphics.enableScissor(this.atlasLeft, this.atlasTop, this.atlasLeft + this.maxAtlasWidth, this.atlasTop + this.maxAtlasHeight);
        Objects.requireNonNull(this.currentAtlas);
        GpuTextureView atlasTexView = this.currentAtlas.atlas().atlasview$getMippedTextureView(this.currentMipLevel);
        ClientUtils.blitSpecial(graphics, RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)atlasTexView), (float)this.atlasLeft + this.offsetX, (float)this.atlasTop + this.offsetY, (float)this.atlasLeft + this.offsetX + (float)this.atlasSize.width * scale, (float)this.atlasTop + this.offsetY + (float)this.atlasSize.height * scale, 0.0f, 1.0f, 0.0f, 1.0f, -1);
        graphics.disableScissor();
        graphics.enableScissor(this.atlasLeft - 1, this.atlasTop - 1, this.atlasLeft + this.maxAtlasWidth + 1, this.atlasTop + this.maxAtlasHeight + 1);
        boolean cursorOnAtlas = this.isMouseOverAtlas(mouseX, mouseY);
        boolean highlightAnimated = this.btnHighlightAnim.isChecked();
        boolean bl = hasSearchResults = !this.searchResultLocations.isEmpty();
        if (highlightAnimated && !this.animatedLocations.isEmpty()) {
            for (Rect2i rect : this.animatedLocations) {
                this.drawColoredBox(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), scale, false, -16711936);
            }
        }
        if (hasSearchResults) {
            for (Rect2i rect : this.searchResultLocations) {
                boolean focused = System.currentTimeMillis() / 200L % 2L == 0L && this.focusedSearchResultIdx == this.searchResultLocations.indexOf(rect);
                this.drawColoredBox(graphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), scale, false, focused ? -3407617 : -17664);
            }
        }
        if (cursorOnAtlas) {
            TextureAtlasSprite sprite;
            int mx = (int)((double)((float)(mouseX - this.atlasLeft) - this.offsetX) * (1.0 / this.atlasScale) / this.scrollScale);
            int my = (int)((double)((float)(mouseY - this.atlasTop) - this.offsetY) * (1.0 / this.atlasScale) / this.scrollScale);
            this.hoveredSprite = sprite = Objects.requireNonNull(this.spriteTree).find(mx, my);
            if (sprite != null) {
                SpriteContents contents = sprite.contents();
                this.drawColoredBox(graphics, sprite.getX(), sprite.getY(), contents.width(), contents.height(), scale, true, -65536);
            }
        } else {
            this.hoveredSprite = null;
        }
        graphics.disableScissor();
        this.menu.render(graphics);
        if (this.btnExport.isHovered()) {
            this.setTooltipForNextFrame(graphics, MSG_EXPORT_DETAILS, mouseX, mouseY);
        } else if (this.btnExportMipped.active && this.btnExportMipped.isHovered()) {
            this.setTooltipForNextFrame(graphics, (Component)Component.translatable((String)"msg.atlasviewer.export_mipped_atlas.detail", (Object[])new Object[]{this.currentMipLevel}), mouseX, mouseY);
        }
    }

    private boolean isMouseOverAtlas(int mouseX, int mouseY) {
        if (mouseX < this.atlasLeft || mouseX > this.atlasLeft + this.maxAtlasWidth) {
            return false;
        }
        if (mouseY < this.atlasTop || mouseY > this.atlasTop + this.maxAtlasHeight) {
            return false;
        }
        return !this.menu.isOpen() || !this.menu.isMouseOver(mouseX, mouseY);
    }

    private void drawColoredBox(GuiGraphics graphics, int x, int y, int width, int height, float scale, boolean expand, int color) {
        float sx = (float)x * scale + (float)this.atlasLeft + this.offsetX;
        float sy = (float)y * scale + (float)this.atlasTop + this.offsetY;
        float sw = (float)width * scale;
        float sh = (float)height * scale;
        float nsx = Math.max(sx, (float)this.atlasLeft);
        float nsy = Math.max(sy, (float)this.atlasTop);
        sw = Math.min(sw - (nsx - sx), Math.max((float)(this.atlasLeft + this.maxAtlasWidth) - nsx, 0.0f));
        sh = Math.min(sh - (nsy - sy), Math.max((float)(this.atlasTop + this.maxAtlasHeight) - nsy, 0.0f));
        sx = nsx;
        sy = nsy;
        if (expand) {
            sx -= 1.0f;
            sy -= 1.0f;
            sw += 2.0f;
            sh += 2.0f;
        }
        ClientUtils.drawColoredBox(graphics, sx, sy, sw, sh, color);
    }

    public void tick() {
        this.searchBar.tick();
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        if (super.mouseDragged(event, dragX, dragY)) {
            return true;
        }
        if (event.button() == 0 && event.x() >= (double)this.atlasLeft && event.x() <= (double)(this.atlasLeft + this.maxAtlasWidth) && event.y() >= (double)this.atlasTop && event.y() <= (double)(this.atlasTop + this.maxAtlasHeight)) {
            Window window = Minecraft.getInstance().getWindow();
            float scaleX = (float)window.getGuiScaledWidth() / (float)window.getScreenWidth();
            float scaleY = (float)window.getGuiScaledHeight() / (float)window.getScreenHeight();
            this.clampOffsetX(this.offsetX + (float)(dragX * (double)scaleX * (double)window.getGuiScale()));
            this.clampOffsetY(this.offsetY + (float)(dragY * (double)scaleY * (double)window.getGuiScale()));
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (super.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        if (mouseX >= (double)this.atlasLeft && mouseX <= (double)(this.atlasLeft + this.maxAtlasWidth) && mouseY >= (double)this.atlasTop && mouseY <= (double)(this.atlasTop + this.maxAtlasHeight)) {
            double prevScale = this.scrollScale;
            this.scrollScale = Math.max(this.scrollScale + (double)((float)(deltaY * 0.1)), 1.0);
            double mOffX = mouseX - (double)this.atlasLeft;
            double mOffY = mouseY - (double)this.atlasTop;
            double offsetX = ((double)this.offsetX - mOffX) / prevScale * this.scrollScale + mOffX;
            double offsetY = ((double)this.offsetY - mOffY) / prevScale * this.scrollScale + mOffY;
            this.clampOffsetX((float)offsetX);
            this.clampOffsetY((float)offsetY);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.menu.isOpen() && !this.menu.isMouseOver(event.x(), event.y())) {
            this.menu.setOpen(false);
        }
        if (!super.mouseClicked(event, doubleClick)) {
            this.setFocused(null);
            return false;
        }
        return true;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (super.mouseReleased(event)) {
            return true;
        }
        if (!(this.hoveredSprite == null || event.button() != 1 || this.menu.isOpen() && this.menu.isMouseOver(event.x(), event.y()))) {
            Services.PLATFORM.pushScreenLayer(new SpriteInfoScreen(Objects.requireNonNull(this.currentAtlas), this.hoveredSprite, this.currentMipLevel, this.bgSwitchButton.getSelectedType()));
            return true;
        }
        return false;
    }

    private void selectAtlas(AtlasEntry entry) {
        this.currentAtlas = this.atlases.get(entry.atlas);
        this.atlasSize = ATLAS_SIZES.get(this.currentAtlas.atlas());
        this.atlasScale = (float)this.maxAtlasWidth / (float)this.atlasSize.width;
        if ((double)this.atlasSize.height * this.atlasScale > (double)this.maxAtlasHeight) {
            this.atlasScale = (float)this.maxAtlasHeight / (float)this.atlasSize.height;
        }
        this.sprites = Objects.requireNonNull(this.currentAtlas).atlas().atlasviewer$getTexturesByName().values();
        int minSize = this.sprites.stream().map(TextureAtlasSprite::contents).mapToInt(c -> Math.max(c.width(), c.height())).min().orElseThrow();
        this.spriteTree = new QuadTree(this.atlasSize.width, this.atlasSize.height, minSize);
        this.sprites.forEach(s -> this.spriteTree.insert((TextureAtlasSprite)s, AtlasScreen::getSpriteSize));
        this.spriteTree.trim();
        Rect2i minRect = this.spriteTree.minSize();
        AtlasViewer.LOGGER.debug("QuadTree for atlas '{}' has a depth of {}. Smallest sub-tree sized {}x{}, requested {}x{}", new Object[]{this.currentAtlas.config().textureId(), this.spriteTree.depth(), minRect.getWidth(), minRect.getHeight(), minSize, minSize});
        int mipLevels = this.currentAtlas.atlas().atlasviewer$getMipLevel();
        this.mipLevelSlider.setStep(0, true);
        this.mipLevelSlider.setMaxStep(mipLevels);
        this.mipLevelSlider.active = mipLevels > 0;
        this.btnExportMipped.active = false;
        this.scrollScale = 1.0;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.searchBar.clear();
        this.searchResultLocations.clear();
        this.focusedSearchResultIdx = -1;
        this.cachedInfo = null;
        if (this.btnHighlightAnim.isChecked()) {
            this.gatherAnimatedLocations();
        }
    }

    private void highlightAnimated(Button btn) {
        if (this.btnHighlightAnim.isChecked()) {
            this.gatherAnimatedLocations();
        }
    }

    private void gatherAnimatedLocations() {
        this.animatedLocations.clear();
        Objects.requireNonNull(this.sprites).stream().filter(sprite -> sprite.contents().atlasviewer$getAnimatedTexture() != null).forEach(sprite -> this.animatedLocations.add(AtlasScreen.getSpriteSize(sprite)));
    }

    private void exportAtlas(Button btn) {
        this.exportAtlas(0);
    }

    private void exportAtlasMipped(Button btn) {
        this.exportAtlas(this.currentMipLevel);
    }

    private void exportAtlas(int mipLevel) {
        ClientUtils.downloadTexture(Objects.requireNonNull(this.currentAtlas).atlas().getTexture(), mipLevel, image -> {
            try {
                Path imgPath = AtlasScreen.exportNativeImage(image, this.currentAtlas.config().textureId(), "atlas", mipLevel, true, MSG_EXPORT_SUCCESS);
                if (mipLevel == 0) {
                    Map sprites = this.currentAtlas.atlas().atlasviewer$getTexturesByName();
                    TextureAtlas.dumpSpriteNames((Path)imgPath.getParent(), (String)imgPath.getFileName().toString(), (Map)sprites);
                }
            }
            catch (IOException e) {
                AtlasViewer.LOGGER.error("Encountered an error while exporting selected texture atlas", (Throwable)e);
                Services.PLATFORM.pushScreenLayer(MessageScreen.error(List.of(MSG_EXPORT_ERROR, Component.literal((String)e.toString()).withStyle(ChatFormatting.DARK_RED))));
            }
        });
    }

    private void clampOffsetX(float offsetX) {
        this.offsetX = this.clampOffset(this.atlasSize.width, this.maxAtlasWidth, offsetX);
    }

    private void clampOffsetY(float offsetY) {
        this.offsetY = this.clampOffset(this.atlasSize.height, this.maxAtlasHeight, offsetY);
    }

    private float clampOffset(float atlasDim, float viewDim, float offset) {
        float minOffset = atlasDim * (float)(this.atlasScale * this.scrollScale) - viewDim;
        minOffset = Math.max(minOffset, 0.0f);
        return Mth.clamp((float)offset, (float)(-minOffset), (float)0.0f);
    }

    private void toggleMenu(Button btn) {
        this.menu.toggleOpen();
    }

    private void openAtlasDetails(Button btn) {
        if (this.cachedInfo == null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.cachedInfo = AtlasInfoScreen.computeInfo(Objects.requireNonNull(this.currentAtlas), Objects.requireNonNull(this.sprites));
            stopwatch.stop();
            AtlasViewer.LOGGER.debug("Took {} to compute atlas info for atlas '{}'", (Object)stopwatch, (Object)this.currentAtlas.config().textureId());
        }
        Services.PLATFORM.pushScreenLayer(new AtlasInfoScreen(this.cachedInfo));
    }

    private void selectMipLevel(int level) {
        this.currentMipLevel = level;
        this.btnExportMipped.active = level > 0;
    }

    @Override
    public int getResultCount() {
        return this.searchResultLocations.size();
    }

    @Override
    public void updateSearch(String text) {
        this.searchResultLocations.clear();
        this.focusedSearchResultIdx = -1;
        if (!text.isEmpty()) {
            Objects.requireNonNull(this.sprites).forEach(sprite -> {
                if (sprite.contents().name().toString().contains(text)) {
                    this.searchResultLocations.add(AtlasScreen.getSpriteSize(sprite));
                }
            });
            this.searchResultLocations.sort(Comparator.comparingInt(Rect2i::getY).thenComparing(Rect2i::getX));
        }
    }

    @Override
    public void jumpToNextResult() {
        if (!this.searchResultLocations.isEmpty()) {
            this.focusedSearchResultIdx = (this.focusedSearchResultIdx + 1) % this.searchResultLocations.size();
            Rect2i result = this.searchResultLocations.get(this.focusedSearchResultIdx);
            this.scrollScale = Math.max(1.0 / this.atlasScale, 1.0);
            double cx = (float)result.getX() + (float)result.getWidth() / 2.0f;
            double cy = (float)result.getY() + (float)result.getHeight() / 2.0f;
            double scale = this.atlasScale * this.scrollScale;
            this.clampOffsetX((float)(-((cx - (double)this.maxAtlasWidth / scale) * scale + (double)((float)this.maxAtlasWidth / 2.0f))));
            this.clampOffsetY((float)(-((cy - (double)this.maxAtlasHeight / scale) * scale + (double)((float)this.maxAtlasHeight / 2.0f))));
        }
    }

    @Override
    public int getFocusedResultIndex() {
        return this.focusedSearchResultIdx;
    }

    private static Rect2i getSpriteSize(TextureAtlasSprite sprite) {
        SpriteContents contents = sprite.contents();
        return new Rect2i(sprite.getX(), sprite.getY(), contents.width(), contents.height());
    }

    public static void storeAtlasSize(TextureAtlas atlas, int width, int height) {
        ATLAS_SIZES.put(atlas, new Size(width, height));
    }

    public static Path exportNativeImage(NativeImage image, ResourceLocation name, String prefix, int mipLevel, boolean shortenPath, Component msgSuccess) throws IOException {
        Path filePath;
        int idx;
        Path folderPath = Services.PLATFORM.getGameDir().resolve("atlasviewer");
        Files.createDirectories(folderPath, new FileAttribute[0]);
        String texPath = name.getPath();
        texPath = shortenPath ? texPath.substring((idx = texPath.lastIndexOf(47)) == -1 ? 0 : idx + 1) : texPath.replace('/', '-');
        Object fileName = prefix + "_" + name.getNamespace() + "_" + texPath;
        if (((String)fileName).endsWith(".png")) {
            fileName = ((String)fileName).substring(0, ((String)fileName).length() - 4);
        }
        if (mipLevel > 0) {
            fileName = (String)fileName + "_" + mipLevel;
        }
        if (Files.notExists(filePath = folderPath.resolve((String)(fileName = (String)fileName + ".png")), LinkOption.NOFOLLOW_LINKS)) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        image.writeToFile(filePath);
        Services.PLATFORM.pushScreenLayer(MessageScreen.info(List.of(msgSuccess, AtlasScreen.buildPathComponent(filePath))));
        return filePath;
    }

    private static Component buildPathComponent(Path path) {
        path = path.getParent().toAbsolutePath().normalize();
        return Component.literal((String)path.toString()).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withHoverEvent((HoverEvent)new HoverEvent.ShowText(HOVER_MSG_CLICK_TO_OPEN)).withClickEvent((ClickEvent)new ClickEvent.OpenFile(path.toString())));
    }

    public record Size(int width, int height) {
    }

    private static class AtlasEntry
    extends SelectionWidget.SelectionEntry<AtlasEntry> {
        private final ResourceLocation atlas;

        public AtlasEntry(ResourceLocation atlas) {
            super((Component)Component.literal((String)atlas.toString()));
            this.atlas = atlas;
        }
    }
}

