/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.client.screen.AtlasScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.stacking.IStackedScreen;
import xfacthd.atlasviewer.client.util.ClientUtils;
import xfacthd.atlasviewer.platform.Services;

public final class MessageScreen
extends AtlasViewerScreen
implements IStackedScreen {
    private static final Component INFO_TITLE = Component.translatable((String)"atlasviewer.message.info.title");
    private static final Component ERROR_TITLE = Component.translatable((String)"atlasviewer.message.error.title");
    private static final Component TITLE_BTN_OK = Component.translatable((String)"atlasviewer.message.btn.ok");
    private static final int WIDTH = 176;
    private static final int BASE_HEIGHT = 64;
    private static final int TEXT_WIDTH = 164;
    private static final int TITLE_X = 8;
    private static final int TITLE_Y = 6;
    private final List<Component> messages;
    private final List<List<FormattedCharSequence>> textBlocks = new ArrayList<List<FormattedCharSequence>>();
    private int leftPos;
    private int topPos;
    private int imageHeight;

    public static MessageScreen info(List<Component> message) {
        return new MessageScreen(INFO_TITLE, message);
    }

    public static MessageScreen error(List<Component> message) {
        return new MessageScreen(ERROR_TITLE, message);
    }

    public MessageScreen(Component title, List<Component> messages) {
        super(title);
        this.messages = messages;
    }

    protected void init() {
        this.textBlocks.clear();
        this.imageHeight = 64;
        for (Component msg : this.messages) {
            this.imageHeight += ClientUtils.getWrappedHeight(this.font, (FormattedText)msg, 164);
            Objects.requireNonNull(this.font);
            this.imageHeight += 9;
            this.textBlocks.add(this.font.split((FormattedText)msg, 164));
        }
        Objects.requireNonNull(this.font);
        this.imageHeight -= 9;
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TITLE_BTN_OK, btn -> this.onClose()).pos(this.leftPos + 88 - 30, this.topPos + this.imageHeight - 30).size(60, 20).build());
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBlurredBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, AtlasScreen.BACKGROUND_LOC, this.leftPos, this.topPos, 176, this.imageHeight);
        graphics.drawString(this.font, this.title, this.leftPos + 8, this.topPos + 6, -12566464, false);
        Objects.requireNonNull(this.font);
        int y = this.topPos + 6 + 9 * 2;
        for (List<FormattedCharSequence> block : this.textBlocks) {
            for (FormattedCharSequence line : block) {
                graphics.drawString(this.font, line, this.leftPos + 8, y, -16777216, false);
                Objects.requireNonNull(this.font);
                y += 9;
            }
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Style style = this.findTextLine(mouseX, mouseY);
        if (style != null) {
            graphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        Style style = this.findTextLine((int)event.x(), (int)event.y());
        if (style != null && this.handleComponentClicked(style)) {
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    @Nullable
    private Style findTextLine(int mouseX, int mouseY) {
        int localX = mouseX - this.leftPos - 8;
        if (localX < 0) {
            return null;
        }
        Objects.requireNonNull(this.font);
        int y = this.topPos + 6 + 9 * 2;
        for (List<FormattedCharSequence> block : this.textBlocks) {
            int n = block.size();
            Objects.requireNonNull(this.font);
            int height = n * 9;
            if (mouseY >= y && mouseY <= y + height) {
                Objects.requireNonNull(this.font);
                int idx = (mouseY - y) / 9;
                if (idx >= block.size()) {
                    return null;
                }
                return this.font.getSplitter().componentStyleAtWidth(block.get(idx), localX);
            }
            Objects.requireNonNull(this.font);
            y += height + 9;
        }
        return null;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        Services.PLATFORM.popScreenLayer();
    }
}

