/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import xfacthd.atlasviewer.AtlasViewer;
import xfacthd.atlasviewer.client.api.SourceAwareness;
import xfacthd.atlasviewer.client.screen.AtlasScreen;
import xfacthd.atlasviewer.client.screen.AtlasViewerScreen;
import xfacthd.atlasviewer.client.screen.MessageScreen;
import xfacthd.atlasviewer.client.screen.stacking.IStackedScreen;
import xfacthd.atlasviewer.client.screen.widget.BackgroundSwitchButton;
import xfacthd.atlasviewer.client.screen.widget.CloseButton;
import xfacthd.atlasviewer.client.screen.widget.DiscreteSliderButton;
import xfacthd.atlasviewer.client.util.ClientUtils;
import xfacthd.atlasviewer.client.util.FixedTooltipPositioner;
import xfacthd.atlasviewer.client.util.SpriteSourceManager;
import xfacthd.atlasviewer.client.util.TextLine;
import xfacthd.atlasviewer.client.util.TooltipSeparator;
import xfacthd.atlasviewer.platform.Services;

public final class SpriteInfoScreen
extends AtlasViewerScreen
implements IStackedScreen {
    private static final Component TITLE = Component.translatable((String)"title.atlasviewer.spriteinfo");
    private static final Component CHAR_INFO = Component.literal((String)"i").withStyle(ChatFormatting.BLUE);
    private static final Component LABEL_NAME = Component.translatable((String)"label.atlasviewer.spriteinfo.name");
    private static final Component LABEL_POSITION = Component.translatable((String)"label.atlasviewer.spriteinfo.position");
    private static final Component LABEL_SIZE = Component.translatable((String)"label.atlasviewer.spriteinfo.size");
    private static final Component LABEL_SOURCEPACK = Component.translatable((String)"label.atlasviewer.spriteinfo.sourcepack");
    private static final Component LABEL_READERPACK = Component.translatable((String)"label.atlasviewer.spriteinfo.readerpack", (Object[])new Object[]{CHAR_INFO});
    private static final Component LABEL_READERTYPE = Component.translatable((String)"label.atlasviewer.spriteinfo.readertype");
    private static final Component LABEL_MAX_MIP_LEVEL = Component.translatable((String)"label.atlasviewer.spriteinfo.max_mip_level", (Object[])new Object[]{CHAR_INFO});
    private static final Component LABEL_ANIMATED = Component.translatable((String)"label.atlasviewer.spriteinfo.animated");
    private static final Component LABEL_FRAMECOUNT = Component.translatable((String)"label.atlasviewer.spriteinfo.frames");
    private static final Component LABEL_INTERPOLATED = Component.translatable((String)"label.atlasviewer.spriteinfo.interpolated");
    private static final Component LABEL_FRAMETIME = Component.translatable((String)"label.atlasviewer.spriteinfo.frametime");
    private static final Component LABEL_GUI_SPRITE_TYPE = Component.translatable((String)"label.atlasviewer.spriteinfo.gui_type");
    private static final Component LABEL_GUI_SPRITE_SIZE = Component.translatable((String)"label.atlasviewer.spriteinfo.gui_size");
    private static final Component LABEL_GUI_SPRITE_NINESLICE_BORDER = Component.translatable((String)"label.atlasviewer.spriteinfo.gui_nineslice_border");
    private static final List<Label> LABELS = List.of(new Label(LABEL_NAME), new Label(LABEL_POSITION), new Label(LABEL_SIZE), new Label(LABEL_SOURCEPACK), new Label(LABEL_READERPACK), new Label(LABEL_READERTYPE), new Label(LABEL_MAX_MIP_LEVEL, screen -> screen.mipped), new Label(LABEL_ANIMATED), new Label(LABEL_FRAMECOUNT, screen -> screen.animated), new Label(LABEL_INTERPOLATED, screen -> screen.animated), new Label(LABEL_FRAMETIME, screen -> screen.animated), new Label(LABEL_GUI_SPRITE_TYPE, screen -> screen.guiSprite), new Label(LABEL_GUI_SPRITE_SIZE, screen -> screen.guiSprite && Objects.requireNonNull(screen.guiScaling).type() != GuiSpriteScaling.Type.STRETCH), new Label(LABEL_GUI_SPRITE_NINESLICE_BORDER, screen -> screen.guiSprite && Objects.requireNonNull(screen.guiScaling).type() == GuiSpriteScaling.Type.NINE_SLICE));
    private static final Component VALUE_TRUE = Component.translatable((String)"value.atlasviewer.true").withStyle(Style.EMPTY.withColor(53248));
    private static final Component VALUE_FALSE = Component.translatable((String)"value.atlasviewer.false").withStyle(Style.EMPTY.withColor(0xD00000));
    private static final Component VALUE_FRAMETIME_MIXED = Component.translatable((String)"value.atlasviewer.frametime_mixed");
    private static final Component VALUE_UNKNOWN_PACK = Component.translatable((String)"value.atlasviewer.unknown_pack").withStyle(s -> s.withColor(0xD00000));
    private static final Component TITLE_EXPORT = Component.translatable((String)"btn.atlasviewer.export_sprite");
    private static final Component TITLE_EXPORT_MIPPED = Component.translatable((String)"btn.atlasviewer.export_mipped_sprite");
    private static final Component MSG_EXPORT_DETAILS = Component.translatable((String)"msg.atlasviewer.export_sprite.detail");
    private static final Component MSG_EXPORT_SUCCESS = Component.translatable((String)"msg.atlasviewer.export_sprite_success");
    private static final Component MSG_EXPORT_ERROR = Component.translatable((String)"msg.atlasviewer.export_sprite_error");
    private static final Component TOOLTIP_READERPACK = Component.translatable((String)"tooltip.atlasviewer.reader_pack");
    private static final Component TOOLTIP_MAX_MIP_LEVEL = Component.translatable((String)"tooltip.atlasviewer.sprite.max_mip_level");
    private static final Component TOOLTIP_MIPMAP_DISABLED = Component.translatable((String)"tooltip.atlasviewer.sprite.mipmap_disabled");
    private static final Component TOOLTIP_MIPMAP_FULL = Component.translatable((String)"tooltip.atlasviewer.sprite.mipmap_full");
    private static final Component FULL_TYPE_PLACEHOLDER = Component.translatable((String)"value.atlasviewer.source_tooltip.hold_to_show", (Object[])new Object[]{InputConstants.getKey((KeyEvent)new KeyEvent(340, -1, 0)).getDisplayName()}).withStyle(ChatFormatting.GOLD);
    private static final ClientTooltipPositioner PACK_LIST_POSITIONER = new FixedTooltipPositioner();
    private static final int WIDTH = 400;
    private static final int PADDING = 5;
    private static final int LABEL_X = 148;
    private static final int SPRITE_Y = 25;
    private static final int LINE_HEIGHT = 12;
    private static final int EXPORT_WIDTH = 120;
    private static final int EXPORT_HEIGHT = 20;
    private static final int MIP_LEVEL_WIDTH = 120;
    private static final int MIP_LEVEL_HEIGHT = 20;
    private static final int CLOSE_SIZE = 12;
    private static final int SPRITE_SIZE = 128;
    private static final int FOOTER_HEIGHT = 40;
    private static final int MIN_HEIGHT = 193;
    private static final int LINE_NAME = 0;
    private static final int LINE_POSITION = 1;
    private static final int LINE_SIZE = 2;
    private static final int LINE_SOURCEPACK = 3;
    private static final int LINE_READERPACK = 4;
    private static final int LINE_READERTYPE = 5;
    private static final int LINE_MAX_MIP_LEVEL = 6;
    private final AtlasManager.AtlasEntry atlas;
    private final TextureAtlasSprite sprite;
    private final SpriteContents contents;
    private final boolean mipped;
    private final boolean animated;
    private final boolean guiSprite;
    private final List<String> sourceNames;
    @Nullable
    private final String primarySource;
    @Nullable
    private final SpriteContents.AnimatedTexture animation;
    private final int animFrameTime;
    @Nullable
    private final GuiSpriteScaling guiScaling;
    private final BackgroundSwitchButton.Type background;
    private int imageHeight;
    private int xLeft;
    private int yTop;
    private int valueX;
    private @UnknownNullability Button btnExport;
    private @UnknownNullability Button btnExportMipped;
    private @UnknownNullability TextLine spriteName;
    private @UnknownNullability Component spritePosText;
    private @UnknownNullability Component spriteSizeText;
    private @UnknownNullability TextLine primarySourceName;
    private @UnknownNullability SourcePackList sourceNameTooltip;
    private @UnknownNullability SpriteSourceInfo sourceInfo;
    private @UnknownNullability Component maxMipLevel;
    private @UnknownNullability Component maxMipLevelTooltip;
    private @UnknownNullability Component animatedText;
    private @UnknownNullability Component framesText;
    private @UnknownNullability Component interpText;
    private @UnknownNullability Component frameTimeText;
    private @UnknownNullability Component guiSpriteTypeText;
    private @UnknownNullability Component guiSpriteSizeText;
    private @UnknownNullability Component guiSpriteNinesliceBorderText;
    private int currentMipLevel;

    public SpriteInfoScreen(AtlasManager.AtlasEntry atlas, TextureAtlasSprite sprite, int currentMipLevel, BackgroundSwitchButton.Type background) {
        super(TITLE);
        this.atlas = atlas;
        this.sprite = sprite;
        this.contents = sprite.contents();
        this.mipped = atlas.config().createMipmaps();
        this.guiSprite = atlas.config().definitionLocation().equals((Object)AtlasIds.GUI);
        this.background = background;
        this.sourceNames = this.collectSourcePackNames();
        this.primarySource = this.sourceNames.isEmpty() ? null : this.sourceNames.getFirst();
        this.animation = this.contents.atlasviewer$getAnimatedTexture();
        this.animated = this.animation != null;
        this.animFrameTime = this.getAnimationFrameTime();
        this.guiScaling = this.guiSprite ? SpriteInfoScreen.getGuiScaling(sprite) : null;
        this.currentMipLevel = currentMipLevel;
    }

    protected void init() {
        int labelLen = 0;
        int labelHeight = 0;
        for (Label label : LABELS) {
            if (!label.active.test(this)) continue;
            labelLen = Math.max(labelLen, this.font.width((FormattedText)label.text));
            labelHeight += 12;
        }
        this.valueX = 148 + labelLen + 5;
        this.imageHeight = Math.max(193, 25 + labelHeight + 40);
        this.xLeft = this.width / 2 - 200;
        this.yTop = this.height / 2 - this.imageHeight / 2;
        DiscreteSliderButton mipLevelSlider = (DiscreteSliderButton)this.addRenderableWidget((GuiEventListener)new DiscreteSliderButton(this.xLeft + 10, this.yTop + this.imageHeight - 10 - 20, 120, 20, "btn.atlasviewer.mip_level", this.currentMipLevel, this.atlas.atlas().atlasviewer$getMipLevel(), this::selectMipLevel));
        this.btnExport = Button.builder((Component)TITLE_EXPORT, this::exportSprite).pos(this.xLeft + 400 - 10 - 120, this.yTop + this.imageHeight - 10 - 20).size(120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnExport);
        this.btnExportMipped = Button.builder((Component)TITLE_EXPORT_MIPPED, this::exportSpriteMipped).pos(this.xLeft + 400 - 20 - 240, this.yTop + this.imageHeight - 10 - 20).size(120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnExportMipped);
        mipLevelSlider.active = this.atlas.atlas().atlasviewer$getMipLevel() > 0;
        this.btnExportMipped.active = this.currentMipLevel > 0;
        this.addRenderableWidget((GuiEventListener)new CloseButton(this.xLeft + 400 - 5 - 12, this.yTop + 5, this));
        int maxValueLen = 390 - this.valueX;
        this.spriteName = TextLine.of(this.contents.name().toString(), this.font, maxValueLen);
        this.spritePosText = Component.translatable((String)"value.atlasviewer.position", (Object[])new Object[]{this.sprite.getX(), this.sprite.getY()});
        this.spriteSizeText = Component.translatable((String)"value.atlasviewer.size", (Object[])new Object[]{this.contents.width(), this.contents.height()});
        this.primarySourceName = this.primarySource != null && !this.primarySource.isEmpty() ? TextLine.of(this.primarySource, this.font, maxValueLen) : new TextLine(VALUE_UNKNOWN_PACK);
        this.sourceNameTooltip = this.makeTooltipList();
        this.sourceInfo = this.makeSourceInfo();
        if (this.mipped) {
            this.maxMipLevel = this.calculateMaxMipLevel();
        }
        if (this.animated) {
            this.animatedText = VALUE_TRUE;
            this.framesText = Component.literal((String)String.valueOf(this.contents.atlasviewer$callGetFrameCount()));
            boolean interp = Objects.requireNonNull(this.animation).atlasviewer$getInterpolateFrames();
            Component component = this.interpText = interp ? VALUE_TRUE : VALUE_FALSE;
            this.frameTimeText = this.animFrameTime == -1 ? VALUE_FRAMETIME_MIXED : Component.literal((String)(this.animFrameTime + (this.animFrameTime == 1 ? " tick" : " ticks")));
        } else {
            this.animatedText = VALUE_FALSE;
        }
        if (this.guiSprite) {
            this.guiSpriteTypeText = Component.translatable((String)("value.atlasviewer.spriteinfo.gui_sprite_type." + Objects.requireNonNull(this.guiScaling).type().getSerializedName()));
            GuiSpriteScaling guiSpriteScaling = this.guiScaling;
            Objects.requireNonNull(guiSpriteScaling);
            GuiSpriteScaling guiSpriteScaling2 = guiSpriteScaling;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuiSpriteScaling.Tile.class, GuiSpriteScaling.NineSlice.class}, (Object)guiSpriteScaling2, n)) {
                case 0: {
                    GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)guiSpriteScaling2;
                    this.guiSpriteSizeText = Component.translatable((String)"value.atlasviewer.size", (Object[])new Object[]{tile.width(), tile.height()});
                    break;
                }
                case 1: {
                    GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiSpriteScaling2;
                    this.guiSpriteSizeText = Component.translatable((String)"value.atlasviewer.size", (Object[])new Object[]{nineSlice.width(), nineSlice.height()});
                    GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
                    if (border.top() == border.bottom() && border.top() == border.left() && border.top() == border.right()) {
                        this.guiSpriteNinesliceBorderText = Component.literal((String)(border.top() + "px"));
                        break;
                    }
                    this.guiSpriteNinesliceBorderText = Component.translatable((String)"value.atlasviewer.spriteinfo.gui_nineslice_border", (Object[])new Object[]{border.top(), border.bottom(), border.left(), border.right()});
                    break;
                }
            }
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBlurredBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, AtlasScreen.BACKGROUND_LOC, this.xLeft, this.yTop, 400, this.imageHeight);
        graphics.drawString(this.font, this.title, this.xLeft + 10, this.yTop + 10, -12566464, false);
        int y = this.yTop + 25;
        y = this.drawLine(graphics, LABEL_NAME, this.spriteName.text(), y);
        y = this.drawLine(graphics, LABEL_POSITION, this.spritePosText, y);
        y = this.drawLine(graphics, LABEL_SIZE, this.spriteSizeText, y);
        y = this.drawLine(graphics, LABEL_SOURCEPACK, this.primarySourceName.text(), y);
        y = this.drawLine(graphics, LABEL_READERPACK, this.sourceInfo.sourcePack, y);
        y = this.drawLine(graphics, LABEL_READERTYPE, this.sourceInfo.sourceType, y);
        if (this.mipped) {
            y = this.drawLine(graphics, LABEL_MAX_MIP_LEVEL, this.maxMipLevel, y);
        }
        y = this.drawLine(graphics, LABEL_ANIMATED, this.animatedText, y);
        if (this.animated) {
            y = this.drawLine(graphics, LABEL_FRAMECOUNT, this.framesText, y);
            y = this.drawLine(graphics, LABEL_INTERPOLATED, this.interpText, y);
            y = this.drawLine(graphics, LABEL_FRAMETIME, this.frameTimeText, y);
        }
        if (this.guiSprite) {
            y = this.drawLine(graphics, LABEL_GUI_SPRITE_TYPE, this.guiSpriteTypeText, y);
            if (this.guiSpriteSizeText != null) {
                y = this.drawLine(graphics, LABEL_GUI_SPRITE_SIZE, this.guiSpriteSizeText, y);
            }
            if (this.guiSpriteNinesliceBorderText != null) {
                y = this.drawLine(graphics, LABEL_GUI_SPRITE_NINESLICE_BORDER, this.guiSpriteNinesliceBorderText, y);
            }
        }
        float scale = 128.0f / (float)Math.max(this.contents.width(), this.contents.height());
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.background.getSprite(), this.xLeft + 10, this.yTop + 25, (int)((float)this.contents.width() * scale), (int)((float)this.contents.height() * scale));
        GpuTextureView atlasTexView = this.atlas.atlas().atlasview$getMippedTextureView(this.currentMipLevel);
        ClientUtils.blitSpecial(graphics, RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)atlasTexView), this.xLeft + 10, this.yTop + 25, this.xLeft + 10 + (int)((float)this.contents.width() * scale), this.yTop + 25 + (int)((float)this.contents.height() * scale), this.sprite.getU0(), this.sprite.getU1(), this.sprite.getV0(), this.sprite.getV1(), -1);
        if (this.btnExport.isHovered()) {
            this.setTooltipForNextFrame(graphics, MSG_EXPORT_DETAILS, mouseX, mouseY);
        } else if (this.btnExportMipped.active && this.btnExportMipped.isHovered()) {
            this.setTooltipForNextFrame(graphics, (Component)Component.translatable((String)"msg.atlasviewer.export_mipped_atlas.detail", (Object[])new Object[]{this.currentMipLevel}), mouseX, mouseY);
        }
    }

    private int drawLine(GuiGraphics graphics, Component label, Component value, int y) {
        graphics.drawString(this.font, label, this.xLeft + 148, y, -12566464, false);
        graphics.drawString(this.font, value, this.xLeft + this.valueX, y, -12566464, false);
        return y + 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int lx = this.xLeft + 148;
        int lyPack = this.yTop + 25 + 48;
        int lyMip = this.yTop + 25 + 72;
        if (mouseX >= lx && mouseX < lx + this.font.width((FormattedText)LABEL_READERPACK) && mouseY >= lyPack) {
            Objects.requireNonNull(this.font);
            if (mouseY < lyPack + 9) {
                this.setTooltipForNextFrame(graphics, TOOLTIP_READERPACK, mouseX, mouseY);
                return;
            }
        }
        if (this.mipped && mouseX >= lx && mouseX < lx + this.font.width((FormattedText)LABEL_MAX_MIP_LEVEL) && mouseY >= lyMip) {
            Objects.requireNonNull(this.font);
            if (mouseY < lyMip + 9) {
                this.setTooltipForNextFrame(graphics, TOOLTIP_MAX_MIP_LEVEL, mouseX, mouseY);
                return;
            }
        }
        if (this.spriteName.capped() && this.isHoveringLine(mouseX, mouseY, 0, this.spriteName.text())) {
            this.setTooltipForNextFrame(graphics, this.spriteName.fullText(), mouseX, mouseY);
            return;
        }
        if (this.sourceInfo.sourcePackTooltip != null && this.isHoveringLine(mouseX, mouseY, 4, this.sourceInfo.sourcePack)) {
            if (this.sourceInfo.hasSourcePack) {
                this.setFixedTooltipForNextFrame(graphics, 4, this.sourceInfo.sourcePackTooltip);
                return;
            }
            this.setTooltipForNextFrame(graphics, this.sourceInfo.sourcePackTooltip, mouseX, mouseY);
            return;
        }
        if (this.sourceInfo.sourceTypeTooltip != null && this.isHoveringLine(mouseX, mouseY, 5, this.sourceInfo.sourceType)) {
            List<FormattedCharSequence> lines = this.sourceInfo.sourceTypeTooltip;
            if (this.sourceInfo.hasConcreteSourceType && !this.minecraft().hasShiftDown()) {
                lines = Objects.requireNonNull(this.sourceInfo.sourceTypeTooltipNoFullType);
            }
            graphics.setTooltipForNextFrame(this.font, lines, mouseX, mouseY);
            return;
        }
        if ((this.sourceNames.size() > 1 || this.primarySourceName.capped()) && this.isHoveringLine(mouseX, mouseY, 3, this.primarySourceName.text())) {
            this.setFixedTooltipForNextFrame(graphics, 3, this.sourceNameTooltip.entries, this.sourceNameTooltip.maxLen);
            return;
        }
        if (!this.mipped) return;
        if (!this.isHoveringLine(mouseX, mouseY, 6, this.maxMipLevel)) return;
        this.setTooltipForNextFrame(graphics, this.maxMipLevelTooltip, mouseX, mouseY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHoveringLine(int mouseX, int mouseY, int lineIdx, Component text) {
        int yTextTop = this.yTop + 25 + 12 * lineIdx;
        int xTextRight = this.xLeft + this.valueX + this.font.width((FormattedText)text);
        if (mouseX < this.xLeft + this.valueX) return false;
        if (mouseX > xTextRight) return false;
        if (mouseY < yTextTop) return false;
        Objects.requireNonNull(this.font);
        if (mouseY > yTextTop + 9) return false;
        return true;
    }

    private void setFixedTooltipForNextFrame(GuiGraphics graphics, int lineIdx, Component text) {
        List<ClientTooltipComponent> tooltip = List.of(ClientTooltipComponent.create((FormattedCharSequence)text.getVisualOrderText()));
        this.setFixedTooltipForNextFrame(graphics, lineIdx, tooltip, this.font.width((FormattedText)text));
    }

    private void setFixedTooltipForNextFrame(GuiGraphics graphics, int lineIdx, List<ClientTooltipComponent> components, int maxLen) {
        int x = Math.min(this.xLeft + this.valueX, this.width - maxLen - 5);
        int y = this.yTop + 25 + 12 * lineIdx;
        graphics.setTooltipForNextFrameInternal(this.font, components, x, y, PACK_LIST_POSITIONER, null, true);
    }

    private List<String> collectSourcePackNames() {
        String capturedPackId;
        ResourceLocation name = this.contents.name();
        ResourceLocation loc = Objects.requireNonNullElseGet(this.contents.atlasviewer$getOriginalPath(), () -> ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("textures/" + name.getPath() + ".png")));
        List resources = Minecraft.getInstance().getResourceManager().getResourceStack(loc);
        List sources = resources.stream().map(Resource::source).map(PackResources::packId).collect(Collectors.toCollection(ArrayList::new));
        if (sources.isEmpty() && (capturedPackId = this.contents.atlasviewer$getTextureSourcePack()) != null) {
            sources.add(capturedPackId);
        }
        Collections.reverse(sources);
        return sources;
    }

    private static GuiSpriteScaling getGuiScaling(TextureAtlasSprite sprite) {
        return sprite.contents().getAdditionalMetadata(GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
    }

    private SourcePackList makeTooltipList() {
        if (this.sourceNames.isEmpty()) {
            return new SourcePackList(List.of(), 0);
        }
        List<Component> lines = this.sourceNames.stream().map(Component::literal).map(Component.class::cast).toList();
        int maxWidth = lines.stream().mapToInt(arg_0 -> ((Font)this.font).width(arg_0)).max().orElseThrow();
        TooltipSeparator seperator = new TooltipSeparator(maxWidth, -1, false);
        MutableBoolean first = new MutableBoolean(true);
        List components = lines.stream().flatMap(line -> {
            List lineComponents = this.font.split((FormattedText)line, maxWidth).stream().map(ClientTooltipComponent::create).collect(Collectors.toCollection(ArrayList::new));
            if (first.booleanValue() && lineComponents.size() == 1) {
                lineComponents.add(new TooltipSeparator(maxWidth, -1, true));
            } else {
                lineComponents.add(seperator);
            }
            first.setFalse();
            return lineComponents.stream();
        }).collect(Collectors.toCollection(ArrayList::new));
        components.removeLast();
        return new SourcePackList(components, maxWidth);
    }

    private SpriteSourceInfo makeSourceInfo() {
        List<Object> sourceTypeTooltip;
        Component sourceType;
        Component sourcePackTooltip;
        Component sourcePack;
        int maxValueLen = 390 - this.valueX;
        boolean hasSourcePack = false;
        SourceAwareness awareness = this.contents.atlasviewer$getSourceAwareness();
        if (awareness == SourceAwareness.SOURCE_KNOWN) {
            String packId = this.contents.atlasviewer$getSpriteSourceSourcePack();
            if (packId != null && !packId.isEmpty()) {
                TextLine packIdPair = TextLine.of(packId, this.font, maxValueLen);
                sourcePack = packIdPair.text();
                sourcePackTooltip = !sourcePack.equals((Object)packIdPair.fullText()) ? packIdPair.fullText() : null;
                hasSourcePack = true;
            } else {
                sourcePack = VALUE_UNKNOWN_PACK;
                sourcePackTooltip = null;
            }
        } else {
            sourcePack = awareness.getDescription();
            sourcePackTooltip = awareness.getTooltip();
        }
        List<FormattedCharSequence> sourceTypeTooltipNoFullType = null;
        boolean hasConcreteSourceType = false;
        SpriteSource source = this.contents.atlasviewer$getSpriteSource();
        if (source != null) {
            Class sourceTypeClazz = source.getClass();
            String typeDesc = SpriteSourceManager.getSpecialDescription(sourceTypeClazz);
            if (typeDesc != null) {
                TextLine typeNamePair = TextLine.of(typeDesc, this.font, maxValueLen);
                sourceType = typeNamePair.text();
                sourceTypeTooltip = !sourceType.equals((Object)typeNamePair.fullText()) ? List.of(typeNamePair.fullText().getVisualOrderText()) : null;
            } else {
                String typeName = Services.PLATFORM.getSpriteSourceName(source);
                String shortTypeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                sourceType = TextLine.of(shortTypeName, this.font, maxValueLen).text();
                hasConcreteSourceType = true;
                List<Tuple<Component, Component>> tooltipLines = SpriteSourceManager.buildSourceTooltip(source, typeName);
                sourceTypeTooltip = SpriteInfoScreen.formatTooltip(tooltipLines);
                tooltipLines.getLast().setB((Object)FULL_TYPE_PLACEHOLDER);
                sourceTypeTooltipNoFullType = SpriteInfoScreen.formatTooltip(tooltipLines);
            }
        } else {
            sourceType = awareness.getDescription();
            sourceTypeTooltip = List.of(awareness.getTooltip().getVisualOrderText());
        }
        return new SpriteSourceInfo(sourcePack, sourcePackTooltip, hasSourcePack, sourceType, sourceTypeTooltip, sourceTypeTooltipNoFullType, hasConcreteSourceType);
    }

    private static List<FormattedCharSequence> formatTooltip(List<Tuple<Component, Component>> tooltipLines) {
        return tooltipLines.stream().peek(pair -> {
            if (pair.getA() != null) {
                pair.setA((Object)((Component)pair.getA()).copy().withStyle(ChatFormatting.ITALIC));
            }
        }).map(pair -> {
            MutableComponent line = Component.empty();
            if (pair.getA() != null) {
                line = line.append((Component)pair.getA()).append(": ");
            }
            return line.append((Component)pair.getB());
        }).map(Component::getVisualOrderText).toList();
    }

    private Component calculateMaxMipLevel() {
        int lowestOne = Math.min(Integer.lowestOneBit(this.contents.width()), Integer.lowestOneBit(this.contents.height()));
        int maxLevel = Math.min(Mth.log2((int)lowestOne), 4);
        return switch (maxLevel) {
            case 0 -> {
                this.maxMipLevelTooltip = TOOLTIP_MIPMAP_DISABLED;
                yield Component.literal((String)"0").withStyle(s -> s.withColor(0xD00000));
            }
            case 4 -> {
                this.maxMipLevelTooltip = TOOLTIP_MIPMAP_FULL;
                yield Component.literal((String)"4").withStyle(s -> s.withColor(53248));
            }
            default -> {
                this.maxMipLevelTooltip = Component.translatable((String)"tooltip.atlasviewer.sprite.mipmap_limited", (Object[])new Object[]{maxLevel});
                yield Component.literal((String)String.valueOf(maxLevel)).withStyle(s -> s.withColor(0xCC6600));
            }
        };
    }

    private int getAnimationFrameTime() {
        if (this.animation == null) {
            return 0;
        }
        List frames = this.animation.atlasviewer$getFrames();
        int first = ((SpriteContents.FrameInfo)frames.getFirst()).time();
        for (SpriteContents.FrameInfo frame : frames) {
            if (frame.time() == first) continue;
            return -1;
        }
        return first;
    }

    private void selectMipLevel(int level) {
        this.currentMipLevel = level;
        this.btnExportMipped.active = level > 0;
    }

    private void exportSprite(Button btn) {
        this.exportSprite(0);
    }

    private void exportSpriteMipped(Button btn) {
        this.exportSprite(this.currentMipLevel);
    }

    private void exportSprite(int mipLevel) {
        try {
            NativeImage image = this.contents.atlasviewer$getByMipLevel()[mipLevel];
            AtlasScreen.exportNativeImage(image, this.contents.name(), "sprite", mipLevel, false, MSG_EXPORT_SUCCESS);
        }
        catch (IOException e) {
            AtlasViewer.LOGGER.error("Encountered an error while exporting sprite", (Throwable)e);
            Services.PLATFORM.pushScreenLayer(MessageScreen.error(List.of(MSG_EXPORT_ERROR, Component.literal((String)e.getMessage()))));
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (event.button() == 0 && (event.x() < (double)this.xLeft || event.y() < (double)this.yTop || event.x() > (double)(this.xLeft + 400) || event.y() > (double)(this.yTop + this.imageHeight))) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public void onClose() {
        Services.PLATFORM.popScreenLayer();
    }

    private record Label(Component text, Predicate<SpriteInfoScreen> active) {
        public Label(Component text) {
            this(text, screen -> true);
        }
    }

    private record SourcePackList(List<ClientTooltipComponent> entries, int maxLen) {
    }

    private record SpriteSourceInfo(Component sourcePack, @Nullable Component sourcePackTooltip, boolean hasSourcePack, Component sourceType, @Nullable List<FormattedCharSequence> sourceTypeTooltip, @Nullable List<FormattedCharSequence> sourceTypeTooltipNoFullType, boolean hasConcreteSourceType) {
    }
}

