/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import xfacthd.atlasviewer.client.screen.AtlasInfoScreen;
import xfacthd.atlasviewer.client.util.ClientUtils;

public final class AtlasLoadTable
extends AbstractWidget {
    private static final ResourceLocation ARROW_UP = ResourceLocation.withDefaultNamespace((String)"transferable_list/move_up");
    private static final ResourceLocation ARROW_DOWN = ResourceLocation.withDefaultNamespace((String)"transferable_list/move_down");
    private static final float ARROW_SCALE = 0.5f;
    private static final float ARROW_UP_OFF_X = 9.0f;
    private static final float ARROW_UP_OFF_Y = 2.5f;
    private static final float ARROW_DOWN_OFF_X = 9.0f;
    private static final float ARROW_DOWN_OFF_Y = 10.0f;
    private static final Component HEADER_NAMESPACE = Component.translatable((String)"header.atlasviewer.atlasload.namespace");
    private static final Component HEADER_COUNT = Component.translatable((String)"header.atlasviewer.atlasload.count");
    private static final Component HEADER_OF_TOTAL = Component.translatable((String)"header.atlasviewer.atlasload.of_total");
    private static final Component HEADER_OF_FILLED = Component.translatable((String)"header.atlasviewer.atlasload.of_filled");
    private static final Component[] HEADERS = new Component[]{HEADER_NAMESPACE, HEADER_COUNT, HEADER_OF_TOTAL, HEADER_OF_FILLED};
    private static final Comparator<AtlasInfoScreen.FillStat> DEFAULT_STAT_COMPARATOR = Comparator.comparing(AtlasInfoScreen.FillStat::namespace);
    public static final int TABLE_HEIGHT = 56;
    private static final int SCROLL_BAR_WIDTH = 4;
    private static final int SORT_ARROW_WIDTH = 8;
    private final AtlasInfoScreen.AtlasInfo atlasInfo;
    private final int nsCount;
    private final int contentWidth;
    private final int[] colWidth = new int[4];
    private final int[] colTextX = new int[4];
    private final int[] colArrowX = new int[4];
    private final boolean scrollBar;
    private final int entryHeight;
    private final int scrollBarX;
    private final int scrollBarHeight;
    private final float scrollFactor;
    private final Font font;
    private int scrollOffset;
    private SortTarget sorting;
    private boolean reverse;

    public AtlasLoadTable(int x, int y, int width, AtlasInfoScreen.AtlasInfo atlasInfo) {
        super(x, y, width, 56, (Component)Component.empty());
        this.font = Minecraft.getInstance().font;
        this.scrollOffset = 0;
        this.sorting = SortTarget.NAMESPACE;
        this.reverse = false;
        this.atlasInfo = atlasInfo;
        this.nsCount = atlasInfo.fillStats().size();
        this.scrollBar = atlasInfo.fillStats().size() > 4;
        this.contentWidth = width - 2 - (this.scrollBar ? 5 : 0);
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 + 2;
        this.scrollBarX = this.scrollBar ? x + width - 1 - 4 : 0;
        this.scrollBarHeight = this.scrollBar ? (int)Math.max((float)(this.height - 1 - this.entryHeight) * (4.0f / (float)this.nsCount), 3.0f) : 0;
        this.scrollFactor = this.scrollBar ? (float)(this.entryHeight * 4 - this.scrollBarHeight - 1) / (float)(this.nsCount - 4) : 0.0f;
        this.colWidth[1] = this.font.width((FormattedText)HEADER_COUNT) + 8 + 3;
        this.colWidth[2] = this.font.width((FormattedText)HEADER_OF_TOTAL) + 8 + 3;
        this.colWidth[3] = this.font.width((FormattedText)HEADER_OF_FILLED) + 8 + 3;
        this.colWidth[0] = this.contentWidth - (this.colWidth[1] + this.colWidth[2] + this.colWidth[3]) - 3;
        int tx = x + 3;
        for (int i = 0; i < 4; ++i) {
            this.colTextX[i] = tx;
            this.colArrowX[i] = tx + this.font.width((FormattedText)HEADERS[i]) + 1;
            tx += this.colWidth[i] + 1;
        }
        this.sorting.sort(atlasInfo.fillStats(), false);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ClientUtils.drawColoredBox(graphics, this.getX(), this.getY(), this.width, this.height, -16777216);
        int x = this.getX() + 1;
        int y = this.getY() + 1;
        for (int i = 0; i < 4; ++i) {
            int w = this.colWidth[i];
            int color = i % 2 == 0 ? -7697782 : -6250336;
            graphics.fill(x, y, x + w, y + this.height - 2, color);
            if (i != 3) {
                graphics.vLine(x + w, this.getY(), this.getY() + this.height - 1, -16777216);
            }
            x += w + 1;
        }
        x = this.getX() + 1;
        Objects.requireNonNull(this.font);
        graphics.hLine(x, x + this.width - 2, ++y + 9, -16777216);
        graphics.drawString(this.font, HEADER_NAMESPACE, this.colTextX[0], y, -13619152, false);
        graphics.drawString(this.font, HEADER_COUNT, this.colTextX[1], y, -13619152, false);
        graphics.drawString(this.font, HEADER_OF_TOTAL, this.colTextX[2], y, -13619152, false);
        graphics.drawString(this.font, HEADER_OF_FILLED, this.colTextX[3], y, -13619152, false);
        x = this.getX() + 3;
        y += this.entryHeight;
        int maxIdx = Mth.clamp((int)(this.nsCount - this.scrollOffset), (int)0, (int)4);
        for (int i = 0; i < maxIdx; ++i) {
            int idx = i + this.scrollOffset;
            int tx = this.colTextX[0];
            AtlasInfoScreen.FillStat stat = this.atlasInfo.fillStats().get(idx);
            graphics.drawString(this.font, stat.namespace(), tx, y, -13619152, false);
            String count = Integer.toString(stat.count());
            tx = this.colTextX[1];
            int tw = this.font.width(count);
            graphics.drawString(this.font, count, tx + this.colWidth[1] - tw - 3, y, -13619152, false);
            String percentOfTotal = "%.1f %%".formatted(Float.valueOf(stat.percentOfTotal() * 100.0f));
            tx = this.colTextX[2];
            tw = this.font.width(percentOfTotal);
            graphics.drawString(this.font, percentOfTotal, tx + this.colWidth[2] - tw - 3, y, -13619152, false);
            String percentOfFilled = "%.1f %%".formatted(Float.valueOf(stat.percentOfFilled() * 100.0f));
            tx = this.colTextX[3];
            tw = this.font.width(percentOfFilled);
            graphics.drawString(this.font, percentOfFilled, tx + this.colWidth[3] - tw - 3, y, -13619152, false);
            Objects.requireNonNull(this.font);
            graphics.hLine(x - 3, x + this.contentWidth - 2, y + 9, -16777216);
            y += this.entryHeight;
        }
        if (this.scrollBar) {
            graphics.vLine(this.getX() + 1 + this.contentWidth, this.getY(), this.getY() + this.height - 1, -16777216);
            int by = this.getY() + 1 + this.entryHeight + Math.round(this.scrollFactor * (float)this.scrollOffset);
            by = Math.min(by, this.getY() + this.height - this.scrollBarHeight - 1);
            graphics.fill(this.scrollBarX, by, this.scrollBarX + 4, by + this.scrollBarHeight, -10066330);
            graphics.fill(this.scrollBarX + 1, by + 1, this.scrollBarX + 4 - 1, by + this.scrollBarHeight - 1, -5592406);
        }
        ResourceLocation tex = this.reverse ? ARROW_UP : ARROW_DOWN;
        float xOff = this.reverse ? 9.0f : 9.0f;
        float yOff = this.reverse ? 2.5f : 10.0f;
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)this.colArrowX[this.sorting.ordinal()] - xOff, (float)(this.getY() + 4) - yOff);
        graphics.pose().scale(0.5f, 0.5f);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, tex, 0, 0, 32, 32);
        graphics.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (event.button() == 0 && event.y() >= (double)(this.getY() + 1)) {
            double d = event.y();
            int n = this.getY();
            Objects.requireNonNull(this.font);
            if (d <= (double)(n + 9 + 2)) {
                SortTarget newTarget = null;
                int x = this.getX() + 1;
                for (int i = 0; i < 4; ++i) {
                    int w = this.colWidth[i];
                    if (event.x() >= (double)x && event.x() <= (double)(x + w)) {
                        newTarget = SortTarget.VALUES[i];
                        break;
                    }
                    x += w + 1;
                }
                if (newTarget != null) {
                    if (newTarget == this.sorting) {
                        this.reverse = !this.reverse;
                    } else {
                        this.sorting = newTarget;
                        this.reverse = false;
                    }
                    this.sorting.sort(this.atlasInfo.fillStats(), this.reverse);
                    return true;
                }
            }
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.scrollBar && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height)) {
            if (deltaY < 0.0 && this.scrollOffset < this.atlasInfo.fillStats().size() - 4) {
                ++this.scrollOffset;
            } else if (deltaY > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput out) {
    }

    private static enum SortTarget {
        NAMESPACE(DEFAULT_STAT_COMPARATOR),
        COUNT(Comparator.comparingInt(AtlasInfoScreen.FillStat::count)),
        PERCENT_OF_TOTAL(Comparator.comparingDouble(AtlasInfoScreen.FillStat::percentOfTotal)),
        PERCENT_OF_FILLED(Comparator.comparingDouble(AtlasInfoScreen.FillStat::percentOfFilled));

        private static final SortTarget[] VALUES;
        private final Comparator<AtlasInfoScreen.FillStat> statComparator;
        private final Comparator<AtlasInfoScreen.FillStat> statComparatorReverse;

        private SortTarget(Comparator<AtlasInfoScreen.FillStat> statComparator) {
            if (statComparator != DEFAULT_STAT_COMPARATOR) {
                statComparator = statComparator.thenComparing(DEFAULT_STAT_COMPARATOR);
            }
            this.statComparator = statComparator;
            this.statComparatorReverse = statComparator.reversed();
        }

        public void sort(List<AtlasInfoScreen.FillStat> stats, boolean reverse) {
            stats.sort(reverse ? this.statComparatorReverse : this.statComparator);
        }

        static {
            VALUES = SortTarget.values();
        }
    }
}

