/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.AtlasViewer;

public final class BackgroundSwitchButton
extends Button {
    public static final Component TITLE = Component.translatable((String)"btn.atlasviewer.switch_background");
    private static final ResourceLocation BG_SELECTED = AtlasViewer.rl("icon_background_selected");
    private static final ResourceLocation BG_UNSELECTED = AtlasViewer.rl("icon_background_unselected");
    private static final int ICON_BG_SIZE = 14;
    private static final int ICON_SIZE = 12;
    private static final int ICON_TOTAL_WIDTH = 15 * Type.VALUES.length - 1;
    private Type type;

    public BackgroundSwitchButton(int x, int y, int width, @Nullable Type type) {
        super(x, y, width, 20, TITLE, btn -> {}, DEFAULT_NARRATION);
        this.type = Objects.requireNonNullElse(type, Type.CHECKER);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        for (int i = 0; i < Type.VALUES.length; ++i) {
            Type type = Type.VALUES[i];
            ResourceLocation bgTex = this.type == type ? BG_SELECTED : BG_UNSELECTED;
            ResourceLocation tex = type.sprite;
            int x = this.getX() + this.getWidth() - 1 - 15 * (Type.VALUES.length - i);
            int y = this.getY() + 4;
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, bgTex, x - 1, y - 1, 14, 14);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, tex, x, y, 12, 12);
        }
    }

    public void renderString(GuiGraphics graphics, Font font, int color) {
        int maxX = this.getX() + (this.getWidth() - 3 - ICON_TOTAL_WIDTH) - 2;
        BackgroundSwitchButton.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)this.getMessage(), (int)(this.getX() + 2), (int)this.getY(), (int)maxX, (int)(this.getY() + this.getHeight()), (int)color);
    }

    public void onPress(InputWithModifiers input) {
        this.type = Minecraft.getInstance().hasShiftDown() ? this.type.previous() : this.type.next();
    }

    public Type getSelectedType() {
        return this.type;
    }

    public static enum Type {
        CHECKER(AtlasViewer.rl("checker")),
        DARK(AtlasViewer.rl("dark")),
        WHITE(AtlasViewer.rl("white"));

        private static final Type[] VALUES;
        private final ResourceLocation sprite;

        private Type(ResourceLocation sprite) {
            this.sprite = sprite;
        }

        public ResourceLocation getSprite() {
            return this.sprite;
        }

        Type next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        Type previous() {
            return VALUES[(this.ordinal() + VALUES.length - 1) % VALUES.length];
        }

        static {
            VALUES = Type.values();
        }
    }
}

