/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class DiscreteSliderButton
extends AbstractSliderButton {
    private final String msgKey;
    private int maxStep;
    private int step;
    private final IntConsumer changeListener;

    public DiscreteSliderButton(int x, int y, int width, int height, String msgKey, int step, int maxStep, IntConsumer changeListener) {
        super(x, y, width, height, (Component)Component.translatable((String)msgKey, (Object[])new Object[]{step}), maxStep > 0 ? (double)step / (double)maxStep : 0.0);
        this.msgKey = msgKey;
        this.maxStep = maxStep;
        this.step = step;
        this.changeListener = changeListener;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (!this.active) {
            int x = this.getX() + (int)(this.value * (double)(this.width - 8));
            graphics.fill(x + 1, this.getY() + 1, x + 7, this.getY() + 19, -1438629824);
        }
    }

    protected ResourceLocation getHandleSprite() {
        return this.active ? super.getHandleSprite() : SLIDER_HANDLE_SPRITE;
    }

    protected void updateMessage() {
        this.setMessage((Component)Component.translatable((String)this.msgKey, (Object[])new Object[]{this.step}));
    }

    protected void applyValue() {
        this.setStep((int)Math.round(this.value * (double)this.maxStep), false);
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step, boolean forceUpdateMessage) {
        int lastStep = this.step;
        this.step = step;
        double d = this.value = this.maxStep > 0 ? (double)step / (double)this.maxStep : 0.0;
        if (step != lastStep) {
            this.changeListener.accept(step);
            if (forceUpdateMessage) {
                this.updateMessage();
            }
        }
    }

    public int getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(int maxStep) {
        if (maxStep != this.maxStep) {
            this.maxStep = maxStep;
            this.step = 0;
            this.value = 0.0;
            this.updateMessage();
        }
    }
}

