/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.AtlasViewer;

public final class IndicatorButton
extends Button {
    private static final ResourceLocation INDICATOR_TEXTURE = AtlasViewer.rl("indicator");
    private static final ResourceLocation INDICATOR_CHECKED_TEXTURE = AtlasViewer.rl("indicator_checked");
    private static final int INDICATOR_SIZE = 13;
    private boolean checked = false;

    public IndicatorButton(int x, int y, int w, int h, Component text, @Nullable IndicatorButton prev, Button.OnPress onPress) {
        super(x, y, w, h, text, onPress, Button.DEFAULT_NARRATION);
        if (prev != null) {
            this.checked = prev.checked;
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        int x = this.getX() + this.width - 13 - 3;
        int y = this.getY() + 3;
        ResourceLocation tex = this.checked ? INDICATOR_CHECKED_TEXTURE : INDICATOR_TEXTURE;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, tex, x, y, 13, 13);
    }

    public void renderString(GuiGraphics graphics, Font font, int color) {
        int minX = this.getX() + 2;
        int maxX = this.getX() + this.getWidth() - 13 - 6;
        IndicatorButton.renderScrollingString((GuiGraphics)graphics, (Font)font, (Component)this.getMessage(), (int)minX, (int)this.getY(), (int)maxX, (int)(this.getY() + this.getHeight()), (int)color);
    }

    public void onPress(InputWithModifiers input) {
        this.checked = !this.checked;
        super.onPress(input);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}

