/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import xfacthd.atlasviewer.client.util.ClientUtils;

public final class MenuContainer
extends GridLayout {
    private static final int PADDING = 2;
    private final int originX;
    private final int originWidth;
    private final Button menuButton;
    private final boolean rightAlign;
    private int nextRow = 1;
    private boolean open = false;

    public MenuContainer(Button menuButton, boolean rightAlign) {
        super(menuButton.getX(), menuButton.getY() + 20);
        this.originX = menuButton.getX();
        this.originWidth = menuButton.getWidth();
        this.menuButton = menuButton;
        this.rightAlign = rightAlign;
        this.defaultCellSetting().padding(2);
    }

    public void arrangeElements() {
        super.arrangeElements();
        if (this.rightAlign) {
            this.setX(this.originX + this.originWidth - this.getWidth());
        }
        this.visitWidgets(widget -> widget.setWidth(this.getWidth() - 4));
        this.setOpen((LayoutElement)this, false);
    }

    public void addMenuEntry(LayoutElement element) {
        this.addChild(element, this.nextRow, 0);
        this.defaultCellSetting().paddingTop(0);
        ++this.nextRow;
    }

    public void render(GuiGraphics graphics) {
        if (this.open) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -10066330);
            ClientUtils.drawColoredBox(graphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), -13421773);
        }
    }

    public void toggleOpen() {
        this.setOpen(!this.open);
    }

    public void setOpen(boolean open) {
        if (this.open != open) {
            this.open = open;
            this.setOpen((LayoutElement)this, open);
        }
    }

    private void setOpen(LayoutElement element, boolean open) {
        element.visitWidgets(widget -> {
            if (widget != this.menuButton) {
                widget.atlasviewer$setVisible(open);
            }
        });
        if (element instanceof Layout) {
            Layout layout = (Layout)element;
            layout.visitChildren(childElem -> this.setOpen((LayoutElement)childElem, open));
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY <= (double)(this.getY() + this.getHeight())) {
            return true;
        }
        return this.menuButton.isMouseOver(mouseX, mouseY);
    }
}

