/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class SelectionWidget<T extends SelectionEntry<T>>
extends AbstractButton {
    private static final ResourceLocation ARROW_UP = ResourceLocation.withDefaultNamespace((String)"transferable_list/move_up");
    private static final ResourceLocation ARROW_DOWN = ResourceLocation.withDefaultNamespace((String)"transferable_list/move_down");
    private static final int ARROW_UP_OFF_X = 18;
    private static final int ARROW_UP_OFF_Y = 5;
    private static final int ARROW_DOWN_OFF_X = 18;
    private static final int ARROW_DOWN_OFF_Y = 20;
    private static final int ENTRY_HEIGHT = 20;
    private final Screen owner;
    private final Component title;
    @Nullable
    private final Consumer<T> selectCallback;
    private final List<T> entries = new ArrayList<T>();
    @Nullable
    private T focused = null;
    @Nullable
    private T selected = null;
    private boolean extended = false;
    private int scrollOffset = 0;

    public SelectionWidget(Screen owner, int x, int y, int width, Component title, @Nullable Consumer<T> selectCallback) {
        super(x, y, width, 20, (Component)Component.empty());
        this.owner = owner;
        this.title = title;
        this.selectCallback = selectCallback;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int fgColor;
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        int n = fgColor = this.active ? 0xFFFFFF : 0xA0A0A0;
        if (this.selected != null) {
            boolean entryFocused = ((SelectionEntry)this.selected).isFocused();
            ((SelectionEntry)this.selected).focused = false;
            ((SelectionEntry)this.selected).render(graphics, this.getX(), this.getY(), this.width, false, fgColor, this.alpha);
            ((SelectionEntry)this.selected).focused = entryFocused;
        } else {
            Font font = Minecraft.getInstance().font;
            graphics.drawString(font, this.title, this.getX() + 6, this.getY() + (this.height - 8) / 2, fgColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
        if (this.extended) {
            int boxHeight = Math.max(1, 20 * Math.min(this.entries.size(), 4)) + 2;
            graphics.fill(this.getX(), this.getY() + 20 - 1, this.getX() + this.width, this.getY() + 20 + boxHeight - 1, -1);
            graphics.fill(this.getX() + 1, this.getY() + 20, this.getX() + this.width - 1, this.getY() + 20 + boxHeight - 2, -16777216);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARROW_UP, this.getX() + this.width - 17 - 18, this.getY() + 6 - 5, 32, 32);
            T hoverEntry = this.getEntryAtPosition(mouseX, mouseY);
            for (int i = 0; i < 4; ++i) {
                int idx = i + this.scrollOffset;
                if (idx >= this.entries.size()) continue;
                int entryY = this.getY() + (i + 1) * 20;
                SelectionEntry entry = (SelectionEntry)this.entries.get(idx);
                entry.render(graphics, this.getX() + 1, entryY, this.width - 2, entry == hoverEntry, fgColor, this.alpha);
            }
            if (this.entries.size() > 4) {
                float scale = 4.0f / (float)this.entries.size();
                int scrollY = this.getY() + (int)((float)(20 * this.scrollOffset) * scale) + 20;
                int barHeight = (int)(80.0f * scale + 1.0f);
                int scrollBotY = Math.min(scrollY + barHeight, this.getY() + 20 + boxHeight - 2);
                graphics.fill(this.getX() + this.width - 5, scrollY, this.getX() + this.width - 1, scrollBotY, -10066330);
                graphics.fill(this.getX() + this.width - 4, scrollY + 1, this.getX() + this.width - 2, scrollBotY - 1, -5592406);
            }
        } else {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARROW_DOWN, this.getX() + this.width - 17 - 18, this.getY() + 6 - 20, 32, 32);
        }
    }

    public int getHeight() {
        if (this.extended) {
            return 20 * (Math.min(this.entries.size(), 4) + 1) + 1;
        }
        return 20;
    }

    public void onPress(InputWithModifiers input) {
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.active && event.x() >= (double)this.getX() && event.x() <= (double)(this.getX() + this.width) && event.y() >= (double)this.getY() && event.y() <= (double)(this.getY() + this.getHeight())) {
            int maxX = this.getX() + this.width - (this.entries.size() > 4 ? 5 : 0);
            int maxY = this.getY() + 20 * Math.min(this.entries.size() + 1, 5);
            if (this.extended && event.x() < (double)maxX && event.y() > (double)(this.getY() + 20) && event.y() < (double)maxY) {
                this.setSelected(this.getEntryAtPosition(event.x(), event.y()), true);
            }
            if (event.y() < (double)(this.getY() + 20) && event.x() < (double)(this.getX() + this.width) || event.x() < (double)maxX) {
                this.toggleExtended();
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        this.extended = false;
        this.scrollOffset = 0;
        return super.mouseClicked(event, doubleClick);
    }

    public boolean keyPressed(KeyEvent event) {
        boolean hasFocused;
        boolean bl = hasFocused = this.extended && this.focused != null;
        if (this.active && this.visible && (this.isFocused() || hasFocused) && event.isSelection()) {
            if (this.isFocused()) {
                this.toggleExtended();
            } else if (hasFocused) {
                this.setSelected(this.focused, true);
                this.toggleExtended();
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return false;
    }

    private void toggleExtended() {
        this.extended = !this.extended;
        this.scrollOffset = 0;
        if (this.extended && this.selected != null) {
            this.owner.setFocused(this.selected);
            this.scrollOffset = Math.min(this.entries.indexOf(this.selected), this.entries.size() - 4);
        } else if (!this.extended && this.focused != null) {
            this.focused = null;
            this.owner.setFocused((GuiEventListener)this);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int maxY = this.getY() + 20 * Math.min(this.entries.size() + 1, 5);
        if (this.extended && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY > (double)(this.getY() + 20) && mouseY < (double)maxY) {
            if (deltaY < 0.0 && this.scrollOffset < this.entries.size() - 4) {
                ++this.scrollOffset;
            } else if (deltaY > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if (!this.active || !this.visible) {
            return false;
        }
        return pMouseX >= (double)this.getX() && pMouseY >= (double)this.getY() && pMouseX < (double)(this.getX() + this.width) && pMouseY < (double)(this.getY() + this.getHeight());
    }

    @Nullable
    private T getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.getX() || mouseX > (double)(this.getX() + this.width) || mouseY < (double)(this.getY() + 20) || mouseY > (double)(this.getY() + 100)) {
            return null;
        }
        double posY = mouseY - (double)(this.getY() + 20);
        int idx = (int)(posY / 20.0) + this.scrollOffset;
        return (T)(idx < this.entries.size() ? (SelectionEntry)this.entries.get(idx) : null);
    }

    void focusAndScrollTo(T entry) {
        this.focused = entry;
        int idx = this.entries.indexOf(entry);
        if (idx < 0 || idx >= this.entries.size()) {
            return;
        }
        if (idx < this.scrollOffset) {
            this.scrollOffset = idx;
        } else if (idx > this.scrollOffset + 3) {
            this.scrollOffset = idx - 3;
        }
    }

    public void addEntry(T entry) {
        this.entries.add(entry);
        ((SelectionEntry)entry).captureOwner(this);
    }

    public void setSelected(@Nullable T selected, boolean notify) {
        this.selected = selected;
        if (notify && this.selectCallback != null && selected != null) {
            this.selectCallback.accept(selected);
        }
    }

    @Nullable
    public T getSelected() {
        return this.selected;
    }

    public Stream<T> stream() {
        return this.entries.stream();
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (this.entries.isEmpty() || !this.extended || !(event instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.nextFocusPath(event);
        }
        ScreenDirection dir = ((FocusNavigationEvent.ArrowNavigation)event).direction();
        if (dir.getAxis() == ScreenAxis.HORIZONTAL) {
            return null;
        }
        if (this.isFocused() && this.focused != null) {
            return ComponentPath.leaf(this.focused);
        }
        return switch (dir) {
            case ScreenDirection.UP -> ComponentPath.leaf((GuiEventListener)((GuiEventListener)this.entries.getLast()));
            case ScreenDirection.DOWN -> ComponentPath.leaf((GuiEventListener)((GuiEventListener)this.entries.getFirst()));
            default -> throw new IllegalStateException("Unreachable");
        };
    }

    @Nullable
    public T getFocusNeighbour(T entry, ScreenDirection dir) {
        int idx = this.entries.indexOf(entry);
        return (T)(switch (dir) {
            case ScreenDirection.DOWN -> {
                if (idx < this.entries.size() - 1) {
                    yield (SelectionEntry)this.entries.get(idx + 1);
                }
                yield (SelectionEntry)this.entries.getFirst();
            }
            case ScreenDirection.UP -> {
                if (idx > 0) {
                    yield (SelectionEntry)this.entries.get(idx - 1);
                }
                yield (SelectionEntry)this.entries.getLast();
            }
            default -> null;
        });
    }

    public static class SelectionEntry<T extends SelectionEntry<T>>
    implements GuiEventListener {
        private final Component message;
        @Nullable
        private SelectionWidget<T> owner = null;
        boolean focused = false;

        public SelectionEntry(Component message) {
            this.message = message;
        }

        public void render(GuiGraphics graphics, int x, int y, int width, boolean hovered, int fgColor, float alpha) {
            if (hovered || this.focused) {
                graphics.fill(x, y, x + width, y + 20, -6250336);
            }
            Font font = Minecraft.getInstance().font;
            FormattedCharSequence text = Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)this.message, width - 12)}));
            graphics.drawString(font, text, x + 6, y + 6, fgColor | Mth.ceil((float)(alpha * 255.0f)) << 24);
        }

        public boolean keyPressed(KeyEvent event) {
            if (this.isFocused()) {
                return Objects.requireNonNull(this.owner).keyPressed(event);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            SelectionEntry entry;
            if (!this.isFocused() || !(event instanceof FocusNavigationEvent.ArrowNavigation)) return null;
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            try {
                ScreenDirection screenDirection;
                ScreenDirection dir = screenDirection = arrowNavigation.direction();
                entry = Objects.requireNonNull(this.owner).getFocusNeighbour(this, dir);
                if (entry == null) return null;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return ComponentPath.leaf((GuiEventListener)entry);
        }

        public final void setFocused(boolean focused) {
            this.focused = focused;
            if (focused) {
                Objects.requireNonNull(this.owner).focusAndScrollTo(this);
            }
        }

        public final boolean isFocused() {
            return this.focused;
        }

        void captureOwner(SelectionWidget<T> owner) {
            this.owner = owner;
        }
    }
}

