/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget.search;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.client.screen.widget.search.SearchButton;
import xfacthd.atlasviewer.client.screen.widget.search.SearchEditBox;
import xfacthd.atlasviewer.client.screen.widget.search.SearchHandler;
import xfacthd.atlasviewer.client.util.IVisibilitySetter;

public final class SearchBox
extends AbstractWidget
implements IVisibilitySetter {
    static final int BUTTON_WIDTH = 63;
    static final int PADDING = 2;
    private static final long DEBOUNCE_DELAY_MS = 250L;
    private final SearchHandler handler;
    final SearchEditBox editBox;
    final SearchButton button;
    private boolean changed = false;
    private String lastQuery = "";
    private long lastChange = 0L;

    public SearchBox(int x, int y, int width, int height, @Nullable SearchBox prev, SearchHandler handler, Consumer<AbstractWidget> registrar) {
        super(x, y, width, height, (Component)Component.empty());
        this.handler = handler;
        this.editBox = new SearchEditBox(x, y, width - 63 - 2, height, prev != null ? prev.editBox : null);
        this.button = new SearchButton(x + 63 + 2, y, 63, height, handler);
        this.editBox.setResponder(this::onSearchChanged);
        registrar.accept((AbstractWidget)this.editBox);
        registrar.accept((AbstractWidget)this.button);
    }

    private void onSearchChanged(String text) {
        this.changed = true;
        this.lastQuery = text;
        this.lastChange = System.currentTimeMillis();
        if (this.lastQuery.isEmpty()) {
            this.button.active = false;
        }
    }

    public void tick() {
        if (this.changed && System.currentTimeMillis() - this.lastChange > 250L) {
            this.changed = false;
            this.handler.updateSearch(this.lastQuery);
            this.button.active = !this.lastQuery.isEmpty();
        }
    }

    public void clear() {
        this.editBox.setValue("");
        this.button.active = false;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void updateWidgetNarration(NarrationElementOutput out) {
    }

    public void setX(int x) {
        super.setX(x);
        this.editBox.setX(x);
        this.button.setX(x + this.width - 63);
    }

    public void setY(int y) {
        super.setY(y);
        this.editBox.setY(y);
        this.button.setY(y);
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.editBox.setWidth(width - 63 - 2);
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.editBox.setHeight(height);
        this.button.setHeight(height);
    }

    @Override
    public void atlasviewer$setVisible(boolean visible) {
        this.visible = visible;
        this.editBox.visible = visible;
        this.button.visible = visible;
    }
}

