/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.screen.widget.search;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import xfacthd.atlasviewer.client.screen.widget.search.SearchHandler;

public final class SearchButton
extends Button {
    private final SearchHandler handler;

    public SearchButton(int x, int y, int width, int height, SearchHandler handler) {
        super(x, y, width, height, (Component)Component.empty(), btn -> {}, Button.DEFAULT_NARRATION);
        this.handler = handler;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.active) {
            int count = this.handler.getResultCount();
            int focusedIdx = this.handler.getFocusedResultIndex();
            String text = focusedIdx > -1 ? "%d/%d".formatted(focusedIdx + 1, count) : Integer.toString(count);
            graphics.pose().pushMatrix();
            Font font = Minecraft.getInstance().font;
            int length = font.width(text);
            boolean scale = length > this.width - 9;
            float x = (float)(this.getX() + this.width - 3) - (float)font.width(text) * (scale ? 0.5f : 1.0f);
            float y = (float)this.getY() + 5.0f + (scale ? 2.0f : 0.0f);
            graphics.pose().translate(x, y);
            if (scale) {
                graphics.pose().scale(0.5f, 0.5f);
            }
            graphics.drawString(font, text, 0, 0, count > 0 ? -1 : 0xFF0000);
            graphics.pose().popMatrix();
        }
    }

    public boolean isHovered() {
        return this.active && super.isHovered();
    }

    public void onPress(InputWithModifiers input) {
        this.handler.jumpToNextResult();
    }
}

