/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import xfacthd.atlasviewer.client.screen.state.FloatBlitRenderState;
import xfacthd.atlasviewer.client.screen.state.FloatColoredRectangleRenderState;
import xfacthd.atlasviewer.platform.Services;

public final class ClientUtils {
    @Nullable
    private static Boolean arbClearTextureSupported = null;

    public static boolean isArbClearTextureSupported() {
        if (arbClearTextureSupported == null) {
            GLCapabilities capabilities = GL.getCapabilities();
            arbClearTextureSupported = capabilities.GL_ARB_clear_texture;
        }
        return arbClearTextureSupported;
    }

    public static int getWrappedHeight(Font font, FormattedText text, int width) {
        int n = font.split(text, width).size();
        Objects.requireNonNull(font);
        return n * 9;
    }

    public static void drawColoredBox(GuiGraphics graphics, int x, int y, int w, int h, int color) {
        graphics.fill(RenderPipelines.GUI, x, y, x + 1, y + h, color);
        graphics.fill(RenderPipelines.GUI, x + w - 1, y, x + w, y + h, color);
        graphics.fill(RenderPipelines.GUI, x, y, x + w, y + 1, color);
        graphics.fill(RenderPipelines.GUI, x, y + h - 1, x + w, y + h, color);
    }

    public static void drawColoredBox(GuiGraphics graphics, float x, float y, float w, float h, int color) {
        ClientUtils.fill(graphics, RenderPipelines.GUI, x, y, x + 1.0f, y + h, color);
        ClientUtils.fill(graphics, RenderPipelines.GUI, x + w - 1.0f, y, x + w, y + h, color);
        ClientUtils.fill(graphics, RenderPipelines.GUI, x, y, x + w, y + 1.0f, color);
        ClientUtils.fill(graphics, RenderPipelines.GUI, x, y + h - 1.0f, x + w, y + h, color);
    }

    public static void fill(GuiGraphics graphics, RenderPipeline pipeline, float minX, float minY, float maxX, float maxY, int color) {
        ClientUtils.fill(graphics, pipeline, minX, minY, maxX, maxY, color, color);
    }

    public static void fill(GuiGraphics graphics, RenderPipeline pipeline, float minX, float minY, float maxX, float maxY, int colorOne, int colorTwo) {
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.pose());
        ScreenRectangle scissorRect = Services.PLATFORM.peekScissorState(graphics);
        ScreenRectangle bounds = ClientUtils.getBounds(minX, minY, maxX, maxY, pose, scissorRect);
        Services.PLATFORM.submitCustomGuiRenderState(graphics, new FloatColoredRectangleRenderState(pipeline, pose, minX, minY, maxX, maxY, colorOne, colorTwo, scissorRect, bounds));
    }

    public static void blitSpecial(GuiGraphics graphics, RenderPipeline pipeline, TextureSetup textureSetup, float minX, float minY, float maxX, float maxY, float minU, float maxU, float minV, float maxV, int color) {
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.pose());
        ScreenRectangle scissorRect = Services.PLATFORM.peekScissorState(graphics);
        ScreenRectangle bounds = ClientUtils.getBounds(minX, minY, maxX, maxY, pose, scissorRect);
        Services.PLATFORM.submitCustomGuiRenderState(graphics, new FloatBlitRenderState(pipeline, textureSetup, pose, minX, minY, maxX, maxY, minU, maxU, minV, maxV, color, scissorRect, bounds));
    }

    @Nullable
    public static ScreenRectangle getBounds(float x0, float y0, float x1, float y1, Matrix3x2f pose, @javax.annotation.Nullable ScreenRectangle scissorRect) {
        int x0i = Mth.floor((float)x0);
        int y0i = Mth.floor((float)y0);
        int x1i = Mth.ceil((float)x1);
        int y1i = Mth.ceil((float)y1);
        ScreenRectangle rect = new ScreenRectangle(x0i, y0i, x1i - x0i, y1i - y0i).transformMaxBounds(pose);
        return scissorRect != null ? scissorRect.intersection(rect) : rect;
    }

    public static void downloadTexture(GpuTexture srcTexture, int mipLevel, Consumer<NativeImage> imageConsumer) {
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder cmdEncoder = device.createCommandEncoder();
        int width = srcTexture.getWidth(mipLevel);
        int height = srcTexture.getHeight(mipLevel);
        int pixSize = srcTexture.getFormat().pixelSize();
        int bufSize = width * height * pixSize;
        GpuBuffer buffer = device.createBuffer(() -> "Texture output buffer", 9, bufSize);
        Services.PLATFORM.fixMipLevelTexParams(srcTexture);
        cmdEncoder.copyTextureToBuffer(srcTexture, buffer, 0, () -> {
            try (GpuBuffer.MappedView bufView = cmdEncoder.mapBuffer(buffer, true, false);
                 NativeImage destImage = new NativeImage(width, height, false);){
                ByteBuffer data = bufView.data();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = data.getInt((x + y * width) * pixSize);
                        destImage.setPixelABGR(x, y, pixel);
                    }
                }
                imageConsumer.accept(destImage);
            }
            buffer.close();
        }, mipLevel);
    }

    private ClientUtils() {
    }
}

