/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.atlasviewer.client.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;
import xfacthd.atlasviewer.client.AVClient;
import xfacthd.atlasviewer.client.api.ISpriteSourcePackAwareSpriteSupplier;
import xfacthd.atlasviewer.client.api.SourceAwareness;
import xfacthd.atlasviewer.client.api.SourceTooltipAppender;
import xfacthd.atlasviewer.client.mixin.AccessorSpriteSources;
import xfacthd.atlasviewer.client.util.WrappedSpriteSource;
import xfacthd.atlasviewer.client.util.WrappedSpriteSupplier;
import xfacthd.atlasviewer.platform.Services;

public final class SpriteSourceManager {
    private static final Component LABEL_FULL_TYPE = Component.translatable((String)"label.atlasviewer.source_tooltip.full_type");
    private static final Component LABEL_REG_NAME = Component.translatable((String)"label.atlasviewer.source_tooltip.reg_name");
    private static final Component VALUE_UNREGISTERED = Component.translatable((String)"value.atlasviewer.source_tooltip.unregistered").withStyle(s -> s.withColor(0xD00000));
    private static final Map<Class<? extends SpriteSource.SpriteSupplier>, Function<SpriteSource.SpriteSupplier, Resource>> PRIMARY_RESOURCE_GETTERS = new IdentityHashMap<Class<? extends SpriteSource.SpriteSupplier>, Function<SpriteSource.SpriteSupplier, Resource>>();
    private static final Map<Class<? extends SpriteSource>, Function<SpriteSource, String>> SOURCE_STRINGIFIERS = new IdentityHashMap<Class<? extends SpriteSource>, Function<SpriteSource, String>>();
    private static final Map<Class<?>, String> SPECIAL_SOURCE_DESCRIPTIONS = new IdentityHashMap();
    private static final Map<Class<? extends SpriteSource>, SourceTooltipAppender<SpriteSource>> SOURCE_TOOLTIP_APPENDERS = new IdentityHashMap<Class<? extends SpriteSource>, SourceTooltipAppender<SpriteSource>>();
    private static boolean locked = true;

    public static <T extends SpriteSource.SpriteSupplier> void registerPrimaryResourceGetter(Class<T> supplierType, Function<T, Resource> resourceGetter) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (PRIMARY_RESOURCE_GETTERS.put(supplierType, resourceGetter) != null) {
            throw new IllegalStateException("Supplier type '%s' had a previous mapping".formatted(supplierType));
        }
    }

    public static <T extends SpriteSource> void registerSourceStringifier(Class<T> sourceType, Function<T, String> stringifier) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (SOURCE_STRINGIFIERS.put(sourceType, stringifier) != null) {
            throw new IllegalStateException("Source type '%s' had a previous mapping".formatted(sourceType));
        }
    }

    public static <T extends SpriteSource> void registerSimpleSourceStringifier(Class<T> sourceType, Function<T, String> stringifier) {
        SpriteSourceManager.registerSourceStringifier(sourceType, src -> "'%s' ('%s')".formatted(Services.PLATFORM.getSpriteSourceSimpleName((SpriteSource)src), stringifier.apply(src)));
    }

    public static <T extends SpriteSource> void registerSpecialSourceDescription(Class<T> sourceType, String description) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (SPECIAL_SOURCE_DESCRIPTIONS.put(sourceType, description) != null) {
            throw new IllegalStateException("Source type '%s' had a previous mapping".formatted(sourceType));
        }
    }

    public static <T extends SpriteSource> void registerSourceTooltipAppender(Class<T> sourceType, SourceTooltipAppender<T> appender) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"Registration is locked");
        if (SOURCE_TOOLTIP_APPENDERS.put(sourceType, appender) != null) {
            throw new IllegalStateException("Source type '%s' had a previous mapping".formatted(sourceType));
        }
    }

    public static void copySpriteSupplierMetaToSpriteContents(Function<SpriteResourceLoader, SpriteContents> function, @Nullable SpriteContents contents) {
        if (contents == null) {
            return;
        }
        if (!(function instanceof SpriteSource.SpriteSupplier)) {
            contents.atlasviewer$setSpriteSourceSourcePack(null, null, SourceAwareness.SPRITESUPPLIER_UNSUPPORTED, null, null);
            return;
        }
        SpriteSource.SpriteSupplier supplier = (SpriteSource.SpriteSupplier)function;
        SpriteSource.SpriteSupplier unwrappedSupplier = WrappedSpriteSupplier.resolve(supplier);
        Function<SpriteSource.SpriteSupplier, Resource> resourceGetter = PRIMARY_RESOURCE_GETTERS.get(unwrappedSupplier.getClass());
        if (resourceGetter != null) {
            contents.atlasviewer$captureMetaFromSpriteSupplier(supplier, resourceGetter.apply(unwrappedSupplier));
        } else if (!(unwrappedSupplier instanceof ISpriteSourcePackAwareSpriteSupplier)) {
            contents.atlasviewer$setSpriteSourceSourcePack(null, null, SourceAwareness.SPRITESUPPLIER_UNSUPPORTED, null, null);
        }
    }

    public static String stringifySpriteSource(SpriteSource source) {
        source = WrappedSpriteSource.resolve(source);
        return SOURCE_STRINGIFIERS.getOrDefault(source.getClass(), SpriteSource::toString).apply(source);
    }

    @Nullable
    public static String getSpecialDescription(Class<?> sourceType) {
        return SPECIAL_SOURCE_DESCRIPTIONS.get(sourceType);
    }

    public static List<Tuple<Component, Component>> buildSourceTooltip(SpriteSource source, String typeName) {
        ArrayList<Tuple<Component, Component>> lines = new ArrayList<Tuple<Component, Component>>();
        source = WrappedSpriteSource.resolve(source);
        ResourceLocation regLoc = (ResourceLocation)AccessorSpriteSources.atlasviewer$getTypes().atlasviewer$getKey((Object)source.codec());
        Component regName = regLoc != null ? Component.literal((String)regLoc.toString()) : VALUE_UNREGISTERED;
        lines.add(new Tuple((Object)LABEL_REG_NAME, (Object)regName));
        SourceTooltipAppender<SpriteSource> appender = SOURCE_TOOLTIP_APPENDERS.get(source.getClass());
        if (appender != null) {
            appender.accept(source, (title, content) -> lines.add(new Tuple((Object)title, (Object)content)));
        }
        lines.add(new Tuple((Object)LABEL_FULL_TYPE, (Object)Component.literal((String)typeName)));
        return lines;
    }

    public static void registerDetails() {
        locked = false;
        AVClient.registerBuiltInSpriteSourceDetails();
        Services.PLATFORM.registerPlatformSpecificBuiltInSpriteSourceDetails();
        Services.PLATFORM.fireSpriteSourceDetailsEvent();
        locked = true;
    }

    private SpriteSourceManager() {
    }
}

